/*
 * Decompiled with CFR 0.152.
 */
package com.rxandroidnetworking;

import android.net.TrafficStats;
import com.androidnetworking.common.ANLog;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.common.ANResponse;
import com.androidnetworking.common.ConnectionClassManager;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.AnalyticsListener;
import com.androidnetworking.internal.InternalNetworking;
import com.androidnetworking.internal.RequestProgressBody;
import com.androidnetworking.internal.ResponseProgressBody;
import com.androidnetworking.utils.SourceCloseUtil;
import com.androidnetworking.utils.Utils;
import com.rxandroidnetworking.RxANRequest;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;

public class RxInternalNetworking {
    public static <T> Observable<T> generateSimpleObservable(RxANRequest request) {
        Request.Builder builder = new Request.Builder().url(request.getUrl());
        InternalNetworking.addHeadersToRequestBuilder((Request.Builder)builder, (ANRequest)request);
        switch (request.getMethod()) {
            case 0: {
                builder = builder.get();
                break;
            }
            case 1: {
                RequestBody requestBody = request.getRequestBody();
                builder = builder.post(requestBody);
                break;
            }
            case 2: {
                RequestBody requestBody = request.getRequestBody();
                builder = builder.put(requestBody);
                break;
            }
            case 3: {
                RequestBody requestBody = request.getRequestBody();
                builder = builder.delete(requestBody);
                break;
            }
            case 4: {
                builder = builder.head();
                break;
            }
            case 5: {
                RequestBody requestBody = request.getRequestBody();
                builder = builder.patch(requestBody);
            }
        }
        if (request.getCacheControl() != null) {
            builder.cacheControl(request.getCacheControl());
        }
        Request okHttpRequest = builder.build();
        if (request.getOkHttpClient() != null) {
            request.setCall(request.getOkHttpClient().newBuilder().cache(InternalNetworking.sHttpClient.cache()).build().newCall(okHttpRequest));
        } else {
            request.setCall(InternalNetworking.sHttpClient.newCall(okHttpRequest));
        }
        ANLog.d((String)"call generated successfully for simple observable");
        return Observable.create(new ANOnSubscribe(request));
    }

    public static <T> Observable<T> generateDownloadObservable(final RxANRequest request) {
        Request.Builder builder = new Request.Builder().url(request.getUrl());
        InternalNetworking.addHeadersToRequestBuilder((Request.Builder)builder, (ANRequest)request);
        builder = builder.get();
        if (request.getCacheControl() != null) {
            builder.cacheControl(request.getCacheControl());
        }
        Request okHttpRequest = builder.build();
        OkHttpClient okHttpClient = request.getOkHttpClient() != null ? request.getOkHttpClient().newBuilder().cache(InternalNetworking.sHttpClient.cache()).addNetworkInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ResponseProgressBody(originalResponse.body(), request.getDownloadProgressListener())).build();
            }
        }).build() : InternalNetworking.sHttpClient.newBuilder().addNetworkInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ResponseProgressBody(originalResponse.body(), request.getDownloadProgressListener())).build();
            }
        }).build();
        request.setCall(okHttpClient.newCall(okHttpRequest));
        return Observable.create(new ANOnSubscribe(request));
    }

    public static <T> Observable<T> generateMultipartObservable(RxANRequest request) {
        return Observable.create(new ANOnSubscribe(request));
    }

    static final class MultipartANResolver<T>
    extends AtomicBoolean
    implements Subscription,
    Producer {
        private final RxANRequest request;
        private final Subscriber<? super T> subscriber;

        MultipartANResolver(RxANRequest request, Subscriber<? super T> subscriber) {
            this.request = request;
            this.subscriber = subscriber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void request(long n) {
            block28: {
                if (n < 0L) {
                    throw new IllegalArgumentException("n < 0: " + n);
                }
                if (n == 0L) {
                    return;
                }
                if (!this.compareAndSet(false, true)) {
                    return;
                }
                Response okHttpResponse = null;
                try {
                    Request.Builder builder = new Request.Builder().url(this.request.getUrl());
                    InternalNetworking.addHeadersToRequestBuilder((Request.Builder)builder, (ANRequest)this.request);
                    RequestBody requestBody = this.request.getMultiPartRequestBody();
                    long requestBodyLength = requestBody.contentLength();
                    builder = builder.post((RequestBody)new RequestProgressBody(requestBody, this.request.getUploadProgressListener()));
                    if (this.request.getCacheControl() != null) {
                        builder.cacheControl(this.request.getCacheControl());
                    }
                    Request okHttpRequest = builder.build();
                    if (this.request.getOkHttpClient() != null) {
                        this.request.setCall(this.request.getOkHttpClient().newBuilder().cache(InternalNetworking.sHttpClient.cache()).build().newCall(okHttpRequest));
                    } else {
                        this.request.setCall(InternalNetworking.sHttpClient.newCall(okHttpRequest));
                    }
                    long startTime = System.currentTimeMillis();
                    okHttpResponse = this.request.getCall().execute();
                    long timeTaken = System.currentTimeMillis() - startTime;
                    if (this.request.getAnalyticsListener() != null) {
                        if (okHttpResponse.cacheResponse() == null) {
                            Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)requestBodyLength, (long)okHttpResponse.body().contentLength(), (boolean)false);
                        } else if (okHttpResponse.networkResponse() == null) {
                            Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)0L, (long)0L, (boolean)true);
                        } else {
                            Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)(requestBodyLength != 0L ? requestBodyLength : -1L), (long)0L, (boolean)true);
                        }
                    }
                    if (okHttpResponse.code() >= 400) {
                        if (!this.subscriber.isUnsubscribed()) {
                            this.subscriber.onError((Throwable)Utils.getErrorForServerResponse((ANError)new ANError(okHttpResponse), (ANRequest)this.request, (int)okHttpResponse.code()));
                        }
                    } else {
                        ANResponse response = this.request.parseResponse(okHttpResponse);
                        if (!response.isSuccess()) {
                            if (!this.subscriber.isUnsubscribed()) {
                                this.subscriber.onError((Throwable)response.getError());
                            }
                        } else {
                            if (!this.subscriber.isUnsubscribed()) {
                                this.subscriber.onNext(response.getResult());
                            }
                            if (!this.subscriber.isUnsubscribed()) {
                                this.subscriber.onCompleted();
                            }
                        }
                    }
                    SourceCloseUtil.close((Response)okHttpResponse, (ANRequest)this.request);
                }
                catch (IOException ioe) {
                    if (!this.subscriber.isUnsubscribed()) {
                        this.subscriber.onError((Throwable)Utils.getErrorForConnection((ANError)new ANError((Throwable)ioe)));
                    }
                }
                catch (Exception e) {
                    Exceptions.throwIfFatal((Throwable)e);
                    if (!this.subscriber.isUnsubscribed()) {
                        this.subscriber.onError((Throwable)Utils.getErrorForNetworkOnMainThreadOrConnection((Exception)e));
                    }
                    break block28;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    SourceCloseUtil.close(okHttpResponse, (ANRequest)this.request);
                }
            }
        }

        public void unsubscribe() {
            if (this.request.getCall() != null) {
                this.request.getCall().cancel();
            }
        }

        public boolean isUnsubscribed() {
            return this.request.getCall() != null && this.request.getCall().isCanceled();
        }
    }

    static final class DownloadANResolver<T>
    extends AtomicBoolean
    implements Subscription,
    Producer {
        private final Call call;
        private final RxANRequest request;
        private final Subscriber<? super T> subscriber;

        DownloadANResolver(RxANRequest request, Subscriber<? super T> subscriber) {
            this.request = request;
            this.call = request.getCall();
            this.subscriber = subscriber;
        }

        public void request(long n) {
            block18: {
                if (n < 0L) {
                    throw new IllegalArgumentException("n < 0: " + n);
                }
                if (n == 0L) {
                    return;
                }
                if (!this.compareAndSet(false, true)) {
                    return;
                }
                try {
                    ANLog.d((String)"initiate download network call observable");
                    long startTime = System.currentTimeMillis();
                    long startBytes = TrafficStats.getTotalRxBytes();
                    Response okHttpResponse = this.request.getCall().execute();
                    Utils.saveFile((Response)okHttpResponse, (String)this.request.getDirPath(), (String)this.request.getFileName());
                    long timeTaken = System.currentTimeMillis() - startTime;
                    if (okHttpResponse.cacheResponse() == null) {
                        long finalBytes = TrafficStats.getTotalRxBytes();
                        long diffBytes = startBytes == -1L || finalBytes == -1L ? okHttpResponse.body().contentLength() : finalBytes - startBytes;
                        ConnectionClassManager.getInstance().updateBandwidth(diffBytes, timeTaken);
                        Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)-1L, (long)okHttpResponse.body().contentLength(), (boolean)false);
                    } else if (this.request.getAnalyticsListener() != null) {
                        Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)-1L, (long)0L, (boolean)true);
                    }
                    if (okHttpResponse.code() >= 400) {
                        if (!this.subscriber.isUnsubscribed()) {
                            this.subscriber.onError((Throwable)Utils.getErrorForServerResponse((ANError)new ANError(okHttpResponse), (ANRequest)this.request, (int)okHttpResponse.code()));
                        }
                    } else {
                        if (!this.subscriber.isUnsubscribed()) {
                            ANResponse response = ANResponse.success((Object)"success");
                            this.subscriber.onNext(response.getResult());
                        }
                        if (!this.subscriber.isUnsubscribed()) {
                            this.subscriber.onCompleted();
                        }
                    }
                }
                catch (IOException ioe) {
                    try {
                        File destinationFile = new File(this.request.getDirPath() + File.separator + this.request.getFileName());
                        if (destinationFile.exists()) {
                            destinationFile.delete();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (!this.subscriber.isUnsubscribed()) {
                        this.subscriber.onError((Throwable)Utils.getErrorForConnection((ANError)new ANError((Throwable)ioe)));
                    }
                }
                catch (Exception e) {
                    Exceptions.throwIfFatal((Throwable)e);
                    if (this.subscriber.isUnsubscribed()) break block18;
                    this.subscriber.onError((Throwable)Utils.getErrorForNetworkOnMainThreadOrConnection((Exception)e));
                }
            }
        }

        public void unsubscribe() {
            this.call.cancel();
        }

        public boolean isUnsubscribed() {
            return this.call.isCanceled();
        }
    }

    static final class ANResolver<T>
    extends AtomicBoolean
    implements Subscription,
    Producer {
        private final Call call;
        private final RxANRequest request;
        private final Subscriber<? super T> subscriber;

        ANResolver(RxANRequest request, Subscriber<? super T> subscriber) {
            this.request = request;
            this.call = request.getCall();
            this.subscriber = subscriber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void request(long n) {
            Response okHttpResponse;
            block20: {
                if (n < 0L) {
                    throw new IllegalArgumentException("n < 0: " + n);
                }
                if (n == 0L) {
                    return;
                }
                if (!this.compareAndSet(false, true)) {
                    return;
                }
                okHttpResponse = null;
                try {
                    ANLog.d((String)"initiate simple network call observable");
                    long startTime = System.currentTimeMillis();
                    long startBytes = TrafficStats.getTotalRxBytes();
                    okHttpResponse = this.call.execute();
                    long timeTaken = System.currentTimeMillis() - startTime;
                    if (okHttpResponse.cacheResponse() == null) {
                        long finalBytes = TrafficStats.getTotalRxBytes();
                        long diffBytes = startBytes == -1L || finalBytes == -1L ? okHttpResponse.body().contentLength() : finalBytes - startBytes;
                        ConnectionClassManager.getInstance().updateBandwidth(diffBytes, timeTaken);
                        Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)(this.request.getRequestBody() != null && this.request.getRequestBody().contentLength() != 0L ? this.request.getRequestBody().contentLength() : -1L), (long)okHttpResponse.body().contentLength(), (boolean)false);
                    } else if (this.request.getAnalyticsListener() != null) {
                        if (okHttpResponse.networkResponse() == null) {
                            Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)0L, (long)0L, (boolean)true);
                        } else {
                            Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)(this.request.getRequestBody() != null && this.request.getRequestBody().contentLength() != 0L ? this.request.getRequestBody().contentLength() : -1L), (long)0L, (boolean)true);
                        }
                    }
                    if (okHttpResponse.code() == 304) {
                        ANLog.d((String)"error code 304 simple observable");
                        break block20;
                    }
                    if (okHttpResponse.code() >= 400) {
                        if (!this.subscriber.isUnsubscribed()) {
                            ANLog.d((String)"delivering error to subscriber from simple observable");
                            this.subscriber.onError((Throwable)Utils.getErrorForServerResponse((ANError)new ANError(okHttpResponse), (ANRequest)this.request, (int)okHttpResponse.code()));
                        }
                        break block20;
                    }
                    ANResponse response = this.request.parseResponse(okHttpResponse);
                    if (!response.isSuccess()) {
                        if (!this.subscriber.isUnsubscribed()) {
                            ANLog.d((String)"delivering error to subscriber from simple observable");
                            this.subscriber.onError((Throwable)response.getError());
                        }
                        break block20;
                    }
                    if (!this.subscriber.isUnsubscribed()) {
                        ANLog.d((String)"delivering response to subscriber from simple observable");
                        this.subscriber.onNext(response.getResult());
                    }
                    if (this.subscriber.isUnsubscribed()) break block20;
                    ANLog.d((String)"delivering completion to subscriber from simple observable");
                    this.subscriber.onCompleted();
                }
                catch (IOException ioe) {
                    block21: {
                        if (this.subscriber.isUnsubscribed()) break block21;
                        ANLog.d((String)"delivering error to subscriber from simple observable");
                        this.subscriber.onError((Throwable)Utils.getErrorForConnection((ANError)new ANError((Throwable)ioe)));
                    }
                    SourceCloseUtil.close((Response)okHttpResponse, (ANRequest)this.request);
                }
                catch (Exception e) {
                    block22: {
                        Exceptions.throwIfFatal((Throwable)e);
                        if (this.subscriber.isUnsubscribed()) break block22;
                        ANLog.d((String)"delivering error to subscriber from simple observable");
                        this.subscriber.onError((Throwable)Utils.getErrorForNetworkOnMainThreadOrConnection((Exception)e));
                        {
                            catch (Throwable throwable) {
                                SourceCloseUtil.close(okHttpResponse, (ANRequest)this.request);
                                throw throwable;
                            }
                        }
                    }
                    SourceCloseUtil.close((Response)okHttpResponse, (ANRequest)this.request);
                }
            }
            SourceCloseUtil.close((Response)okHttpResponse, (ANRequest)this.request);
        }

        public void unsubscribe() {
            ANLog.d((String)"unsubscribed from simple observable");
            this.call.cancel();
        }

        public boolean isUnsubscribed() {
            return this.call.isCanceled();
        }
    }

    static final class ANOnSubscribe<T>
    implements Observable.OnSubscribe<T> {
        private final RxANRequest request;

        public ANOnSubscribe(RxANRequest request) {
            this.request = request;
        }

        public void call(Subscriber<? super T> subscriber) {
            switch (this.request.getRequestType()) {
                case 0: {
                    ANResolver<? super T> anResolver = new ANResolver<T>(this.request, subscriber);
                    subscriber.add(anResolver);
                    subscriber.setProducer(anResolver);
                    break;
                }
                case 1: {
                    DownloadANResolver<? super T> downloadANResolver = new DownloadANResolver<T>(this.request, subscriber);
                    subscriber.add(downloadANResolver);
                    subscriber.setProducer(downloadANResolver);
                    break;
                }
                case 2: {
                    MultipartANResolver<? super T> multipartANResolver = new MultipartANResolver<T>(this.request, subscriber);
                    subscriber.add(multipartANResolver);
                    subscriber.setProducer(multipartANResolver);
                }
            }
        }
    }
}

