/*
 * Decompiled with CFR 0.152.
 */
package com.rxandroidnetworking;

import android.net.TrafficStats;
import android.os.Build;
import android.os.NetworkOnMainThreadException;
import com.androidnetworking.common.ANData;
import com.androidnetworking.common.ANLog;
import com.androidnetworking.common.ANResponse;
import com.androidnetworking.common.ConnectionClassManager;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.AnalyticsListener;
import com.androidnetworking.internal.InternalNetworking;
import com.androidnetworking.internal.RequestProgressBody;
import com.androidnetworking.internal.ResponseProgressBody;
import com.androidnetworking.utils.Utils;
import com.rxandroidnetworking.RxANRequest;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;

public class RxInternalNetworking {
    public static <T> Observable<T> generateSimpleObservable(RxANRequest request) {
        Request okHttpRequest = null;
        Request.Builder builder = new Request.Builder().url(request.getUrl());
        if (request.getUserAgent() != null) {
            builder.addHeader("User-Agent", request.getUserAgent());
        } else if (InternalNetworking.sUserAgent != null) {
            request.setUserAgent(InternalNetworking.sUserAgent);
            builder.addHeader("User-Agent", InternalNetworking.sUserAgent);
        }
        Headers requestHeaders = request.getHeaders();
        if (requestHeaders != null) {
            builder.headers(requestHeaders);
            if (request.getUserAgent() != null && !requestHeaders.names().contains("User-Agent")) {
                builder.addHeader("User-Agent", request.getUserAgent());
            }
        }
        RequestBody requestBody = null;
        switch (request.getMethod()) {
            case 0: {
                builder = builder.get();
                break;
            }
            case 1: {
                requestBody = request.getRequestBody();
                builder = builder.post(requestBody);
                break;
            }
            case 2: {
                requestBody = request.getRequestBody();
                builder = builder.put(requestBody);
                break;
            }
            case 3: {
                requestBody = request.getRequestBody();
                builder = builder.delete(requestBody);
                break;
            }
            case 4: {
                builder = builder.head();
                break;
            }
            case 5: {
                requestBody = request.getRequestBody();
                builder = builder.patch(requestBody);
            }
        }
        if (request.getCacheControl() != null) {
            builder.cacheControl(request.getCacheControl());
        }
        okHttpRequest = builder.build();
        if (request.getOkHttpClient() != null) {
            request.setCall(request.getOkHttpClient().newBuilder().cache(InternalNetworking.sHttpClient.cache()).build().newCall(okHttpRequest));
        } else {
            request.setCall(InternalNetworking.sHttpClient.newCall(okHttpRequest));
        }
        ANLog.d((String)"call generated successfully for simple observable");
        Observable observable = Observable.create(new ANOnSubscribe(request));
        return observable;
    }

    public static <T> Observable<T> generateDownloadObservable(final RxANRequest request) {
        Request okHttpRequest = null;
        Request.Builder builder = new Request.Builder().url(request.getUrl());
        if (request.getUserAgent() != null) {
            builder.addHeader("User-Agent", request.getUserAgent());
        } else if (InternalNetworking.sUserAgent != null) {
            request.setUserAgent(InternalNetworking.sUserAgent);
            builder.addHeader("User-Agent", InternalNetworking.sUserAgent);
        }
        Headers requestHeaders = request.getHeaders();
        if (requestHeaders != null) {
            builder.headers(requestHeaders);
            if (request.getUserAgent() != null && !requestHeaders.names().contains("User-Agent")) {
                builder.addHeader("User-Agent", request.getUserAgent());
            }
        }
        builder = builder.get();
        if (request.getCacheControl() != null) {
            builder.cacheControl(request.getCacheControl());
        }
        okHttpRequest = builder.build();
        OkHttpClient okHttpClient = request.getOkHttpClient() != null ? request.getOkHttpClient().newBuilder().cache(InternalNetworking.sHttpClient.cache()).addNetworkInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ResponseProgressBody(originalResponse.body(), request.getDownloadProgressListener())).build();
            }
        }).build() : InternalNetworking.sHttpClient.newBuilder().addNetworkInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ResponseProgressBody(originalResponse.body(), request.getDownloadProgressListener())).build();
            }
        }).build();
        request.setCall(okHttpClient.newCall(okHttpRequest));
        Observable observable = Observable.create(new ANOnSubscribe(request));
        return observable;
    }

    public static <T> Observable<T> generateMultipartObservable(RxANRequest request) {
        Observable observable = Observable.create(new ANOnSubscribe(request));
        return observable;
    }

    static final class MultipartANResolver<T>
    extends AtomicBoolean
    implements Subscription,
    Producer {
        private final RxANRequest request;
        private final Subscriber<? super T> subscriber;

        MultipartANResolver(RxANRequest request, Subscriber<? super T> subscriber) {
            this.request = request;
            this.subscriber = subscriber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void request(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("n < 0: " + n);
            }
            if (n == 0L) {
                return;
            }
            if (!this.compareAndSet(false, true)) {
                return;
            }
            ANData data = new ANData();
            Request okHttpRequest = null;
            try {
                Request.Builder builder = new Request.Builder().url(this.request.getUrl());
                if (this.request.getUserAgent() != null) {
                    builder.addHeader("User-Agent", this.request.getUserAgent());
                } else if (InternalNetworking.sUserAgent != null) {
                    this.request.setUserAgent(InternalNetworking.sUserAgent);
                    builder.addHeader("User-Agent", InternalNetworking.sUserAgent);
                }
                Headers requestHeaders = this.request.getHeaders();
                if (requestHeaders != null) {
                    builder.headers(requestHeaders);
                    if (this.request.getUserAgent() != null && !requestHeaders.names().contains("User-Agent")) {
                        builder.addHeader("User-Agent", this.request.getUserAgent());
                    }
                }
                RequestBody requestBody = this.request.getMultiPartRequestBody();
                long requestBodyLength = requestBody.contentLength();
                builder = builder.post((RequestBody)new RequestProgressBody(requestBody, this.request.getUploadProgressListener()));
                if (this.request.getCacheControl() != null) {
                    builder.cacheControl(this.request.getCacheControl());
                }
                okHttpRequest = builder.build();
                if (this.request.getOkHttpClient() != null) {
                    this.request.setCall(this.request.getOkHttpClient().newBuilder().cache(InternalNetworking.sHttpClient.cache()).build().newCall(okHttpRequest));
                } else {
                    this.request.setCall(InternalNetworking.sHttpClient.newCall(okHttpRequest));
                }
                long startTime = System.currentTimeMillis();
                Response okResponse = this.request.getCall().execute();
                data.url = okResponse.request().url();
                data.code = okResponse.code();
                data.headers = okResponse.headers();
                data.body = okResponse.body();
                data.length = data.body.contentLength();
                long timeTaken = System.currentTimeMillis() - startTime;
                if (this.request.getAnalyticsListener() != null) {
                    if (okResponse.cacheResponse() == null) {
                        Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)requestBodyLength, (long)data.length, (boolean)false);
                    } else if (okResponse.networkResponse() == null) {
                        Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)0L, (long)0L, (boolean)true);
                    } else {
                        Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)(requestBodyLength != 0L ? requestBodyLength : -1L), (long)0L, (boolean)true);
                    }
                }
                if (data.code >= 400) {
                    ANError anError = new ANError(data);
                    anError = this.request.parseNetworkError(anError);
                    anError.setErrorCode(data.code);
                    anError.setErrorDetail("responseFromServerError");
                    if (!this.subscriber.isUnsubscribed()) {
                        this.subscriber.onError((Throwable)anError);
                    }
                } else {
                    ANResponse response = this.request.parseResponse(data);
                    if (!response.isSuccess()) {
                        if (!this.subscriber.isUnsubscribed()) {
                            this.subscriber.onError((Throwable)response.getError());
                        }
                    } else {
                        if (!this.subscriber.isUnsubscribed()) {
                            this.subscriber.onNext(response.getResult());
                        }
                        if (!this.subscriber.isUnsubscribed()) {
                            this.subscriber.onCompleted();
                        }
                    }
                }
            }
            catch (IOException ioe) {
                if (okHttpRequest != null) {
                    data.url = okHttpRequest.url();
                }
                if (!this.subscriber.isUnsubscribed()) {
                    ANError anError = new ANError(data, (Throwable)ioe);
                    anError = this.request.parseNetworkError(anError);
                    anError.setErrorDetail("connectionError");
                    anError.setErrorCode(0);
                    this.subscriber.onError((Throwable)anError);
                }
            }
            catch (Exception e) {
                Exceptions.throwIfFatal((Throwable)e);
                ANError se = new ANError((Throwable)e);
                if (Build.VERSION.SDK_INT >= 11 && e instanceof NetworkOnMainThreadException) {
                    se.setErrorDetail("networkOnMainThreadError");
                } else {
                    se.setErrorDetail("connectionError");
                }
                se.setErrorCode(0);
                if (!this.subscriber.isUnsubscribed()) {
                    this.subscriber.onError((Throwable)se);
                }
            }
            finally {
                if (data != null && data.body != null && data.body.source() != null) {
                    try {
                        data.body.source().close();
                    }
                    catch (Exception e) {
                        ANLog.d((String)"Unable to close source data");
                    }
                }
            }
        }

        public void unsubscribe() {
            if (this.request.getCall() != null) {
                this.request.getCall().cancel();
            }
        }

        public boolean isUnsubscribed() {
            return this.request.getCall() != null && this.request.getCall().isCanceled();
        }
    }

    static final class DownloadANResolver<T>
    extends AtomicBoolean
    implements Subscription,
    Producer {
        private final Call call;
        private final RxANRequest request;
        private final Subscriber<? super T> subscriber;

        DownloadANResolver(RxANRequest request, Subscriber<? super T> subscriber) {
            this.request = request;
            this.call = request.getCall();
            this.subscriber = subscriber;
        }

        public void request(long n) {
            block21: {
                if (n < 0L) {
                    throw new IllegalArgumentException("n < 0: " + n);
                }
                if (n == 0L) {
                    return;
                }
                if (!this.compareAndSet(false, true)) {
                    return;
                }
                ANData data = new ANData();
                try {
                    ANLog.d((String)"initiate download network call observable");
                    long startTime = System.currentTimeMillis();
                    long startBytes = TrafficStats.getTotalRxBytes();
                    Response okResponse = this.request.getCall().execute();
                    data.url = okResponse.request().url();
                    data.code = okResponse.code();
                    data.headers = okResponse.headers();
                    Utils.saveFile((Response)okResponse, (String)this.request.getDirPath(), (String)this.request.getFileName());
                    data.length = okResponse.body().contentLength();
                    long timeTaken = System.currentTimeMillis() - startTime;
                    if (okResponse.cacheResponse() == null) {
                        long finalBytes = TrafficStats.getTotalRxBytes();
                        long diffBytes = startBytes == -1L || finalBytes == -1L ? data.length : finalBytes - startBytes;
                        ConnectionClassManager.getInstance().updateBandwidth(diffBytes, timeTaken);
                        Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)-1L, (long)data.length, (boolean)false);
                    } else if (this.request.getAnalyticsListener() != null) {
                        Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)-1L, (long)0L, (boolean)true);
                    }
                    if (data.code >= 400) {
                        ANError anError = new ANError();
                        anError = this.request.parseNetworkError(anError);
                        anError.setErrorCode(data.code);
                        anError.setErrorDetail("responseFromServerError");
                        if (!this.subscriber.isUnsubscribed()) {
                            this.subscriber.onError((Throwable)anError);
                        }
                    } else {
                        if (!this.subscriber.isUnsubscribed()) {
                            ANResponse response = ANResponse.success((Object)"success");
                            this.subscriber.onNext(response.getResult());
                        }
                        if (!this.subscriber.isUnsubscribed()) {
                            this.subscriber.onCompleted();
                        }
                    }
                }
                catch (IOException ioe) {
                    Request okHttpRequest = this.request.getCall().request();
                    if (okHttpRequest != null) {
                        data.url = okHttpRequest.url();
                    }
                    try {
                        File destinationFile = new File(this.request.getDirPath() + File.separator + this.request.getFileName());
                        if (destinationFile.exists()) {
                            destinationFile.delete();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (!this.subscriber.isUnsubscribed()) {
                        ANError anError = new ANError(data, (Throwable)ioe);
                        anError = this.request.parseNetworkError(anError);
                        anError.setErrorDetail("connectionError");
                        anError.setErrorCode(0);
                        this.subscriber.onError((Throwable)anError);
                    }
                }
                catch (Exception e) {
                    Exceptions.throwIfFatal((Throwable)e);
                    ANError se = new ANError((Throwable)e);
                    if (Build.VERSION.SDK_INT >= 11 && e instanceof NetworkOnMainThreadException) {
                        se.setErrorDetail("networkOnMainThreadError");
                    } else {
                        se.setErrorDetail("connectionError");
                    }
                    se.setErrorCode(0);
                    if (this.subscriber.isUnsubscribed()) break block21;
                    this.subscriber.onError((Throwable)se);
                }
            }
        }

        public void unsubscribe() {
            this.call.cancel();
        }

        public boolean isUnsubscribed() {
            return this.call.isCanceled();
        }
    }

    static final class ANResolver<T>
    extends AtomicBoolean
    implements Subscription,
    Producer {
        private final Call call;
        private final RxANRequest request;
        private final Subscriber<? super T> subscriber;

        ANResolver(RxANRequest request, Subscriber<? super T> subscriber) {
            this.request = request;
            this.call = request.getCall();
            this.subscriber = subscriber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void request(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("n < 0: " + n);
            }
            if (n == 0L) {
                return;
            }
            if (!this.compareAndSet(false, true)) {
                return;
            }
            ANData data = new ANData();
            try {
                ANLog.d((String)"initiate simple network call observable");
                long startTime = System.currentTimeMillis();
                long startBytes = TrafficStats.getTotalRxBytes();
                Response okResponse = this.call.execute();
                data.url = okResponse.request().url();
                data.code = okResponse.code();
                data.headers = okResponse.headers();
                data.body = okResponse.body();
                data.length = data.body.contentLength();
                long timeTaken = System.currentTimeMillis() - startTime;
                if (okResponse.cacheResponse() == null) {
                    long finalBytes = TrafficStats.getTotalRxBytes();
                    long diffBytes = startBytes == -1L || finalBytes == -1L ? data.length : finalBytes - startBytes;
                    ConnectionClassManager.getInstance().updateBandwidth(diffBytes, timeTaken);
                    Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)(this.request.getRequestBody() != null && this.request.getRequestBody().contentLength() != 0L ? this.request.getRequestBody().contentLength() : -1L), (long)data.length, (boolean)false);
                } else if (this.request.getAnalyticsListener() != null) {
                    if (okResponse.networkResponse() == null) {
                        Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)0L, (long)0L, (boolean)true);
                    } else {
                        Utils.sendAnalytics((AnalyticsListener)this.request.getAnalyticsListener(), (long)timeTaken, (long)(this.request.getRequestBody() != null && this.request.getRequestBody().contentLength() != 0L ? this.request.getRequestBody().contentLength() : -1L), (long)0L, (boolean)true);
                    }
                }
                if (data.code == 304) {
                    ANLog.d((String)"error code 304 simple observable");
                } else if (data.code >= 400) {
                    ANError anError = new ANError(data);
                    anError = this.request.parseNetworkError(anError);
                    anError.setErrorCode(data.code);
                    anError.setErrorDetail("responseFromServerError");
                    if (!this.subscriber.isUnsubscribed()) {
                        ANLog.d((String)"delivering error to subscriber from simple observable");
                        this.subscriber.onError((Throwable)anError);
                    }
                } else {
                    ANResponse response = this.request.parseResponse(data);
                    if (!response.isSuccess()) {
                        if (!this.subscriber.isUnsubscribed()) {
                            ANLog.d((String)"delivering error to subscriber from simple observable");
                            this.subscriber.onError((Throwable)response.getError());
                        }
                    } else {
                        if (!this.subscriber.isUnsubscribed()) {
                            ANLog.d((String)"delivering response to subscriber from simple observable");
                            this.subscriber.onNext(response.getResult());
                        }
                        if (!this.subscriber.isUnsubscribed()) {
                            ANLog.d((String)"delivering completion to subscriber from simple observable");
                            this.subscriber.onCompleted();
                        }
                    }
                }
            }
            catch (IOException ioe) {
                Request okHttpRequest = this.request.getCall().request();
                if (okHttpRequest != null) {
                    data.url = okHttpRequest.url();
                }
                if (!this.subscriber.isUnsubscribed()) {
                    ANLog.d((String)"delivering error to subscriber from simple observable");
                    ANError anError = new ANError(data, (Throwable)ioe);
                    anError = this.request.parseNetworkError(anError);
                    anError.setErrorDetail("connectionError");
                    anError.setErrorCode(0);
                    this.subscriber.onError((Throwable)anError);
                }
            }
            catch (Exception e) {
                Exceptions.throwIfFatal((Throwable)e);
                ANError se = new ANError((Throwable)e);
                if (Build.VERSION.SDK_INT >= 11 && e instanceof NetworkOnMainThreadException) {
                    se.setErrorDetail("networkOnMainThreadError");
                } else {
                    se.setErrorDetail("connectionError");
                }
                se.setErrorCode(0);
                if (!this.subscriber.isUnsubscribed()) {
                    ANLog.d((String)"delivering error to subscriber from simple observable");
                    this.subscriber.onError((Throwable)se);
                }
            }
            finally {
                if (data != null && data.body != null && data.body.source() != null) {
                    try {
                        data.body.source().close();
                    }
                    catch (Exception e) {
                        ANLog.d((String)"Unable to close source data");
                    }
                }
            }
        }

        public void unsubscribe() {
            ANLog.d((String)"unsubscribed from simple observable");
            this.call.cancel();
        }

        public boolean isUnsubscribed() {
            return this.call.isCanceled();
        }
    }

    static final class ANOnSubscribe<T>
    implements Observable.OnSubscribe<T> {
        private final RxANRequest request;

        public ANOnSubscribe(RxANRequest request) {
            this.request = request;
        }

        public void call(Subscriber<? super T> subscriber) {
            switch (this.request.getRequestType()) {
                case 0: {
                    ANResolver<? super T> anResolver = new ANResolver<T>(this.request, subscriber);
                    subscriber.add(anResolver);
                    subscriber.setProducer(anResolver);
                    break;
                }
                case 1: {
                    DownloadANResolver<? super T> downloadANResolver = new DownloadANResolver<T>(this.request, subscriber);
                    subscriber.add(downloadANResolver);
                    subscriber.setProducer(downloadANResolver);
                    break;
                }
                case 2: {
                    MultipartANResolver<? super T> multipartANResolver = new MultipartANResolver<T>(this.request, subscriber);
                    subscriber.add(multipartANResolver);
                    subscriber.setProducer(multipartANResolver);
                }
            }
        }
    }
}

