/*
 * Decompiled with CFR 0.152.
 */
package com.jacksonandroidnetworking;

import com.androidnetworking.interfaces.Parser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.jacksonandroidnetworking.JacksonRequestBodyParser;
import com.jacksonandroidnetworking.JacksonResponseBodyParser;
import java.lang.reflect.Type;
import java.util.HashMap;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;

public final class JacksonParserFactory
extends Parser.Factory {
    private final ObjectMapper mapper;

    public JacksonParserFactory() {
        this.mapper = new ObjectMapper();
    }

    public JacksonParserFactory(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public Parser<ResponseBody, ?> responseBodyParser(Type type) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        ObjectReader reader = this.mapper.readerFor(javaType);
        return new JacksonResponseBodyParser(reader);
    }

    public Parser<?, RequestBody> requestBodyParser(Type type) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        ObjectWriter writer = this.mapper.writerFor(javaType);
        return new JacksonRequestBodyParser(writer);
    }

    public Object getObject(String string, Type type) {
        try {
            JavaType javaType = this.mapper.getTypeFactory().constructType(type);
            ObjectReader objectReader = this.mapper.readerFor(javaType);
            return objectReader.readValue(string);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getString(Object object) {
        try {
            ObjectWriter objectWriter = this.mapper.writerFor(object.getClass());
            return objectWriter.writeValueAsString(object);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public HashMap<String, String> getStringMap(Object object) {
        try {
            TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
            ObjectWriter objectWriter = this.mapper.writerFor(object.getClass());
            return (HashMap)this.mapper.readValue(objectWriter.writeValueAsString(object), (TypeReference)typeRef);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap<String, String>();
        }
    }
}

