/*
 * Decompiled with CFR 0.152.
 */
package com.androidnetworking.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.androidnetworking.interfaces.DownloadProgressListener;
import com.androidnetworking.model.Progress;

public class DownloadProgressHandler
extends Handler {
    private final DownloadProgressListener mDownloadProgressListenerWeakRef;

    public DownloadProgressHandler(DownloadProgressListener downloadProgressListener) {
        super(Looper.getMainLooper());
        this.mDownloadProgressListenerWeakRef = downloadProgressListener;
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                if (this.mDownloadProgressListenerWeakRef == null) break;
                Progress progress = (Progress)msg.obj;
                this.mDownloadProgressListenerWeakRef.onProgress(progress.currentBytes, progress.totalBytes);
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }
}

