/*
 * Decompiled with CFR 0.152.
 */
package com.androidnetworking.common;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.widget.ImageView;
import com.androidnetworking.common.ANResponse;
import com.androidnetworking.common.Priority;
import com.androidnetworking.common.RequestBuilder;
import com.androidnetworking.common.ResponseType;
import com.androidnetworking.core.Core;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.AnalyticsListener;
import com.androidnetworking.interfaces.BitmapRequestListener;
import com.androidnetworking.interfaces.DownloadListener;
import com.androidnetworking.interfaces.DownloadProgressListener;
import com.androidnetworking.interfaces.JSONArrayRequestListener;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.OkHttpResponseAndBitmapRequestListener;
import com.androidnetworking.interfaces.OkHttpResponseAndJSONArrayRequestListener;
import com.androidnetworking.interfaces.OkHttpResponseAndJSONObjectRequestListener;
import com.androidnetworking.interfaces.OkHttpResponseAndParsedRequestListener;
import com.androidnetworking.interfaces.OkHttpResponseAndStringRequestListener;
import com.androidnetworking.interfaces.OkHttpResponseListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.androidnetworking.interfaces.StringRequestListener;
import com.androidnetworking.interfaces.UploadProgressListener;
import com.androidnetworking.internal.ANRequestQueue;
import com.androidnetworking.internal.SynchronousCall;
import com.androidnetworking.utils.ParseUtil;
import com.androidnetworking.utils.Utils;
import com.google.gson.internal.;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Okio;
import okio.Source;
import org.json.JSONArray;
import org.json.JSONObject;

public class ANRequest<T extends ANRequest> {
    private static final String TAG = ANRequest.class.getSimpleName();
    private int mMethod;
    private Priority mPriority;
    private int mRequestType;
    private String mUrl;
    private int sequenceNumber;
    private Object mTag;
    private ResponseType mResponseType;
    private HashMap<String, String> mHeadersMap = new HashMap();
    private HashMap<String, String> mBodyParameterMap = new HashMap();
    private HashMap<String, String> mUrlEncodedFormBodyParameterMap = new HashMap();
    private HashMap<String, String> mMultiPartParameterMap = new HashMap();
    private HashMap<String, String> mQueryParameterMap = new HashMap();
    private HashMap<String, String> mPathParameterMap = new HashMap();
    private HashMap<String, File> mMultiPartFileMap = new HashMap();
    private String mDirPath;
    private String mFileName;
    private String mApplicationJsonString = null;
    private String mStringBody = null;
    private byte[] mByte = null;
    private File mFile = null;
    private static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private static final MediaType MEDIA_TYPE_MARKDOWN = MediaType.parse((String)"text/x-markdown; charset=utf-8");
    private MediaType customMediaType = null;
    private static final Object sDecodeLock = new Object();
    private Future future;
    private Call call;
    private int mProgress;
    private boolean isCancelled;
    private boolean isDelivered;
    private int mPercentageThresholdForCancelling = 0;
    private JSONArrayRequestListener mJSONArrayRequestListener;
    private JSONObjectRequestListener mJSONObjectRequestListener;
    private StringRequestListener mStringRequestListener;
    private OkHttpResponseListener mOkHttpResponseListener;
    private BitmapRequestListener mBitmapRequestListener;
    private ParsedRequestListener mParsedRequestListener;
    private OkHttpResponseAndJSONObjectRequestListener mOkHttpResponseAndJSONObjectRequestListener;
    private OkHttpResponseAndJSONArrayRequestListener mOkHttpResponseAndJSONArrayRequestListener;
    private OkHttpResponseAndStringRequestListener mOkHttpResponseAndStringRequestListener;
    private OkHttpResponseAndBitmapRequestListener mOkHttpResponseAndBitmapRequestListener;
    private OkHttpResponseAndParsedRequestListener mOkHttpResponseAndParsedRequestListener;
    private DownloadProgressListener mDownloadProgressListener;
    private UploadProgressListener mUploadProgressListener;
    private DownloadListener mDownloadListener;
    private AnalyticsListener mAnalyticsListener;
    private Bitmap.Config mDecodeConfig;
    private int mMaxWidth;
    private int mMaxHeight;
    private ImageView.ScaleType mScaleType;
    private CacheControl mCacheControl = null;
    private Executor mExecutor = null;
    private OkHttpClient mOkHttpClient = null;
    private String mUserAgent = null;
    private Type mType = null;

    public ANRequest(GetRequestBuilder builder) {
        this.mRequestType = 0;
        this.mMethod = builder.mMethod;
        this.mPriority = builder.mPriority;
        this.mUrl = builder.mUrl;
        this.mTag = builder.mTag;
        this.mHeadersMap = builder.mHeadersMap;
        this.mDecodeConfig = builder.mDecodeConfig;
        this.mMaxHeight = builder.mMaxHeight;
        this.mMaxWidth = builder.mMaxWidth;
        this.mScaleType = builder.mScaleType;
        this.mQueryParameterMap = builder.mQueryParameterMap;
        this.mPathParameterMap = builder.mPathParameterMap;
        this.mCacheControl = builder.mCacheControl;
        this.mExecutor = builder.mExecutor;
        this.mOkHttpClient = builder.mOkHttpClient;
        this.mUserAgent = builder.mUserAgent;
    }

    public ANRequest(PostRequestBuilder builder) {
        this.mRequestType = 0;
        this.mMethod = builder.mMethod;
        this.mPriority = builder.mPriority;
        this.mUrl = builder.mUrl;
        this.mTag = builder.mTag;
        this.mHeadersMap = builder.mHeadersMap;
        this.mBodyParameterMap = builder.mBodyParameterMap;
        this.mUrlEncodedFormBodyParameterMap = builder.mUrlEncodedFormBodyParameterMap;
        this.mQueryParameterMap = builder.mQueryParameterMap;
        this.mPathParameterMap = builder.mPathParameterMap;
        this.mApplicationJsonString = builder.mApplicationJsonString;
        this.mStringBody = builder.mStringBody;
        this.mFile = builder.mFile;
        this.mByte = builder.mByte;
        this.mCacheControl = builder.mCacheControl;
        this.mExecutor = builder.mExecutor;
        this.mOkHttpClient = builder.mOkHttpClient;
        this.mUserAgent = builder.mUserAgent;
        if (builder.mCustomContentType != null) {
            this.customMediaType = MediaType.parse((String)builder.mCustomContentType);
        }
    }

    public ANRequest(DownloadBuilder builder) {
        this.mRequestType = 1;
        this.mMethod = 0;
        this.mPriority = builder.mPriority;
        this.mUrl = builder.mUrl;
        this.mTag = builder.mTag;
        this.mDirPath = builder.mDirPath;
        this.mFileName = builder.mFileName;
        this.mHeadersMap = builder.mHeadersMap;
        this.mQueryParameterMap = builder.mQueryParameterMap;
        this.mPathParameterMap = builder.mPathParameterMap;
        this.mCacheControl = builder.mCacheControl;
        this.mPercentageThresholdForCancelling = builder.mPercentageThresholdForCancelling;
        this.mExecutor = builder.mExecutor;
        this.mOkHttpClient = builder.mOkHttpClient;
        this.mUserAgent = builder.mUserAgent;
    }

    public ANRequest(MultiPartBuilder builder) {
        this.mRequestType = 2;
        this.mMethod = 1;
        this.mPriority = builder.mPriority;
        this.mUrl = builder.mUrl;
        this.mTag = builder.mTag;
        this.mHeadersMap = builder.mHeadersMap;
        this.mQueryParameterMap = builder.mQueryParameterMap;
        this.mPathParameterMap = builder.mPathParameterMap;
        this.mMultiPartParameterMap = builder.mMultiPartParameterMap;
        this.mMultiPartFileMap = builder.mMultiPartFileMap;
        this.mCacheControl = builder.mCacheControl;
        this.mPercentageThresholdForCancelling = builder.mPercentageThresholdForCancelling;
        this.mExecutor = builder.mExecutor;
        this.mOkHttpClient = builder.mOkHttpClient;
        this.mUserAgent = builder.mUserAgent;
        if (builder.mCustomContentType != null) {
            this.customMediaType = MediaType.parse((String)builder.mCustomContentType);
        }
    }

    public void getAsJSONObject(JSONObjectRequestListener requestListener) {
        this.mResponseType = ResponseType.JSON_OBJECT;
        this.mJSONObjectRequestListener = requestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsJSONArray(JSONArrayRequestListener requestListener) {
        this.mResponseType = ResponseType.JSON_ARRAY;
        this.mJSONArrayRequestListener = requestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsString(StringRequestListener requestListener) {
        this.mResponseType = ResponseType.STRING;
        this.mStringRequestListener = requestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsOkHttpResponse(OkHttpResponseListener requestListener) {
        this.mResponseType = ResponseType.OK_HTTP_RESPONSE;
        this.mOkHttpResponseListener = requestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsBitmap(BitmapRequestListener requestListener) {
        this.mResponseType = ResponseType.BITMAP;
        this.mBitmapRequestListener = requestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsParsed(TypeToken typeToken, ParsedRequestListener parsedRequestListener) {
        this.mType = typeToken.getType();
        this.mResponseType = ResponseType.PARSED;
        this.mParsedRequestListener = parsedRequestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsObject(Class objectClass, ParsedRequestListener parsedRequestListener) {
        this.mType = objectClass;
        this.mResponseType = ResponseType.PARSED;
        this.mParsedRequestListener = parsedRequestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsObjectList(Class objectClass, ParsedRequestListener parsedRequestListener) {
        this.mType = .Gson.Types.newParameterizedTypeWithOwner(null, List.class, (Type[])new Type[]{objectClass});
        this.mResponseType = ResponseType.PARSED;
        this.mParsedRequestListener = parsedRequestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsOkHttpResponseAndJSONObject(OkHttpResponseAndJSONObjectRequestListener requestListener) {
        this.mResponseType = ResponseType.JSON_OBJECT;
        this.mOkHttpResponseAndJSONObjectRequestListener = requestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsOkHttpResponseAndJSONArray(OkHttpResponseAndJSONArrayRequestListener requestListener) {
        this.mResponseType = ResponseType.JSON_ARRAY;
        this.mOkHttpResponseAndJSONArrayRequestListener = requestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsOkHttpResponseAndString(OkHttpResponseAndStringRequestListener requestListener) {
        this.mResponseType = ResponseType.STRING;
        this.mOkHttpResponseAndStringRequestListener = requestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsOkHttpResponseAndBitmap(OkHttpResponseAndBitmapRequestListener requestListener) {
        this.mResponseType = ResponseType.BITMAP;
        this.mOkHttpResponseAndBitmapRequestListener = requestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsOkHttpResponseAndParsed(TypeToken typeToken, OkHttpResponseAndParsedRequestListener parsedRequestListener) {
        this.mType = typeToken.getType();
        this.mResponseType = ResponseType.PARSED;
        this.mOkHttpResponseAndParsedRequestListener = parsedRequestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsOkHttpResponseAndObject(Class objectClass, OkHttpResponseAndParsedRequestListener parsedRequestListener) {
        this.mType = objectClass;
        this.mResponseType = ResponseType.PARSED;
        this.mOkHttpResponseAndParsedRequestListener = parsedRequestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsOkHttpResponseAndObjectList(Class objectClass, OkHttpResponseAndParsedRequestListener parsedRequestListener) {
        this.mType = .Gson.Types.newParameterizedTypeWithOwner(null, List.class, (Type[])new Type[]{objectClass});
        this.mResponseType = ResponseType.PARSED;
        this.mOkHttpResponseAndParsedRequestListener = parsedRequestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void startDownload(DownloadListener downloadListener) {
        this.mDownloadListener = downloadListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void prefetch() {
        this.mResponseType = ResponseType.PREFETCH;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public ANResponse executeForJSONObject() {
        this.mResponseType = ResponseType.JSON_OBJECT;
        return SynchronousCall.execute(this);
    }

    public ANResponse executeForJSONArray() {
        this.mResponseType = ResponseType.JSON_ARRAY;
        return SynchronousCall.execute(this);
    }

    public ANResponse executeForString() {
        this.mResponseType = ResponseType.STRING;
        return SynchronousCall.execute(this);
    }

    public ANResponse executeForOkHttpResponse() {
        this.mResponseType = ResponseType.OK_HTTP_RESPONSE;
        return SynchronousCall.execute(this);
    }

    public ANResponse executeForBitmap() {
        this.mResponseType = ResponseType.BITMAP;
        return SynchronousCall.execute(this);
    }

    public ANResponse executeForParsed(TypeToken typeToken) {
        this.mType = typeToken.getType();
        this.mResponseType = ResponseType.PARSED;
        return SynchronousCall.execute(this);
    }

    public ANResponse executeForObject(Class objectClass) {
        this.mType = objectClass;
        this.mResponseType = ResponseType.PARSED;
        return SynchronousCall.execute(this);
    }

    public ANResponse executeForObjectList(Class objectClass) {
        this.mType = .Gson.Types.newParameterizedTypeWithOwner(null, List.class, (Type[])new Type[]{objectClass});
        this.mResponseType = ResponseType.PARSED;
        return SynchronousCall.execute(this);
    }

    public ANResponse executeForDownload() {
        return SynchronousCall.execute(this);
    }

    public T setDownloadProgressListener(DownloadProgressListener downloadProgressListener) {
        this.mDownloadProgressListener = downloadProgressListener;
        return (T)this;
    }

    public T setUploadProgressListener(UploadProgressListener uploadProgressListener) {
        this.mUploadProgressListener = uploadProgressListener;
        return (T)this;
    }

    public T setAnalyticsListener(AnalyticsListener analyticsListener) {
        this.mAnalyticsListener = analyticsListener;
        return (T)this;
    }

    public AnalyticsListener getAnalyticsListener() {
        return this.mAnalyticsListener;
    }

    public int getMethod() {
        return this.mMethod;
    }

    public Priority getPriority() {
        return this.mPriority;
    }

    public String getUrl() {
        String tempUrl = this.mUrl;
        for (Map.Entry<String, String> entry : this.mPathParameterMap.entrySet()) {
            tempUrl = tempUrl.replace("{" + entry.getKey() + "}", String.valueOf(entry.getValue()));
        }
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)tempUrl).newBuilder();
        for (Map.Entry<String, String> entry : this.mQueryParameterMap.entrySet()) {
            urlBuilder.addQueryParameter(entry.getKey(), entry.getValue());
        }
        return urlBuilder.build().toString();
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void setProgress(int progress) {
        this.mProgress = progress;
    }

    public void setResponseAs(ResponseType responseType) {
        this.mResponseType = responseType;
    }

    public ResponseType getResponseAs() {
        return this.mResponseType;
    }

    public Object getTag() {
        return this.mTag;
    }

    public int getRequestType() {
        return this.mRequestType;
    }

    public OkHttpClient getOkHttpClient() {
        return this.mOkHttpClient;
    }

    public void setUserAgent(String userAgent) {
        this.mUserAgent = userAgent;
    }

    public String getUserAgent() {
        return this.mUserAgent;
    }

    public Type getType() {
        return this.mType;
    }

    public void setType(Type type) {
        this.mType = type;
    }

    public DownloadProgressListener getDownloadProgressListener() {
        return new DownloadProgressListener(){

            @Override
            public void onProgress(long bytesDownloaded, long totalBytes) {
                if (ANRequest.this.mDownloadProgressListener != null && !ANRequest.this.isCancelled) {
                    ANRequest.this.mDownloadProgressListener.onProgress(bytesDownloaded, totalBytes);
                }
            }
        };
    }

    public void updateDownloadCompletion() {
        this.isDelivered = true;
        if (this.mDownloadListener != null) {
            if (!this.isCancelled) {
                if (this.mExecutor != null) {
                    this.mExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (ANRequest.this.mDownloadListener != null) {
                                ANRequest.this.mDownloadListener.onDownloadComplete();
                            }
                            ANRequest.this.finish();
                        }
                    });
                } else {
                    Core.getInstance().getExecutorSupplier().forMainThreadTasks().execute(new Runnable(){

                        @Override
                        public void run() {
                            if (ANRequest.this.mDownloadListener != null) {
                                ANRequest.this.mDownloadListener.onDownloadComplete();
                            }
                            ANRequest.this.finish();
                        }
                    });
                }
            } else {
                this.deliverError(new ANError());
                this.finish();
            }
        } else {
            this.finish();
        }
    }

    public UploadProgressListener getUploadProgressListener() {
        return new UploadProgressListener(){

            @Override
            public void onProgress(long bytesUploaded, long totalBytes) {
                ANRequest.this.mProgress = (int)(bytesUploaded * 100L / totalBytes);
                if (ANRequest.this.mUploadProgressListener != null && !ANRequest.this.isCancelled) {
                    ANRequest.this.mUploadProgressListener.onProgress(bytesUploaded, totalBytes);
                }
            }
        };
    }

    public String getDirPath() {
        return this.mDirPath;
    }

    public String getFileName() {
        return this.mFileName;
    }

    public CacheControl getCacheControl() {
        return this.mCacheControl;
    }

    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public void cancel(boolean forceCancel) {
        try {
            if (forceCancel || this.mPercentageThresholdForCancelling == 0 || this.mProgress < this.mPercentageThresholdForCancelling) {
                this.isCancelled = true;
                if (this.call != null) {
                    this.call.cancel();
                }
                if (this.future != null) {
                    this.future.cancel(true);
                }
                if (!this.isDelivered) {
                    this.deliverError(new ANError());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isCanceled() {
        return this.isCancelled;
    }

    public Call getCall() {
        return this.call;
    }

    public void setCall(Call call) {
        this.call = call;
    }

    public Future getFuture() {
        return this.future;
    }

    public void setFuture(Future future) {
        this.future = future;
    }

    public void destroy() {
        this.mJSONArrayRequestListener = null;
        this.mJSONArrayRequestListener = null;
        this.mStringRequestListener = null;
        this.mBitmapRequestListener = null;
        this.mParsedRequestListener = null;
        this.mDownloadProgressListener = null;
        this.mUploadProgressListener = null;
        this.mDownloadListener = null;
        this.mAnalyticsListener = null;
    }

    public void finish() {
        this.destroy();
        ANRequestQueue.getInstance().finish(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ANResponse parseResponse(Response response) {
        switch (this.mResponseType) {
            case JSON_ARRAY: {
                try {
                    JSONArray json = new JSONArray(Okio.buffer((Source)response.body().source()).readUtf8());
                    return ANResponse.success(json);
                }
                catch (Exception e) {
                    return ANResponse.failed(Utils.getErrorForParse(new ANError(e)));
                }
            }
            case JSON_OBJECT: {
                try {
                    JSONObject json = new JSONObject(Okio.buffer((Source)response.body().source()).readUtf8());
                    return ANResponse.success(json);
                }
                catch (Exception e) {
                    return ANResponse.failed(Utils.getErrorForParse(new ANError(e)));
                }
            }
            case STRING: {
                try {
                    return ANResponse.success(Okio.buffer((Source)response.body().source()).readUtf8());
                }
                catch (Exception e) {
                    return ANResponse.failed(Utils.getErrorForParse(new ANError(e)));
                }
            }
            case BITMAP: {
                Object e = sDecodeLock;
                synchronized (e) {
                    try {
                        return Utils.decodeBitmap(response, this.mMaxWidth, this.mMaxHeight, this.mDecodeConfig, this.mScaleType);
                    }
                    catch (Exception e2) {
                        return ANResponse.failed(Utils.getErrorForParse(new ANError(e2)));
                    }
                }
            }
            case PARSED: {
                try {
                    return ANResponse.success(ParseUtil.getParserFactory().responseBodyParser(this.mType).convert(response.body()));
                }
                catch (Exception e) {
                    return ANResponse.failed(Utils.getErrorForParse(new ANError(e)));
                }
            }
            case PREFETCH: {
                try {
                    Okio.buffer((Source)response.body().source()).skip(Long.MAX_VALUE);
                    return ANResponse.success("prefetch");
                }
                catch (Exception e) {
                    return ANResponse.failed(Utils.getErrorForParse(new ANError(e)));
                }
            }
        }
        return null;
    }

    public ANError parseNetworkError(ANError anError) {
        try {
            if (anError.getResponse() != null && anError.getResponse().body() != null && anError.getResponse().body().source() != null) {
                anError.setErrorBody(Okio.buffer((Source)anError.getResponse().body().source()).readUtf8());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return anError;
    }

    public synchronized void deliverError(ANError anError) {
        try {
            if (!this.isDelivered) {
                if (this.isCancelled) {
                    anError.setCancellationMessageInError();
                    anError.setErrorCode(0);
                }
                this.deliverErrorResponse(anError);
            }
            this.isDelivered = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deliverResponse(final ANResponse response) {
        try {
            this.isDelivered = true;
            if (!this.isCancelled) {
                if (this.mExecutor != null) {
                    this.mExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            ANRequest.this.deliverSuccessResponse(response);
                        }
                    });
                } else {
                    Core.getInstance().getExecutorSupplier().forMainThreadTasks().execute(new Runnable(){

                        @Override
                        public void run() {
                            ANRequest.this.deliverSuccessResponse(response);
                        }
                    });
                }
            } else {
                ANError anError = new ANError();
                anError.setCancellationMessageInError();
                anError.setErrorCode(0);
                this.deliverErrorResponse(anError);
                this.finish();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deliverSuccessResponse(ANResponse response) {
        if (this.mJSONObjectRequestListener != null) {
            this.mJSONObjectRequestListener.onResponse((JSONObject)response.getResult());
        } else if (this.mJSONArrayRequestListener != null) {
            this.mJSONArrayRequestListener.onResponse((JSONArray)response.getResult());
        } else if (this.mStringRequestListener != null) {
            this.mStringRequestListener.onResponse((String)response.getResult());
        } else if (this.mBitmapRequestListener != null) {
            this.mBitmapRequestListener.onResponse((Bitmap)response.getResult());
        } else if (this.mParsedRequestListener != null) {
            this.mParsedRequestListener.onResponse(response.getResult());
        } else if (this.mOkHttpResponseAndJSONObjectRequestListener != null) {
            this.mOkHttpResponseAndJSONObjectRequestListener.onResponse(response.getOkHttpResponse(), (JSONObject)response.getResult());
        } else if (this.mOkHttpResponseAndJSONArrayRequestListener != null) {
            this.mOkHttpResponseAndJSONArrayRequestListener.onResponse(response.getOkHttpResponse(), (JSONArray)response.getResult());
        } else if (this.mOkHttpResponseAndStringRequestListener != null) {
            this.mOkHttpResponseAndStringRequestListener.onResponse(response.getOkHttpResponse(), (String)response.getResult());
        } else if (this.mOkHttpResponseAndBitmapRequestListener != null) {
            this.mOkHttpResponseAndBitmapRequestListener.onResponse(response.getOkHttpResponse(), (Bitmap)response.getResult());
        } else if (this.mOkHttpResponseAndParsedRequestListener != null) {
            this.mOkHttpResponseAndParsedRequestListener.onResponse(response.getOkHttpResponse(), response.getResult());
        }
        this.finish();
    }

    private void deliverErrorResponse(ANError anError) {
        if (this.mJSONObjectRequestListener != null) {
            this.mJSONObjectRequestListener.onError(anError);
        } else if (this.mJSONArrayRequestListener != null) {
            this.mJSONArrayRequestListener.onError(anError);
        } else if (this.mStringRequestListener != null) {
            this.mStringRequestListener.onError(anError);
        } else if (this.mBitmapRequestListener != null) {
            this.mBitmapRequestListener.onError(anError);
        } else if (this.mParsedRequestListener != null) {
            this.mParsedRequestListener.onError(anError);
        } else if (this.mOkHttpResponseListener != null) {
            this.mOkHttpResponseListener.onError(anError);
        } else if (this.mOkHttpResponseAndJSONObjectRequestListener != null) {
            this.mOkHttpResponseAndJSONObjectRequestListener.onError(anError);
        } else if (this.mOkHttpResponseAndJSONArrayRequestListener != null) {
            this.mOkHttpResponseAndJSONArrayRequestListener.onError(anError);
        } else if (this.mOkHttpResponseAndStringRequestListener != null) {
            this.mOkHttpResponseAndStringRequestListener.onError(anError);
        } else if (this.mOkHttpResponseAndBitmapRequestListener != null) {
            this.mOkHttpResponseAndBitmapRequestListener.onError(anError);
        } else if (this.mOkHttpResponseAndParsedRequestListener != null) {
            this.mOkHttpResponseAndParsedRequestListener.onError(anError);
        } else if (this.mDownloadListener != null) {
            this.mDownloadListener.onError(anError);
        }
    }

    public void deliverOkHttpResponse(final Response response) {
        try {
            this.isDelivered = true;
            if (!this.isCancelled) {
                if (this.mExecutor != null) {
                    this.mExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (ANRequest.this.mOkHttpResponseListener != null) {
                                ANRequest.this.mOkHttpResponseListener.onResponse(response);
                            }
                            ANRequest.this.finish();
                        }
                    });
                } else {
                    Core.getInstance().getExecutorSupplier().forMainThreadTasks().execute(new Runnable(){

                        @Override
                        public void run() {
                            if (ANRequest.this.mOkHttpResponseListener != null) {
                                ANRequest.this.mOkHttpResponseListener.onResponse(response);
                            }
                            ANRequest.this.finish();
                        }
                    });
                }
            } else {
                ANError anError = new ANError();
                anError.setCancellationMessageInError();
                anError.setErrorCode(0);
                if (this.mOkHttpResponseListener != null) {
                    this.mOkHttpResponseListener.onError(anError);
                }
                this.finish();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RequestBody getRequestBody() {
        if (this.mApplicationJsonString != null) {
            if (this.customMediaType != null) {
                return RequestBody.create((MediaType)this.customMediaType, (String)this.mApplicationJsonString);
            }
            return RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)this.mApplicationJsonString);
        }
        if (this.mStringBody != null) {
            if (this.customMediaType != null) {
                return RequestBody.create((MediaType)this.customMediaType, (String)this.mStringBody);
            }
            return RequestBody.create((MediaType)MEDIA_TYPE_MARKDOWN, (String)this.mStringBody);
        }
        if (this.mFile != null) {
            if (this.customMediaType != null) {
                return RequestBody.create((MediaType)this.customMediaType, (File)this.mFile);
            }
            return RequestBody.create((MediaType)MEDIA_TYPE_MARKDOWN, (File)this.mFile);
        }
        if (this.mByte != null) {
            if (this.customMediaType != null) {
                return RequestBody.create((MediaType)this.customMediaType, (byte[])this.mByte);
            }
            return RequestBody.create((MediaType)MEDIA_TYPE_MARKDOWN, (byte[])this.mByte);
        }
        FormBody.Builder builder = new FormBody.Builder();
        try {
            for (Map.Entry<String, String> entry : this.mBodyParameterMap.entrySet()) {
                builder.add(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this.mUrlEncodedFormBodyParameterMap.entrySet()) {
                builder.addEncoded(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return builder.build();
    }

    public RequestBody getMultiPartRequestBody() {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(this.customMediaType == null ? MultipartBody.FORM : this.customMediaType);
        try {
            for (Map.Entry<String, String> entry : this.mMultiPartParameterMap.entrySet()) {
                builder.addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + entry.getKey() + "\""}), RequestBody.create(null, (String)entry.getValue()));
            }
            for (Map.Entry<String, Object> entry : this.mMultiPartFileMap.entrySet()) {
                String fileName = ((File)entry.getValue()).getName();
                RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)Utils.getMimeType(fileName)), (File)((File)entry.getValue()));
                builder.addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + entry.getKey() + "\"; filename=\"" + fileName + "\""}), fileBody);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return builder.build();
    }

    public Headers getHeaders() {
        Headers.Builder builder = new Headers.Builder();
        try {
            for (Map.Entry<String, String> entry : this.mHeadersMap.entrySet()) {
                builder.add(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return builder.build();
    }

    public String toString() {
        return "ANRequest{sequenceNumber='" + this.sequenceNumber + ", mMethod=" + this.mMethod + ", mPriority=" + (Object)((Object)this.mPriority) + ", mRequestType=" + this.mRequestType + ", mUrl=" + this.mUrl + '}';
    }

    public static class MultiPartBuilder<T extends MultiPartBuilder>
    implements RequestBuilder {
        private Priority mPriority = Priority.MEDIUM;
        private String mUrl;
        private Object mTag;
        private HashMap<String, String> mHeadersMap = new HashMap();
        private HashMap<String, String> mMultiPartParameterMap = new HashMap();
        private HashMap<String, String> mQueryParameterMap = new HashMap();
        private HashMap<String, String> mPathParameterMap = new HashMap();
        private HashMap<String, File> mMultiPartFileMap = new HashMap();
        private CacheControl mCacheControl;
        private int mPercentageThresholdForCancelling = 0;
        private Executor mExecutor;
        private OkHttpClient mOkHttpClient;
        private String mUserAgent;
        private String mCustomContentType;

        public MultiPartBuilder(String url) {
            this.mUrl = url;
        }

        public T setPriority(Priority priority) {
            this.mPriority = priority;
            return (T)this;
        }

        public T setTag(Object tag) {
            this.mTag = tag;
            return (T)this;
        }

        public T addQueryParameter(String key, String value) {
            this.mQueryParameterMap.put(key, value);
            return (T)this;
        }

        public T addQueryParameter(Map<String, String> queryParameterMap) {
            if (queryParameterMap != null) {
                this.mQueryParameterMap.putAll(queryParameterMap);
            }
            return (T)this;
        }

        public T addQueryParameter(Object object) {
            if (object != null) {
                this.mQueryParameterMap.putAll(ParseUtil.getParserFactory().getStringMap(object));
            }
            return (T)this;
        }

        public T addPathParameter(String key, String value) {
            this.mPathParameterMap.put(key, value);
            return (T)this;
        }

        public T addPathParameter(Map<String, String> pathParameterMap) {
            if (pathParameterMap != null) {
                this.mPathParameterMap.putAll(pathParameterMap);
            }
            return (T)this;
        }

        public T addPathParameter(Object object) {
            if (object != null) {
                this.mPathParameterMap.putAll(ParseUtil.getParserFactory().getStringMap(object));
            }
            return (T)this;
        }

        public T addHeaders(String key, String value) {
            this.mHeadersMap.put(key, value);
            return (T)this;
        }

        public T addHeaders(Map<String, String> headerMap) {
            if (headerMap != null) {
                this.mHeadersMap.putAll(headerMap);
            }
            return (T)this;
        }

        public T addHeaders(Object object) {
            if (object != null) {
                this.mHeadersMap.putAll(ParseUtil.getParserFactory().getStringMap(object));
            }
            return (T)this;
        }

        public T doNotCacheResponse() {
            this.mCacheControl = new CacheControl.Builder().noStore().build();
            return (T)this;
        }

        public T getResponseOnlyIfCached() {
            this.mCacheControl = CacheControl.FORCE_CACHE;
            return (T)this;
        }

        public T getResponseOnlyFromNetwork() {
            this.mCacheControl = CacheControl.FORCE_NETWORK;
            return (T)this;
        }

        public T setMaxAgeCacheControl(int maxAge, TimeUnit timeUnit) {
            this.mCacheControl = new CacheControl.Builder().maxAge(maxAge, timeUnit).build();
            return (T)this;
        }

        public T setMaxStaleCacheControl(int maxStale, TimeUnit timeUnit) {
            this.mCacheControl = new CacheControl.Builder().maxStale(maxStale, timeUnit).build();
            return (T)this;
        }

        public T setExecutor(Executor executor) {
            this.mExecutor = executor;
            return (T)this;
        }

        public T setOkHttpClient(OkHttpClient okHttpClient) {
            this.mOkHttpClient = okHttpClient;
            return (T)this;
        }

        public T setUserAgent(String userAgent) {
            this.mUserAgent = userAgent;
            return (T)this;
        }

        public T addMultipartParameter(String key, String value) {
            this.mMultiPartParameterMap.put(key, value);
            return (T)this;
        }

        public T addMultipartParameter(Map<String, String> multiPartParameterMap) {
            if (multiPartParameterMap != null) {
                this.mMultiPartParameterMap.putAll(multiPartParameterMap);
            }
            return (T)this;
        }

        public T addMultipartParameter(Object object) {
            if (object != null) {
                this.mMultiPartParameterMap.putAll(ParseUtil.getParserFactory().getStringMap(object));
            }
            return (T)this;
        }

        public T addMultipartFile(String key, File file) {
            this.mMultiPartFileMap.put(key, file);
            return (T)this;
        }

        public T addMultipartFile(Map<String, File> multiPartFileMap) {
            if (multiPartFileMap != null) {
                this.mMultiPartFileMap.putAll(multiPartFileMap);
            }
            return (T)this;
        }

        public T setPercentageThresholdForCancelling(int percentageThresholdForCancelling) {
            this.mPercentageThresholdForCancelling = percentageThresholdForCancelling;
            return (T)this;
        }

        public T setContentType(String contentType) {
            this.mCustomContentType = contentType;
            return (T)this;
        }

        public ANRequest build() {
            return new ANRequest(this);
        }
    }

    public static class DownloadBuilder<T extends DownloadBuilder>
    implements RequestBuilder {
        private Priority mPriority = Priority.MEDIUM;
        private String mUrl;
        private Object mTag;
        private HashMap<String, String> mHeadersMap = new HashMap();
        private HashMap<String, String> mQueryParameterMap = new HashMap();
        private HashMap<String, String> mPathParameterMap = new HashMap();
        private String mDirPath;
        private String mFileName;
        private CacheControl mCacheControl;
        private int mPercentageThresholdForCancelling = 0;
        private Executor mExecutor;
        private OkHttpClient mOkHttpClient;
        private String mUserAgent;

        public DownloadBuilder(String url, String dirPath, String fileName) {
            this.mUrl = url;
            this.mDirPath = dirPath;
            this.mFileName = fileName;
        }

        public T setPriority(Priority priority) {
            this.mPriority = priority;
            return (T)this;
        }

        public T setTag(Object tag) {
            this.mTag = tag;
            return (T)this;
        }

        public T addHeaders(String key, String value) {
            this.mHeadersMap.put(key, value);
            return (T)this;
        }

        public T addHeaders(Map<String, String> headerMap) {
            if (headerMap != null) {
                this.mHeadersMap.putAll(headerMap);
            }
            return (T)this;
        }

        public T addHeaders(Object object) {
            if (object != null) {
                this.mHeadersMap.putAll(ParseUtil.getParserFactory().getStringMap(object));
            }
            return (T)this;
        }

        public T addQueryParameter(String key, String value) {
            this.mQueryParameterMap.put(key, value);
            return (T)this;
        }

        public T addQueryParameter(Map<String, String> queryParameterMap) {
            if (queryParameterMap != null) {
                this.mQueryParameterMap.putAll(queryParameterMap);
            }
            return (T)this;
        }

        public T addQueryParameter(Object object) {
            if (object != null) {
                this.mQueryParameterMap.putAll(ParseUtil.getParserFactory().getStringMap(object));
            }
            return (T)this;
        }

        public T addPathParameter(String key, String value) {
            this.mPathParameterMap.put(key, value);
            return (T)this;
        }

        public T addPathParameter(Map<String, String> pathParameterMap) {
            if (pathParameterMap != null) {
                this.mPathParameterMap.putAll(pathParameterMap);
            }
            return (T)this;
        }

        public T addPathParameter(Object object) {
            if (object != null) {
                this.mPathParameterMap.putAll(ParseUtil.getParserFactory().getStringMap(object));
            }
            return (T)this;
        }

        public T doNotCacheResponse() {
            this.mCacheControl = new CacheControl.Builder().noStore().build();
            return (T)this;
        }

        public T getResponseOnlyIfCached() {
            this.mCacheControl = CacheControl.FORCE_CACHE;
            return (T)this;
        }

        public T getResponseOnlyFromNetwork() {
            this.mCacheControl = CacheControl.FORCE_NETWORK;
            return (T)this;
        }

        public T setMaxAgeCacheControl(int maxAge, TimeUnit timeUnit) {
            this.mCacheControl = new CacheControl.Builder().maxAge(maxAge, timeUnit).build();
            return (T)this;
        }

        public T setMaxStaleCacheControl(int maxStale, TimeUnit timeUnit) {
            this.mCacheControl = new CacheControl.Builder().maxStale(maxStale, timeUnit).build();
            return (T)this;
        }

        public T setExecutor(Executor executor) {
            this.mExecutor = executor;
            return (T)this;
        }

        public T setOkHttpClient(OkHttpClient okHttpClient) {
            this.mOkHttpClient = okHttpClient;
            return (T)this;
        }

        public T setUserAgent(String userAgent) {
            this.mUserAgent = userAgent;
            return (T)this;
        }

        public T setPercentageThresholdForCancelling(int percentageThresholdForCancelling) {
            this.mPercentageThresholdForCancelling = percentageThresholdForCancelling;
            return (T)this;
        }

        public ANRequest build() {
            return new ANRequest(this);
        }
    }

    public static class PostRequestBuilder<T extends PostRequestBuilder>
    implements RequestBuilder {
        private Priority mPriority = Priority.MEDIUM;
        private int mMethod = 1;
        private String mUrl;
        private Object mTag;
        private String mApplicationJsonString = null;
        private String mStringBody = null;
        private byte[] mByte = null;
        private File mFile = null;
        private HashMap<String, String> mHeadersMap = new HashMap();
        private HashMap<String, String> mBodyParameterMap = new HashMap();
        private HashMap<String, String> mUrlEncodedFormBodyParameterMap = new HashMap();
        private HashMap<String, String> mQueryParameterMap = new HashMap();
        private HashMap<String, String> mPathParameterMap = new HashMap();
        private CacheControl mCacheControl;
        private Executor mExecutor;
        private OkHttpClient mOkHttpClient;
        private String mUserAgent;
        private String mCustomContentType;

        public PostRequestBuilder(String url) {
            this.mUrl = url;
            this.mMethod = 1;
        }

        public PostRequestBuilder(String url, int method) {
            this.mUrl = url;
            this.mMethod = method;
        }

        public T setPriority(Priority priority) {
            this.mPriority = priority;
            return (T)this;
        }

        public T setTag(Object tag) {
            this.mTag = tag;
            return (T)this;
        }

        public T addQueryParameter(String key, String value) {
            this.mQueryParameterMap.put(key, value);
            return (T)this;
        }

        public T addQueryParameter(Map<String, String> queryParameterMap) {
            if (queryParameterMap != null) {
                this.mQueryParameterMap.putAll(queryParameterMap);
            }
            return (T)this;
        }

        public T addQueryParameter(Object object) {
            if (object != null) {
                this.mQueryParameterMap.putAll(ParseUtil.getParserFactory().getStringMap(object));
            }
            return (T)this;
        }

        public T addPathParameter(String key, String value) {
            this.mPathParameterMap.put(key, value);
            return (T)this;
        }

        public T addPathParameter(Map<String, String> pathParameterMap) {
            if (pathParameterMap != null) {
                this.mPathParameterMap.putAll(pathParameterMap);
            }
            return (T)this;
        }

        public T addPathParameter(Object object) {
            if (object != null) {
                this.mPathParameterMap.putAll(ParseUtil.getParserFactory().getStringMap(object));
            }
            return (T)this;
        }

        public T addHeaders(String key, String value) {
            this.mHeadersMap.put(key, value);
            return (T)this;
        }

        public T addHeaders(Map<String, String> headerMap) {
            if (headerMap != null) {
                this.mHeadersMap.putAll(headerMap);
            }
            return (T)this;
        }

        public T addHeaders(Object object) {
            if (object != null) {
                this.mHeadersMap.putAll(ParseUtil.getParserFactory().getStringMap(object));
            }
            return (T)this;
        }

        public T doNotCacheResponse() {
            this.mCacheControl = new CacheControl.Builder().noStore().build();
            return (T)this;
        }

        public T getResponseOnlyIfCached() {
            this.mCacheControl = CacheControl.FORCE_CACHE;
            return (T)this;
        }

        public T getResponseOnlyFromNetwork() {
            this.mCacheControl = CacheControl.FORCE_NETWORK;
            return (T)this;
        }

        public T setMaxAgeCacheControl(int maxAge, TimeUnit timeUnit) {
            this.mCacheControl = new CacheControl.Builder().maxAge(maxAge, timeUnit).build();
            return (T)this;
        }

        public T setMaxStaleCacheControl(int maxStale, TimeUnit timeUnit) {
            this.mCacheControl = new CacheControl.Builder().maxStale(maxStale, timeUnit).build();
            return (T)this;
        }

        public T setExecutor(Executor executor) {
            this.mExecutor = executor;
            return (T)this;
        }

        public T setOkHttpClient(OkHttpClient okHttpClient) {
            this.mOkHttpClient = okHttpClient;
            return (T)this;
        }

        public T setUserAgent(String userAgent) {
            this.mUserAgent = userAgent;
            return (T)this;
        }

        public T addBodyParameter(String key, String value) {
            this.mBodyParameterMap.put(key, value);
            return (T)this;
        }

        public T addBodyParameter(Map<String, String> bodyParameterMap) {
            if (bodyParameterMap != null) {
                this.mBodyParameterMap.putAll(bodyParameterMap);
            }
            return (T)this;
        }

        public T addBodyParameter(Object object) {
            if (object != null) {
                this.mBodyParameterMap.putAll(ParseUtil.getParserFactory().getStringMap(object));
            }
            return (T)this;
        }

        public T addUrlEncodeFormBodyParameter(String key, String value) {
            this.mUrlEncodedFormBodyParameterMap.put(key, value);
            return (T)this;
        }

        public T addUrlEncodeFormBodyParameter(Map<String, String> bodyParameterMap) {
            if (bodyParameterMap != null) {
                this.mUrlEncodedFormBodyParameterMap.putAll(bodyParameterMap);
            }
            return (T)this;
        }

        public T addUrlEncodeFormBodyParameter(Object object) {
            if (object != null) {
                this.mUrlEncodedFormBodyParameterMap.putAll(ParseUtil.getParserFactory().getStringMap(object));
            }
            return (T)this;
        }

        public T addApplicationJsonBody(Object object) {
            if (object != null) {
                this.mApplicationJsonString = ParseUtil.getParserFactory().getString(object);
            }
            return (T)this;
        }

        public T addJSONObjectBody(JSONObject jsonObject) {
            if (jsonObject != null) {
                this.mApplicationJsonString = jsonObject.toString();
            }
            return (T)this;
        }

        public T addJSONArrayBody(JSONArray jsonArray) {
            if (jsonArray != null) {
                this.mApplicationJsonString = jsonArray.toString();
            }
            return (T)this;
        }

        public T addStringBody(String stringBody) {
            this.mStringBody = stringBody;
            return (T)this;
        }

        public T addFileBody(File file) {
            this.mFile = file;
            return (T)this;
        }

        public T addByteBody(byte[] bytes) {
            this.mByte = bytes;
            return (T)this;
        }

        public T setContentType(String contentType) {
            this.mCustomContentType = contentType;
            return (T)this;
        }

        public ANRequest build() {
            return new ANRequest(this);
        }
    }

    public static class PatchRequestBuilder
    extends PostRequestBuilder {
        public PatchRequestBuilder(String url) {
            super(url, 5);
        }
    }

    public static class DeleteRequestBuilder
    extends PostRequestBuilder {
        public DeleteRequestBuilder(String url) {
            super(url, 3);
        }
    }

    public static class PutRequestBuilder
    extends PostRequestBuilder {
        public PutRequestBuilder(String url) {
            super(url, 2);
        }
    }

    public static class GetRequestBuilder<T extends GetRequestBuilder>
    implements RequestBuilder {
        private Priority mPriority = Priority.MEDIUM;
        private int mMethod = 0;
        private String mUrl;
        private Object mTag;
        private Bitmap.Config mDecodeConfig;
        private BitmapFactory.Options mBitmapOptions;
        private int mMaxWidth;
        private int mMaxHeight;
        private ImageView.ScaleType mScaleType;
        private HashMap<String, String> mHeadersMap = new HashMap();
        private HashMap<String, String> mQueryParameterMap = new HashMap();
        private HashMap<String, String> mPathParameterMap = new HashMap();
        private CacheControl mCacheControl;
        private Executor mExecutor;
        private OkHttpClient mOkHttpClient;
        private String mUserAgent;

        public GetRequestBuilder(String url) {
            this.mUrl = url;
            this.mMethod = 0;
        }

        public GetRequestBuilder(String url, int method) {
            this.mUrl = url;
            this.mMethod = method;
        }

        public T setPriority(Priority priority) {
            this.mPriority = priority;
            return (T)this;
        }

        public T setTag(Object tag) {
            this.mTag = tag;
            return (T)this;
        }

        public T addQueryParameter(String key, String value) {
            this.mQueryParameterMap.put(key, value);
            return (T)this;
        }

        public T addQueryParameter(Map<String, String> queryParameterMap) {
            if (queryParameterMap != null) {
                this.mQueryParameterMap.putAll(queryParameterMap);
            }
            return (T)this;
        }

        public T addQueryParameter(Object object) {
            if (object != null) {
                this.mQueryParameterMap.putAll(ParseUtil.getParserFactory().getStringMap(object));
            }
            return (T)this;
        }

        public T addPathParameter(String key, String value) {
            this.mPathParameterMap.put(key, value);
            return (T)this;
        }

        public T addPathParameter(Map<String, String> pathParameterMap) {
            if (pathParameterMap != null) {
                this.mPathParameterMap.putAll(pathParameterMap);
            }
            return (T)this;
        }

        public T addPathParameter(Object object) {
            if (object != null) {
                this.mPathParameterMap.putAll(ParseUtil.getParserFactory().getStringMap(object));
            }
            return (T)this;
        }

        public T addHeaders(String key, String value) {
            this.mHeadersMap.put(key, value);
            return (T)this;
        }

        public T addHeaders(Map<String, String> headerMap) {
            if (headerMap != null) {
                this.mHeadersMap.putAll(headerMap);
            }
            return (T)this;
        }

        public T addHeaders(Object object) {
            if (object != null) {
                this.mHeadersMap.putAll(ParseUtil.getParserFactory().getStringMap(object));
            }
            return (T)this;
        }

        public T doNotCacheResponse() {
            this.mCacheControl = new CacheControl.Builder().noStore().build();
            return (T)this;
        }

        public T getResponseOnlyIfCached() {
            this.mCacheControl = CacheControl.FORCE_CACHE;
            return (T)this;
        }

        public T getResponseOnlyFromNetwork() {
            this.mCacheControl = CacheControl.FORCE_NETWORK;
            return (T)this;
        }

        public T setMaxAgeCacheControl(int maxAge, TimeUnit timeUnit) {
            this.mCacheControl = new CacheControl.Builder().maxAge(maxAge, timeUnit).build();
            return (T)this;
        }

        public T setMaxStaleCacheControl(int maxStale, TimeUnit timeUnit) {
            this.mCacheControl = new CacheControl.Builder().maxStale(maxStale, timeUnit).build();
            return (T)this;
        }

        public T setExecutor(Executor executor) {
            this.mExecutor = executor;
            return (T)this;
        }

        public T setOkHttpClient(OkHttpClient okHttpClient) {
            this.mOkHttpClient = okHttpClient;
            return (T)this;
        }

        public T setUserAgent(String userAgent) {
            this.mUserAgent = userAgent;
            return (T)this;
        }

        public T setBitmapConfig(Bitmap.Config bitmapConfig) {
            this.mDecodeConfig = bitmapConfig;
            return (T)this;
        }

        public T setBitmapOptions(BitmapFactory.Options bitmapOptions) {
            this.mBitmapOptions = bitmapOptions;
            return (T)this;
        }

        public T setBitmapMaxHeight(int maxHeight) {
            this.mMaxHeight = maxHeight;
            return (T)this;
        }

        public T setBitmapMaxWidth(int maxWidth) {
            this.mMaxWidth = maxWidth;
            return (T)this;
        }

        public T setImageScaleType(ImageView.ScaleType imageScaleType) {
            this.mScaleType = imageScaleType;
            return (T)this;
        }

        public ANRequest build() {
            return new ANRequest(this);
        }
    }

    public static class HeadRequestBuilder
    extends GetRequestBuilder {
        public HeadRequestBuilder(String url) {
            super(url, 4);
        }
    }
}

