/*
 * Decompiled with CFR 0.152.
 */
package com.androidnetworking.internal;

import android.content.Context;
import android.net.TrafficStats;
import com.androidnetworking.common.ANData;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.common.ConnectionClassManager;
import com.androidnetworking.error.ANError;
import com.androidnetworking.internal.RequestProgressBody;
import com.androidnetworking.internal.ResponseProgressBody;
import com.androidnetworking.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class InternalNetworking {
    public static OkHttpClient sHttpClient = InternalNetworking.getClient();
    public static String sUserAgent = null;

    public static ANData performSimpleRequest(ANRequest request) throws ANError {
        ANData data = new ANData();
        Request okHttpRequest = null;
        try {
            Request.Builder builder = new Request.Builder().url(request.getUrl());
            if (request.getUserAgent() != null) {
                builder.addHeader("User-Agent", request.getUserAgent());
            } else if (sUserAgent != null) {
                request.setUserAgent(sUserAgent);
                builder.addHeader("User-Agent", sUserAgent);
            }
            Headers requestHeaders = request.getHeaders();
            if (requestHeaders != null) {
                builder.headers(requestHeaders);
                if (request.getUserAgent() != null && !requestHeaders.names().contains("User-Agent")) {
                    builder.addHeader("User-Agent", request.getUserAgent());
                }
            }
            RequestBody requestBody = null;
            switch (request.getMethod()) {
                case 0: {
                    builder = builder.get();
                    break;
                }
                case 1: {
                    requestBody = request.getRequestBody();
                    builder = builder.post(requestBody);
                    break;
                }
                case 2: {
                    requestBody = request.getRequestBody();
                    builder = builder.put(requestBody);
                    break;
                }
                case 3: {
                    requestBody = request.getRequestBody();
                    builder = builder.delete(requestBody);
                    break;
                }
                case 4: {
                    builder = builder.head();
                    break;
                }
                case 5: {
                    requestBody = request.getRequestBody();
                    builder = builder.patch(requestBody);
                }
            }
            if (request.getCacheControl() != null) {
                builder.cacheControl(request.getCacheControl());
            }
            okHttpRequest = builder.build();
            if (request.getOkHttpClient() != null) {
                request.setCall(request.getOkHttpClient().newBuilder().cache(sHttpClient.cache()).build().newCall(okHttpRequest));
            } else {
                request.setCall(sHttpClient.newCall(okHttpRequest));
            }
            long startTime = System.currentTimeMillis();
            long startBytes = TrafficStats.getTotalRxBytes();
            Response okResponse = request.getCall().execute();
            data.url = okResponse.request().url();
            data.code = okResponse.code();
            data.headers = okResponse.headers();
            data.body = okResponse.body();
            data.length = data.body.contentLength();
            long timeTaken = System.currentTimeMillis() - startTime;
            if (okResponse.cacheResponse() == null) {
                long finalBytes = TrafficStats.getTotalRxBytes();
                long diffBytes = startBytes == -1L || finalBytes == -1L ? data.length : finalBytes - startBytes;
                ConnectionClassManager.getInstance().updateBandwidth(diffBytes, timeTaken);
                Utils.sendAnalytics(request.getAnalyticsListener(), timeTaken, requestBody != null && requestBody.contentLength() != 0L ? requestBody.contentLength() : -1L, data.length, false);
            } else if (request.getAnalyticsListener() != null) {
                if (okResponse.networkResponse() == null) {
                    Utils.sendAnalytics(request.getAnalyticsListener(), timeTaken, 0L, 0L, true);
                } else {
                    Utils.sendAnalytics(request.getAnalyticsListener(), timeTaken, requestBody != null && requestBody.contentLength() != 0L ? requestBody.contentLength() : -1L, 0L, true);
                }
            }
        }
        catch (IOException ioe) {
            if (okHttpRequest != null) {
                data.url = okHttpRequest.url();
            }
            throw new ANError(data, (Throwable)ioe);
        }
        return data;
    }

    public static ANData performDownloadRequest(final ANRequest request) throws ANError {
        ANData data = new ANData();
        Request okHttpRequest = null;
        try {
            Request.Builder builder = new Request.Builder().url(request.getUrl());
            if (request.getUserAgent() != null) {
                builder.addHeader("User-Agent", request.getUserAgent());
            } else if (sUserAgent != null) {
                request.setUserAgent(sUserAgent);
                builder.addHeader("User-Agent", sUserAgent);
            }
            Headers requestHeaders = request.getHeaders();
            if (requestHeaders != null) {
                builder.headers(requestHeaders);
                if (request.getUserAgent() != null && !requestHeaders.names().contains("User-Agent")) {
                    builder.addHeader("User-Agent", request.getUserAgent());
                }
            }
            builder = builder.get();
            if (request.getCacheControl() != null) {
                builder.cacheControl(request.getCacheControl());
            }
            okHttpRequest = builder.build();
            OkHttpClient okHttpClient = request.getOkHttpClient() != null ? request.getOkHttpClient().newBuilder().cache(sHttpClient.cache()).addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ResponseProgressBody(originalResponse.body(), request.getDownloadProgressListener())).build();
                }
            }).build() : sHttpClient.newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ResponseProgressBody(originalResponse.body(), request.getDownloadProgressListener())).build();
                }
            }).build();
            request.setCall(okHttpClient.newCall(okHttpRequest));
            long startTime = System.currentTimeMillis();
            long startBytes = TrafficStats.getTotalRxBytes();
            Response okResponse = request.getCall().execute();
            data.url = okResponse.request().url();
            data.code = okResponse.code();
            data.headers = okResponse.headers();
            Utils.saveFile(okResponse, request.getDirPath(), request.getFileName());
            data.length = okResponse.body().contentLength();
            long timeTaken = System.currentTimeMillis() - startTime;
            if (okResponse.cacheResponse() == null) {
                long finalBytes = TrafficStats.getTotalRxBytes();
                long diffBytes = startBytes == -1L || finalBytes == -1L ? data.length : finalBytes - startBytes;
                ConnectionClassManager.getInstance().updateBandwidth(diffBytes, timeTaken);
                Utils.sendAnalytics(request.getAnalyticsListener(), timeTaken, -1L, data.length, false);
            } else if (request.getAnalyticsListener() != null) {
                Utils.sendAnalytics(request.getAnalyticsListener(), timeTaken, -1L, 0L, true);
            }
        }
        catch (IOException ioe) {
            if (okHttpRequest != null) {
                data.url = okHttpRequest.url();
            }
            try {
                File destinationFile = new File(request.getDirPath() + File.separator + request.getFileName());
                if (destinationFile.exists()) {
                    destinationFile.delete();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw new ANError(data, (Throwable)ioe);
        }
        return data;
    }

    public static ANData performUploadRequest(ANRequest request) throws ANError {
        ANData data = new ANData();
        Request okHttpRequest = null;
        try {
            Request.Builder builder = new Request.Builder().url(request.getUrl());
            if (request.getUserAgent() != null) {
                builder.addHeader("User-Agent", request.getUserAgent());
            } else if (sUserAgent != null) {
                request.setUserAgent(sUserAgent);
                builder.addHeader("User-Agent", sUserAgent);
            }
            Headers requestHeaders = request.getHeaders();
            if (requestHeaders != null) {
                builder.headers(requestHeaders);
                if (request.getUserAgent() != null && !requestHeaders.names().contains("User-Agent")) {
                    builder.addHeader("User-Agent", request.getUserAgent());
                }
            }
            RequestBody requestBody = request.getMultiPartRequestBody();
            long requestBodyLength = requestBody.contentLength();
            builder = builder.post((RequestBody)new RequestProgressBody(requestBody, request.getUploadProgressListener()));
            if (request.getCacheControl() != null) {
                builder.cacheControl(request.getCacheControl());
            }
            okHttpRequest = builder.build();
            if (request.getOkHttpClient() != null) {
                request.setCall(request.getOkHttpClient().newBuilder().cache(sHttpClient.cache()).build().newCall(okHttpRequest));
            } else {
                request.setCall(sHttpClient.newCall(okHttpRequest));
            }
            long startTime = System.currentTimeMillis();
            Response okResponse = request.getCall().execute();
            data.url = okResponse.request().url();
            data.code = okResponse.code();
            data.headers = okResponse.headers();
            data.body = okResponse.body();
            data.length = data.body.contentLength();
            long timeTaken = System.currentTimeMillis() - startTime;
            if (request.getAnalyticsListener() != null) {
                if (okResponse.cacheResponse() == null) {
                    Utils.sendAnalytics(request.getAnalyticsListener(), timeTaken, requestBodyLength, data.length, false);
                } else if (okResponse.networkResponse() == null) {
                    Utils.sendAnalytics(request.getAnalyticsListener(), timeTaken, 0L, 0L, true);
                } else {
                    Utils.sendAnalytics(request.getAnalyticsListener(), timeTaken, requestBodyLength != 0L ? requestBodyLength : -1L, 0L, true);
                }
            }
        }
        catch (IOException ioe) {
            if (okHttpRequest != null) {
                data.url = okHttpRequest.url();
            }
            throw new ANError(data, (Throwable)ioe);
        }
        return data;
    }

    public static OkHttpClient getClient() {
        if (sHttpClient == null) {
            return InternalNetworking.getDefaultClient();
        }
        return sHttpClient;
    }

    public static OkHttpClient getDefaultClient() {
        return new OkHttpClient().newBuilder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).build();
    }

    public static void setClientWithCache(Context context) {
        sHttpClient = new OkHttpClient().newBuilder().cache(Utils.getCache(context, 0xA00000, "cache_an")).connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).build();
    }

    public static void setUserAgent(String userAgent) {
        sUserAgent = userAgent;
    }

    public static void setClient(OkHttpClient okHttpClient) {
        sHttpClient = okHttpClient;
    }
}

