/*
 * Decompiled with CFR 0.152.
 */
package com.androidnetworking.internal;

import com.androidnetworking.common.ANData;
import com.androidnetworking.common.ANLog;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.common.ANResponse;
import com.androidnetworking.common.Priority;
import com.androidnetworking.core.Core;
import com.androidnetworking.error.ANError;
import com.androidnetworking.internal.InternalNetworking;
import java.io.IOException;

public class InternalRunnable
implements Runnable {
    private static final String TAG = InternalRunnable.class.getSimpleName();
    private final Priority priority;
    public final int sequence;
    public final ANRequest request;

    public InternalRunnable(ANRequest request) {
        this.request = request;
        this.sequence = request.getSequenceNumber();
        this.priority = request.getPriority();
    }

    @Override
    public void run() {
        ANLog.d("execution started : " + this.request.toString());
        switch (this.request.getRequestType()) {
            case 0: {
                this.goForSimpleRequest();
                break;
            }
            case 1: {
                this.goForDownloadRequest();
                break;
            }
            case 2: {
                this.goForUploadRequest();
            }
        }
        ANLog.d("execution done : " + this.request.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void goForSimpleRequest() {
        ANData data = null;
        try {
            data = InternalNetworking.performSimpleRequest(this.request);
            if (data.code == 304) {
                this.request.finish();
                return;
            }
            if (data.code >= 400) {
                ANError ANError2 = new ANError(data);
                ANError2 = this.request.parseNetworkError(ANError2);
                ANError2.setErrorCode(data.code);
                ANError2.setErrorDetail("responseFromServerError");
                this.deliverError(this.request, ANError2);
                return;
            }
            ANResponse response = this.request.parseResponse(data);
            if (!response.isSuccess()) {
                this.deliverError(this.request, response.getError());
                return;
            }
            this.request.deliverResponse(response);
        }
        catch (ANError se) {
            se = this.request.parseNetworkError(se);
            se.setErrorDetail("connectionError");
            se.setErrorCode(0);
            this.deliverError(this.request, se);
        }
        catch (Exception e) {
            ANError se = new ANError(e);
            se.setErrorDetail("connectionError");
            se.setErrorCode(0);
            this.deliverError(this.request, se);
        }
        finally {
            if (data != null && data.source != null) {
                try {
                    data.source.close();
                }
                catch (IOException ignored) {
                    ANLog.d("Unable to close source data");
                }
            }
        }
    }

    private void goForDownloadRequest() {
        ANData data = null;
        try {
            data = InternalNetworking.performDownloadRequest(this.request);
            if (data.code >= 400) {
                ANError ANError2 = new ANError();
                ANError2 = this.request.parseNetworkError(ANError2);
                ANError2.setErrorCode(data.code);
                ANError2.setErrorDetail("responseFromServerError");
                this.deliverError(this.request, ANError2);
            }
        }
        catch (ANError se) {
            se.setErrorDetail("connectionError");
            se.setErrorCode(0);
            this.deliverError(this.request, se);
        }
        catch (Exception e) {
            ANError se = new ANError(e);
            se.setErrorDetail("connectionError");
            se.setErrorCode(0);
            this.deliverError(this.request, se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void goForUploadRequest() {
        ANData data = null;
        try {
            data = InternalNetworking.performUploadRequest(this.request);
            if (data.code == 304) {
                this.request.finish();
                return;
            }
            if (data.code >= 400) {
                ANError ANError2 = new ANError(data);
                ANError2 = this.request.parseNetworkError(ANError2);
                ANError2.setErrorCode(data.code);
                ANError2.setErrorDetail("responseFromServerError");
                this.deliverError(this.request, ANError2);
                return;
            }
            ANResponse response = this.request.parseResponse(data);
            if (!response.isSuccess()) {
                this.deliverError(this.request, response.getError());
                return;
            }
            this.request.deliverResponse(response);
        }
        catch (ANError se) {
            se = this.request.parseNetworkError(se);
            se.setErrorDetail("connectionError");
            se.setErrorCode(0);
            this.deliverError(this.request, se);
        }
        catch (Exception e) {
            ANError se = new ANError(e);
            se.setErrorDetail("connectionError");
            se.setErrorCode(0);
            this.deliverError(this.request, se);
        }
        finally {
            if (data != null && data.source != null) {
                try {
                    data.source.close();
                }
                catch (IOException ignored) {
                    ANLog.d("Unable to close source data");
                }
            }
        }
    }

    public Priority getPriority() {
        return this.priority;
    }

    private void deliverError(final ANRequest request, final ANError ANError2) {
        Core.getInstance().getExecutorSupplier().forMainThreadTasks().execute(new Runnable(){

            @Override
            public void run() {
                request.deliverError(ANError2);
                request.finish();
            }
        });
    }
}

