/*
 * Decompiled with CFR 0.152.
 */
package com.androidnetworking.common;

import com.androidnetworking.common.ConnectionQuality;
import com.androidnetworking.core.Core;
import com.androidnetworking.interfaces.ConnectionQualityChangeListener;

public class ConnectionClassManager {
    private static final int BYTES_TO_BITS = 8;
    private static final int DEFAULT_SAMPLES_TO_QUALITY_CHANGE = 5;
    private static final int MINIMUM_SAMPLES_TO_DECIDE_QUALITY = 2;
    private static final int DEFAULT_POOR_BANDWIDTH = 150;
    private static final int DEFAULT_MODERATE_BANDWIDTH = 550;
    private static final int DEFAULT_GOOD_BANDWIDTH = 2000;
    private static final long BANDWIDTH_LOWER_BOUND = 10L;
    private static ConnectionClassManager sInstance;
    private ConnectionQuality mCurrentConnectionQuality = ConnectionQuality.UNKNOWN;
    private int mCurrentBandwidthForSampling = 0;
    private int mCurrentNumberOfSample = 0;
    private int mCurrentBandwidth = 0;
    private ConnectionQualityChangeListener mConnectionQualityChangeListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConnectionClassManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<ConnectionClassManager> clazz = ConnectionClassManager.class;
        synchronized (ConnectionClassManager.class) {
            sInstance = new ConnectionClassManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public synchronized void updateBandwidth(long bytes, long timeInMs) {
        if (timeInMs == 0L || bytes < 20000L || (double)bytes * 1.0 / (double)timeInMs * 8.0 < 10.0) {
            return;
        }
        double bandwidth = (double)bytes * 1.0 / (double)timeInMs * 8.0;
        this.mCurrentBandwidthForSampling = (int)(((double)(this.mCurrentBandwidthForSampling * this.mCurrentNumberOfSample) + bandwidth) / (double)(this.mCurrentNumberOfSample + 1));
        ++this.mCurrentNumberOfSample;
        if (this.mCurrentNumberOfSample == 5 || this.mCurrentConnectionQuality == ConnectionQuality.UNKNOWN && this.mCurrentNumberOfSample == 2) {
            ConnectionQuality lastConnectionQuality = this.mCurrentConnectionQuality;
            this.mCurrentBandwidth = this.mCurrentBandwidthForSampling;
            if (this.mCurrentBandwidthForSampling <= 0) {
                this.mCurrentConnectionQuality = ConnectionQuality.UNKNOWN;
            } else if (this.mCurrentBandwidthForSampling < 150) {
                this.mCurrentConnectionQuality = ConnectionQuality.POOR;
            } else if (this.mCurrentBandwidthForSampling < 550) {
                this.mCurrentConnectionQuality = ConnectionQuality.MODERATE;
            } else if (this.mCurrentBandwidthForSampling < 2000) {
                this.mCurrentConnectionQuality = ConnectionQuality.GOOD;
            } else if (this.mCurrentBandwidthForSampling > 2000) {
                this.mCurrentConnectionQuality = ConnectionQuality.EXCELLENT;
            }
            if (this.mCurrentNumberOfSample == 5) {
                this.mCurrentBandwidthForSampling = 0;
                this.mCurrentNumberOfSample = 0;
            }
            if (this.mCurrentConnectionQuality != lastConnectionQuality && this.mConnectionQualityChangeListener != null) {
                Core.getInstance().getExecutorSupplier().forMainThreadTasks().execute(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionClassManager.this.mConnectionQualityChangeListener.onChange(ConnectionClassManager.this.mCurrentConnectionQuality, ConnectionClassManager.this.mCurrentBandwidth);
                    }
                });
            }
        }
    }

    public int getCurrentBandwidth() {
        return this.mCurrentBandwidth;
    }

    public ConnectionQuality getCurrentConnectionQuality() {
        return this.mCurrentConnectionQuality;
    }

    public void setListener(ConnectionQualityChangeListener connectionQualityChangeListener) {
        this.mConnectionQualityChangeListener = connectionQualityChangeListener;
    }

    public void removeListener() {
        this.mConnectionQualityChangeListener = null;
    }

    public static void shutDown() {
        if (sInstance != null) {
            sInstance = null;
        }
    }
}

