/*
 * Decompiled with CFR 0.152.
 */
package com.androidnetworking.common;

import android.graphics.Bitmap;
import android.widget.ImageView;
import com.androidnetworking.common.ANData;
import com.androidnetworking.common.ANLog;
import com.androidnetworking.common.ANResponse;
import com.androidnetworking.common.Priority;
import com.androidnetworking.common.RESPONSE;
import com.androidnetworking.common.RequestBuilder;
import com.androidnetworking.core.Core;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.AnalyticsListener;
import com.androidnetworking.interfaces.BitmapRequestListener;
import com.androidnetworking.interfaces.DownloadListener;
import com.androidnetworking.interfaces.DownloadProgressListener;
import com.androidnetworking.interfaces.JSONArrayRequestListener;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.StringRequestListener;
import com.androidnetworking.interfaces.UploadProgressListener;
import com.androidnetworking.internal.ANRequestQueue;
import com.androidnetworking.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okio.Okio;
import okio.Source;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ANRequest {
    private static final String TAG = ANRequest.class.getSimpleName();
    private int mMethod;
    private Priority mPriority;
    private int mRequestType;
    private String mUrl;
    private int sequenceNumber;
    private Object mTag;
    private RESPONSE mResponseAs;
    private HashMap<String, String> mHeadersMap = new HashMap();
    private HashMap<String, String> mBodyParameterMap = new HashMap();
    private HashMap<String, String> mUrlEncodedFormBodyParameterMap = new HashMap();
    private HashMap<String, String> mMultiPartParameterMap = new HashMap();
    private HashMap<String, String> mQueryParameterMap = new HashMap();
    private HashMap<String, String> mPathParameterMap = new HashMap();
    private HashMap<String, File> mMultiPartFileMap = new HashMap();
    private String mDirPath;
    private String mFileName;
    private JSONObject mJsonObject = null;
    private JSONArray mJsonArray = null;
    private String mStringBody = null;
    private byte[] mByte = null;
    private File mFile = null;
    private static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private static final MediaType MEDIA_TYPE_MARKDOWN = MediaType.parse((String)"text/x-markdown; charset=utf-8");
    private static final Object sDecodeLock = new Object();
    private Future future;
    private Call call;
    private int mProgress;
    private boolean isCancelled;
    private boolean isDelivered;
    private int mPercentageThresholdForCancelling = 0;
    private JSONArrayRequestListener mJSONArrayRequestListener;
    private JSONObjectRequestListener mJSONObjectRequestListener;
    private StringRequestListener mStringRequestListener;
    private BitmapRequestListener mBitmapRequestListener;
    private DownloadProgressListener mDownloadProgressListener;
    private UploadProgressListener mUploadProgressListener;
    private DownloadListener mDownloadListener;
    private AnalyticsListener mAnalyticsListener;
    private Bitmap.Config mDecodeConfig;
    private int mMaxWidth;
    private int mMaxHeight;
    private ImageView.ScaleType mScaleType;
    private CacheControl mCacheControl = null;
    private Executor mExecutor = null;
    private OkHttpClient mOkHttpClient = null;
    private String mUserAgent = null;

    private ANRequest(GetRequestBuilder builder) {
        this.mRequestType = 0;
        this.mMethod = builder.mMethod;
        this.mPriority = builder.mPriority;
        this.mUrl = builder.mUrl;
        this.mTag = builder.mTag;
        this.mHeadersMap = builder.mHeadersMap;
        this.mDecodeConfig = builder.mDecodeConfig;
        this.mMaxHeight = builder.mMaxHeight;
        this.mMaxWidth = builder.mMaxWidth;
        this.mScaleType = builder.mScaleType;
        this.mQueryParameterMap = builder.mQueryParameterMap;
        this.mPathParameterMap = builder.mPathParameterMap;
        this.mCacheControl = builder.mCacheControl;
        this.mExecutor = builder.mExecutor;
        this.mOkHttpClient = builder.mOkHttpClient;
        this.mUserAgent = builder.mUserAgent;
    }

    private ANRequest(PostRequestBuilder builder) {
        this.mRequestType = 0;
        this.mMethod = builder.mMethod;
        this.mPriority = builder.mPriority;
        this.mUrl = builder.mUrl;
        this.mTag = builder.mTag;
        this.mHeadersMap = builder.mHeadersMap;
        this.mBodyParameterMap = builder.mBodyParameterMap;
        this.mUrlEncodedFormBodyParameterMap = builder.mUrlEncodedFormBodyParameterMap;
        this.mQueryParameterMap = builder.mQueryParameterMap;
        this.mPathParameterMap = builder.mPathParameterMap;
        this.mJsonObject = builder.mJsonObject;
        this.mJsonArray = builder.mJsonArray;
        this.mStringBody = builder.mStringBody;
        this.mFile = builder.mFile;
        this.mByte = builder.mByte;
        this.mCacheControl = builder.mCacheControl;
        this.mExecutor = builder.mExecutor;
        this.mOkHttpClient = builder.mOkHttpClient;
        this.mUserAgent = builder.mUserAgent;
    }

    private ANRequest(DownloadBuilder builder) {
        this.mRequestType = 1;
        this.mMethod = 0;
        this.mPriority = builder.mPriority;
        this.mUrl = builder.mUrl;
        this.mTag = builder.mTag;
        this.mDirPath = builder.mDirPath;
        this.mFileName = builder.mFileName;
        this.mHeadersMap = builder.mHeadersMap;
        this.mQueryParameterMap = builder.mQueryParameterMap;
        this.mPathParameterMap = builder.mPathParameterMap;
        this.mCacheControl = builder.mCacheControl;
        this.mPercentageThresholdForCancelling = builder.mPercentageThresholdForCancelling;
        this.mExecutor = builder.mExecutor;
        this.mOkHttpClient = builder.mOkHttpClient;
        this.mUserAgent = builder.mUserAgent;
    }

    private ANRequest(MultiPartBuilder builder) {
        this.mRequestType = 2;
        this.mMethod = 1;
        this.mPriority = builder.mPriority;
        this.mUrl = builder.mUrl;
        this.mTag = builder.mTag;
        this.mHeadersMap = builder.mHeadersMap;
        this.mQueryParameterMap = builder.mQueryParameterMap;
        this.mPathParameterMap = builder.mPathParameterMap;
        this.mMultiPartParameterMap = builder.mMultiPartParameterMap;
        this.mMultiPartFileMap = builder.mMultiPartFileMap;
        this.mCacheControl = builder.mCacheControl;
        this.mPercentageThresholdForCancelling = builder.mPercentageThresholdForCancelling;
        this.mExecutor = builder.mExecutor;
        this.mOkHttpClient = builder.mOkHttpClient;
        this.mUserAgent = builder.mUserAgent;
    }

    public void getAsJSONObject(JSONObjectRequestListener requestListener) {
        this.mResponseAs = RESPONSE.JSON_OBJECT;
        this.mJSONObjectRequestListener = requestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsJSONArray(JSONArrayRequestListener requestListener) {
        this.mResponseAs = RESPONSE.JSON_ARRAY;
        this.mJSONArrayRequestListener = requestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsString(StringRequestListener requestListener) {
        this.mResponseAs = RESPONSE.STRING;
        this.mStringRequestListener = requestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void getAsBitmap(BitmapRequestListener requestListener) {
        this.mResponseAs = RESPONSE.BITMAP;
        this.mBitmapRequestListener = requestListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public ANRequest setDownloadProgressListener(DownloadProgressListener downloadProgressListener) {
        this.mDownloadProgressListener = downloadProgressListener;
        return this;
    }

    public void startDownload(DownloadListener downloadListener) {
        this.mDownloadListener = downloadListener;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public void prefetch() {
        this.mResponseAs = RESPONSE.PREFETCH;
        ANRequestQueue.getInstance().addRequest(this);
    }

    public ANRequest setUploadProgressListener(UploadProgressListener uploadProgressListener) {
        this.mUploadProgressListener = uploadProgressListener;
        return this;
    }

    public ANRequest setAnalyticsListener(AnalyticsListener analyticsListener) {
        this.mAnalyticsListener = analyticsListener;
        return this;
    }

    public AnalyticsListener getAnalyticsListener() {
        return this.mAnalyticsListener;
    }

    public int getMethod() {
        return this.mMethod;
    }

    public Priority getPriority() {
        return this.mPriority;
    }

    public String getUrl() {
        String tempUrl = this.mUrl;
        for (Map.Entry<String, String> entry : this.mPathParameterMap.entrySet()) {
            tempUrl = tempUrl.replace("{" + entry.getKey() + "}", String.valueOf(entry.getValue()));
        }
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)tempUrl).newBuilder();
        for (Map.Entry<String, String> entry : this.mQueryParameterMap.entrySet()) {
            urlBuilder.addQueryParameter(entry.getKey(), entry.getValue());
        }
        return urlBuilder.build().toString();
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void setProgress(int progress) {
        this.mProgress = progress;
    }

    public Object getTag() {
        return this.mTag;
    }

    public int getRequestType() {
        return this.mRequestType;
    }

    public OkHttpClient getOkHttpClient() {
        return this.mOkHttpClient;
    }

    public void setUserAgent(String userAgent) {
        this.mUserAgent = userAgent;
    }

    public String getUserAgent() {
        return this.mUserAgent;
    }

    public DownloadProgressListener getDownloadProgressListener() {
        return new DownloadProgressListener(){

            @Override
            public void onProgress(long bytesDownloaded, long totalBytes) {
                if (ANRequest.this.mDownloadProgressListener != null && !ANRequest.this.isCancelled) {
                    ANRequest.this.mDownloadProgressListener.onProgress(bytesDownloaded, totalBytes);
                }
            }
        };
    }

    public void updateDownloadCompletion() {
        this.isDelivered = true;
        if (this.mDownloadListener != null) {
            if (!this.isCancelled) {
                if (this.mExecutor != null) {
                    this.mExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (ANRequest.this.mDownloadListener != null) {
                                ANRequest.this.mDownloadListener.onDownloadComplete();
                            }
                            ANLog.d("Delivering success : " + this.toString());
                            ANRequest.this.finish();
                        }
                    });
                } else {
                    Core.getInstance().getExecutorSupplier().forMainThreadTasks().execute(new Runnable(){

                        @Override
                        public void run() {
                            if (ANRequest.this.mDownloadListener != null) {
                                ANRequest.this.mDownloadListener.onDownloadComplete();
                            }
                            ANLog.d("Delivering success : " + this.toString());
                            ANRequest.this.finish();
                        }
                    });
                }
            } else {
                this.deliverError(new ANError());
                this.finish();
            }
        } else {
            ANLog.d("Prefetch done : " + this.toString());
            this.finish();
        }
    }

    public UploadProgressListener getUploadProgressListener() {
        return new UploadProgressListener(){

            @Override
            public void onProgress(long bytesUploaded, long totalBytes) {
                ANRequest.this.mProgress = (int)(bytesUploaded * 100L / totalBytes);
                if (ANRequest.this.mUploadProgressListener != null && !ANRequest.this.isCancelled) {
                    ANRequest.this.mUploadProgressListener.onProgress(bytesUploaded, totalBytes);
                }
            }
        };
    }

    public String getDirPath() {
        return this.mDirPath;
    }

    public String getFileName() {
        return this.mFileName;
    }

    public CacheControl getCacheControl() {
        return this.mCacheControl;
    }

    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public void cancel(boolean forceCancel) {
        try {
            if (forceCancel || this.mPercentageThresholdForCancelling == 0 || this.mProgress < this.mPercentageThresholdForCancelling) {
                ANLog.d("cancelling request : " + this.toString());
                this.isCancelled = true;
                if (this.call != null) {
                    this.call.cancel();
                }
                if (this.future != null) {
                    this.future.cancel(true);
                }
                if (!this.isDelivered) {
                    this.deliverError(new ANError());
                }
            } else {
                ANLog.d("not cancelling request : " + this.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isCanceled() {
        return this.isCancelled;
    }

    public Call getCall() {
        return this.call;
    }

    public void setCall(Call call) {
        this.call = call;
    }

    public Future getFuture() {
        return this.future;
    }

    public void setFuture(Future future) {
        this.future = future;
    }

    public void destroy() {
        this.mJSONArrayRequestListener = null;
        this.mJSONArrayRequestListener = null;
        this.mStringRequestListener = null;
        this.mBitmapRequestListener = null;
        this.mDownloadProgressListener = null;
        this.mUploadProgressListener = null;
        this.mDownloadListener = null;
        this.mAnalyticsListener = null;
    }

    public void finish() {
        this.destroy();
        ANRequestQueue.getInstance().finish(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ANResponse parseResponse(ANData data) {
        switch (this.mResponseAs) {
            case JSON_ARRAY: {
                try {
                    JSONArray json = new JSONArray(Okio.buffer((Source)data.source).readUtf8());
                    return ANResponse.success(json);
                }
                catch (IOException | JSONException e) {
                    return ANResponse.failed(new ANError(e));
                }
            }
            case JSON_OBJECT: {
                try {
                    JSONObject json = new JSONObject(Okio.buffer((Source)data.source).readUtf8());
                    return ANResponse.success(json);
                }
                catch (IOException | JSONException e) {
                    return ANResponse.failed(new ANError(e));
                }
            }
            case STRING: {
                try {
                    return ANResponse.success(Okio.buffer((Source)data.source).readUtf8());
                }
                catch (IOException e) {
                    return ANResponse.failed(new ANError(e));
                }
            }
            case BITMAP: {
                Object object = sDecodeLock;
                synchronized (object) {
                    try {
                        return Utils.decodeBitmap(data, this.mMaxWidth, this.mMaxHeight, this.mDecodeConfig, this.mScaleType);
                    }
                    catch (OutOfMemoryError e) {
                        return ANResponse.failed(new ANError(e));
                    }
                }
            }
            case PREFETCH: {
                return ANResponse.success("prefetch");
            }
        }
        return null;
    }

    public ANError parseNetworkError(ANError ANError2) {
        try {
            if (ANError2.getData() != null && ANError2.getData().source != null) {
                ANError2.setErrorBody(Okio.buffer((Source)ANError2.getData().source).readUtf8());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ANError2;
    }

    public synchronized void deliverError(ANError ANError2) {
        try {
            if (!this.isDelivered) {
                if (this.isCancelled) {
                    ANError2.setCancellationMessageInError();
                    ANError2.setErrorCode(0);
                }
                if (this.mJSONObjectRequestListener != null) {
                    this.mJSONObjectRequestListener.onError(ANError2);
                } else if (this.mJSONArrayRequestListener != null) {
                    this.mJSONArrayRequestListener.onError(ANError2);
                } else if (this.mStringRequestListener != null) {
                    this.mStringRequestListener.onError(ANError2);
                } else if (this.mBitmapRequestListener != null) {
                    this.mBitmapRequestListener.onError(ANError2);
                } else if (this.mDownloadListener != null) {
                    this.mDownloadListener.onError(ANError2);
                }
                ANLog.d("Delivering ANError : " + this.toString());
            }
            this.isDelivered = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deliverResponse(final ANResponse response) {
        try {
            this.isDelivered = true;
            if (!this.isCancelled) {
                if (this.mExecutor != null) {
                    this.mExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (ANRequest.this.mJSONObjectRequestListener != null) {
                                ANRequest.this.mJSONObjectRequestListener.onResponse((JSONObject)response.getResult());
                            } else if (ANRequest.this.mJSONArrayRequestListener != null) {
                                ANRequest.this.mJSONArrayRequestListener.onResponse((JSONArray)response.getResult());
                            } else if (ANRequest.this.mStringRequestListener != null) {
                                ANRequest.this.mStringRequestListener.onResponse((String)response.getResult());
                            } else if (ANRequest.this.mBitmapRequestListener != null) {
                                ANRequest.this.mBitmapRequestListener.onResponse((Bitmap)response.getResult());
                            }
                            ANRequest.this.finish();
                        }
                    });
                } else {
                    Core.getInstance().getExecutorSupplier().forMainThreadTasks().execute(new Runnable(){

                        @Override
                        public void run() {
                            if (ANRequest.this.mJSONObjectRequestListener != null) {
                                ANRequest.this.mJSONObjectRequestListener.onResponse((JSONObject)response.getResult());
                            } else if (ANRequest.this.mJSONArrayRequestListener != null) {
                                ANRequest.this.mJSONArrayRequestListener.onResponse((JSONArray)response.getResult());
                            } else if (ANRequest.this.mStringRequestListener != null) {
                                ANRequest.this.mStringRequestListener.onResponse((String)response.getResult());
                            } else if (ANRequest.this.mBitmapRequestListener != null) {
                                ANRequest.this.mBitmapRequestListener.onResponse((Bitmap)response.getResult());
                            }
                            ANRequest.this.finish();
                        }
                    });
                }
                ANLog.d("Delivering success : " + this.toString());
            } else {
                ANError anError = new ANError();
                anError.setCancellationMessageInError();
                anError.setErrorCode(0);
                if (this.mJSONObjectRequestListener != null) {
                    this.mJSONObjectRequestListener.onError(anError);
                } else if (this.mJSONArrayRequestListener != null) {
                    this.mJSONArrayRequestListener.onError(anError);
                } else if (this.mStringRequestListener != null) {
                    this.mStringRequestListener.onError(anError);
                } else if (this.mBitmapRequestListener != null) {
                    this.mBitmapRequestListener.onError(anError);
                }
                this.finish();
                ANLog.d("Delivering cancelled : " + this.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RequestBody getRequestBody() {
        if (this.mJsonObject != null) {
            return RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)this.mJsonObject.toString());
        }
        if (this.mJsonArray != null) {
            return RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)this.mJsonArray.toString());
        }
        if (this.mStringBody != null) {
            return RequestBody.create((MediaType)MEDIA_TYPE_MARKDOWN, (String)this.mStringBody);
        }
        if (this.mFile != null) {
            return RequestBody.create((MediaType)MEDIA_TYPE_MARKDOWN, (File)this.mFile);
        }
        if (this.mByte != null) {
            return RequestBody.create((MediaType)MEDIA_TYPE_MARKDOWN, (byte[])this.mByte);
        }
        FormBody.Builder builder = new FormBody.Builder();
        try {
            for (Map.Entry<String, String> entry : this.mBodyParameterMap.entrySet()) {
                builder.add(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this.mUrlEncodedFormBodyParameterMap.entrySet()) {
                builder.addEncoded(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return builder.build();
    }

    public RequestBody getMultiPartRequestBody() {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        try {
            for (Map.Entry<String, String> entry : this.mMultiPartParameterMap.entrySet()) {
                builder.addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + entry.getKey() + "\""}), RequestBody.create(null, (String)entry.getValue()));
            }
            for (Map.Entry<String, Object> entry : this.mMultiPartFileMap.entrySet()) {
                String fileName = ((File)entry.getValue()).getName();
                RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)Utils.getMimeType(fileName)), (File)((File)entry.getValue()));
                builder.addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + entry.getKey() + "\"; filename=\"" + fileName + "\""}), fileBody);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return builder.build();
    }

    public Headers getHeaders() {
        Headers.Builder builder = new Headers.Builder();
        try {
            for (Map.Entry<String, String> entry : this.mHeadersMap.entrySet()) {
                builder.add(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return builder.build();
    }

    public String toString() {
        return "ANRequest{sequenceNumber='" + this.sequenceNumber + ", mMethod=" + this.mMethod + ", mPriority=" + (Object)((Object)this.mPriority) + ", mRequestType=" + this.mRequestType + ", mUrl=" + this.mUrl + '}';
    }

    public static class MultiPartBuilder
    implements RequestBuilder {
        private Priority mPriority = Priority.MEDIUM;
        private String mUrl;
        private Object mTag;
        private HashMap<String, String> mHeadersMap = new HashMap();
        private HashMap<String, String> mMultiPartParameterMap = new HashMap();
        private HashMap<String, String> mQueryParameterMap = new HashMap();
        private HashMap<String, String> mPathParameterMap = new HashMap();
        private HashMap<String, File> mMultiPartFileMap = new HashMap();
        private CacheControl mCacheControl;
        private int mPercentageThresholdForCancelling = 0;
        private Executor mExecutor;
        private OkHttpClient mOkHttpClient;
        private String mUserAgent;

        public MultiPartBuilder(String url) {
            this.mUrl = url;
        }

        @Override
        public MultiPartBuilder setPriority(Priority priority) {
            this.mPriority = priority;
            return this;
        }

        @Override
        public MultiPartBuilder setTag(Object tag) {
            this.mTag = tag;
            return this;
        }

        @Override
        public MultiPartBuilder addQueryParameter(String key, String value) {
            this.mQueryParameterMap.put(key, value);
            return this;
        }

        @Override
        public MultiPartBuilder addQueryParameter(HashMap<String, String> queryParameterMap) {
            if (queryParameterMap != null) {
                for (Map.Entry<String, String> entry : queryParameterMap.entrySet()) {
                    this.mQueryParameterMap.put(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        @Override
        public MultiPartBuilder addPathParameter(String key, String value) {
            this.mPathParameterMap.put(key, value);
            return this;
        }

        @Override
        public MultiPartBuilder addHeaders(String key, String value) {
            this.mHeadersMap.put(key, value);
            return this;
        }

        @Override
        public MultiPartBuilder addHeaders(HashMap<String, String> headerMap) {
            if (headerMap != null) {
                for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                    this.mHeadersMap.put(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        @Override
        public MultiPartBuilder doNotCacheResponse() {
            this.mCacheControl = new CacheControl.Builder().noStore().build();
            return this;
        }

        @Override
        public MultiPartBuilder getResponseOnlyIfCached() {
            this.mCacheControl = CacheControl.FORCE_CACHE;
            return this;
        }

        @Override
        public MultiPartBuilder getResponseOnlyFromNetwork() {
            this.mCacheControl = CacheControl.FORCE_NETWORK;
            return this;
        }

        @Override
        public MultiPartBuilder setMaxAgeCacheControl(int maxAge, TimeUnit timeUnit) {
            this.mCacheControl = new CacheControl.Builder().maxAge(maxAge, timeUnit).build();
            return this;
        }

        @Override
        public MultiPartBuilder setMaxStaleCacheControl(int maxStale, TimeUnit timeUnit) {
            this.mCacheControl = new CacheControl.Builder().maxStale(maxStale, timeUnit).build();
            return this;
        }

        @Override
        public MultiPartBuilder setExecutor(Executor executor) {
            this.mExecutor = executor;
            return this;
        }

        @Override
        public MultiPartBuilder setOkHttpClient(OkHttpClient okHttpClient) {
            this.mOkHttpClient = okHttpClient;
            return this;
        }

        @Override
        public MultiPartBuilder setUserAgent(String userAgent) {
            this.mUserAgent = userAgent;
            return this;
        }

        public MultiPartBuilder addMultipartParameter(String key, String value) {
            this.mMultiPartParameterMap.put(key, value);
            return this;
        }

        public MultiPartBuilder addMultipartParameter(HashMap<String, String> multiPartParameterMap) {
            if (multiPartParameterMap != null) {
                for (Map.Entry<String, String> entry : multiPartParameterMap.entrySet()) {
                    this.mMultiPartParameterMap.put(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        public MultiPartBuilder addMultipartFile(String key, File file) {
            this.mMultiPartFileMap.put(key, file);
            return this;
        }

        public MultiPartBuilder addMultipartFile(HashMap<String, File> multiPartFileMap) {
            if (multiPartFileMap != null) {
                for (Map.Entry<String, File> entry : multiPartFileMap.entrySet()) {
                    this.mMultiPartFileMap.put(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        public MultiPartBuilder setPercentageThresholdForCancelling(int percentageThresholdForCancelling) {
            this.mPercentageThresholdForCancelling = percentageThresholdForCancelling;
            return this;
        }

        public ANRequest build() {
            return new ANRequest(this);
        }
    }

    public static class DownloadBuilder
    implements RequestBuilder {
        private Priority mPriority = Priority.MEDIUM;
        private String mUrl;
        private Object mTag;
        private HashMap<String, String> mHeadersMap = new HashMap();
        private HashMap<String, String> mQueryParameterMap = new HashMap();
        private HashMap<String, String> mPathParameterMap = new HashMap();
        private String mDirPath;
        private String mFileName;
        private CacheControl mCacheControl;
        private int mPercentageThresholdForCancelling = 0;
        private Executor mExecutor;
        private OkHttpClient mOkHttpClient;
        private String mUserAgent;

        public DownloadBuilder(String url, String dirPath, String fileName) {
            this.mUrl = url;
            this.mDirPath = dirPath;
            this.mFileName = fileName;
        }

        @Override
        public DownloadBuilder setPriority(Priority priority) {
            this.mPriority = priority;
            return this;
        }

        @Override
        public DownloadBuilder setTag(Object tag) {
            this.mTag = tag;
            return this;
        }

        @Override
        public DownloadBuilder addHeaders(String key, String value) {
            this.mHeadersMap.put(key, value);
            return this;
        }

        @Override
        public DownloadBuilder addHeaders(HashMap<String, String> headerMap) {
            if (headerMap != null) {
                for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                    this.mHeadersMap.put(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        @Override
        public DownloadBuilder addQueryParameter(String key, String value) {
            this.mQueryParameterMap.put(key, value);
            return this;
        }

        @Override
        public DownloadBuilder addQueryParameter(HashMap<String, String> queryParameterMap) {
            if (queryParameterMap != null) {
                for (Map.Entry<String, String> entry : queryParameterMap.entrySet()) {
                    this.mQueryParameterMap.put(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        @Override
        public DownloadBuilder addPathParameter(String key, String value) {
            this.mPathParameterMap.put(key, value);
            return this;
        }

        @Override
        public DownloadBuilder doNotCacheResponse() {
            this.mCacheControl = new CacheControl.Builder().noStore().build();
            return this;
        }

        @Override
        public DownloadBuilder getResponseOnlyIfCached() {
            this.mCacheControl = CacheControl.FORCE_CACHE;
            return this;
        }

        @Override
        public DownloadBuilder getResponseOnlyFromNetwork() {
            this.mCacheControl = CacheControl.FORCE_NETWORK;
            return this;
        }

        @Override
        public DownloadBuilder setMaxAgeCacheControl(int maxAge, TimeUnit timeUnit) {
            this.mCacheControl = new CacheControl.Builder().maxAge(maxAge, timeUnit).build();
            return this;
        }

        @Override
        public DownloadBuilder setMaxStaleCacheControl(int maxStale, TimeUnit timeUnit) {
            this.mCacheControl = new CacheControl.Builder().maxStale(maxStale, timeUnit).build();
            return this;
        }

        @Override
        public DownloadBuilder setExecutor(Executor executor) {
            this.mExecutor = executor;
            return this;
        }

        @Override
        public DownloadBuilder setOkHttpClient(OkHttpClient okHttpClient) {
            this.mOkHttpClient = okHttpClient;
            return this;
        }

        @Override
        public DownloadBuilder setUserAgent(String userAgent) {
            this.mUserAgent = userAgent;
            return this;
        }

        public DownloadBuilder setPercentageThresholdForCancelling(int percentageThresholdForCancelling) {
            this.mPercentageThresholdForCancelling = percentageThresholdForCancelling;
            return this;
        }

        public ANRequest build() {
            return new ANRequest(this);
        }
    }

    public static class PostRequestBuilder
    implements RequestBuilder {
        private Priority mPriority = Priority.MEDIUM;
        private int mMethod = 1;
        private String mUrl;
        private Object mTag;
        private JSONObject mJsonObject = null;
        private JSONArray mJsonArray = null;
        private String mStringBody = null;
        private byte[] mByte = null;
        private File mFile = null;
        private HashMap<String, String> mHeadersMap = new HashMap();
        private HashMap<String, String> mBodyParameterMap = new HashMap();
        private HashMap<String, String> mUrlEncodedFormBodyParameterMap = new HashMap();
        private HashMap<String, String> mQueryParameterMap = new HashMap();
        private HashMap<String, String> mPathParameterMap = new HashMap();
        private CacheControl mCacheControl;
        private Executor mExecutor;
        private OkHttpClient mOkHttpClient;
        private String mUserAgent;

        public PostRequestBuilder(String url) {
            this.mUrl = url;
            this.mMethod = 1;
        }

        private PostRequestBuilder(String url, int method) {
            this.mUrl = url;
            this.mMethod = method;
        }

        @Override
        public PostRequestBuilder setPriority(Priority priority) {
            this.mPriority = priority;
            return this;
        }

        @Override
        public PostRequestBuilder setTag(Object tag) {
            this.mTag = tag;
            return this;
        }

        @Override
        public PostRequestBuilder addQueryParameter(String key, String value) {
            this.mQueryParameterMap.put(key, value);
            return this;
        }

        @Override
        public PostRequestBuilder addQueryParameter(HashMap<String, String> queryParameterMap) {
            if (queryParameterMap != null) {
                for (Map.Entry<String, String> entry : queryParameterMap.entrySet()) {
                    this.mQueryParameterMap.put(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        @Override
        public PostRequestBuilder addPathParameter(String key, String value) {
            this.mPathParameterMap.put(key, value);
            return this;
        }

        @Override
        public PostRequestBuilder addHeaders(String key, String value) {
            this.mHeadersMap.put(key, value);
            return this;
        }

        @Override
        public PostRequestBuilder addHeaders(HashMap<String, String> headerMap) {
            if (headerMap != null) {
                for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                    this.mHeadersMap.put(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        @Override
        public PostRequestBuilder doNotCacheResponse() {
            this.mCacheControl = new CacheControl.Builder().noStore().build();
            return this;
        }

        @Override
        public PostRequestBuilder getResponseOnlyIfCached() {
            this.mCacheControl = CacheControl.FORCE_CACHE;
            return this;
        }

        @Override
        public PostRequestBuilder getResponseOnlyFromNetwork() {
            this.mCacheControl = CacheControl.FORCE_NETWORK;
            return this;
        }

        @Override
        public PostRequestBuilder setMaxAgeCacheControl(int maxAge, TimeUnit timeUnit) {
            this.mCacheControl = new CacheControl.Builder().maxAge(maxAge, timeUnit).build();
            return this;
        }

        @Override
        public PostRequestBuilder setMaxStaleCacheControl(int maxStale, TimeUnit timeUnit) {
            this.mCacheControl = new CacheControl.Builder().maxStale(maxStale, timeUnit).build();
            return this;
        }

        @Override
        public PostRequestBuilder setExecutor(Executor executor) {
            this.mExecutor = executor;
            return this;
        }

        @Override
        public PostRequestBuilder setOkHttpClient(OkHttpClient okHttpClient) {
            this.mOkHttpClient = okHttpClient;
            return this;
        }

        @Override
        public PostRequestBuilder setUserAgent(String userAgent) {
            this.mUserAgent = userAgent;
            return this;
        }

        public PostRequestBuilder addBodyParameter(String key, String value) {
            this.mBodyParameterMap.put(key, value);
            return this;
        }

        public PostRequestBuilder addUrlEncodeFormBodyParameter(String key, String value) {
            this.mUrlEncodedFormBodyParameterMap.put(key, value);
            return this;
        }

        public PostRequestBuilder addBodyParameter(HashMap<String, String> bodyParameterMap) {
            if (bodyParameterMap != null) {
                for (Map.Entry<String, String> entry : bodyParameterMap.entrySet()) {
                    this.mBodyParameterMap.put(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        public PostRequestBuilder addUrlEncodeFormBodyParameter(HashMap<String, String> bodyParameterMap) {
            if (bodyParameterMap != null) {
                for (Map.Entry<String, String> entry : bodyParameterMap.entrySet()) {
                    this.mUrlEncodedFormBodyParameterMap.put(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        public PostRequestBuilder addJSONObjectBody(JSONObject jsonObject) {
            this.mJsonObject = jsonObject;
            return this;
        }

        public PostRequestBuilder addJSONArrayBody(JSONArray jsonArray) {
            this.mJsonArray = jsonArray;
            return this;
        }

        public PostRequestBuilder addStringBody(String stringBody) {
            this.mStringBody = stringBody;
            return this;
        }

        public PostRequestBuilder addFileBody(File file) {
            this.mFile = file;
            return this;
        }

        public PostRequestBuilder addByteBody(byte[] bytes) {
            this.mByte = bytes;
            return this;
        }

        public ANRequest build() {
            return new ANRequest(this);
        }
    }

    public static class PatchRequestBuilder
    extends PostRequestBuilder {
        public PatchRequestBuilder(String url) {
            super(url, 5);
        }
    }

    public static class DeleteRequestBuilder
    extends PostRequestBuilder {
        public DeleteRequestBuilder(String url) {
            super(url, 3);
        }
    }

    public static class PutRequestBuilder
    extends PostRequestBuilder {
        public PutRequestBuilder(String url) {
            super(url, 2);
        }
    }

    public static class GetRequestBuilder
    implements RequestBuilder {
        private Priority mPriority = Priority.MEDIUM;
        private int mMethod = 0;
        private String mUrl;
        private Object mTag;
        private Bitmap.Config mDecodeConfig;
        private int mMaxWidth;
        private int mMaxHeight;
        private ImageView.ScaleType mScaleType;
        private HashMap<String, String> mHeadersMap = new HashMap();
        private HashMap<String, String> mQueryParameterMap = new HashMap();
        private HashMap<String, String> mPathParameterMap = new HashMap();
        private CacheControl mCacheControl;
        private Executor mExecutor;
        private OkHttpClient mOkHttpClient;
        private String mUserAgent;

        public GetRequestBuilder(String url) {
            this.mUrl = url;
            this.mMethod = 0;
        }

        private GetRequestBuilder(String url, int method) {
            this.mUrl = url;
            this.mMethod = method;
        }

        @Override
        public GetRequestBuilder setPriority(Priority priority) {
            this.mPriority = priority;
            return this;
        }

        @Override
        public GetRequestBuilder setTag(Object tag) {
            this.mTag = tag;
            return this;
        }

        @Override
        public GetRequestBuilder addQueryParameter(String key, String value) {
            this.mQueryParameterMap.put(key, value);
            return this;
        }

        @Override
        public GetRequestBuilder addQueryParameter(HashMap<String, String> queryParameterMap) {
            if (queryParameterMap != null) {
                for (Map.Entry<String, String> entry : queryParameterMap.entrySet()) {
                    this.mQueryParameterMap.put(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        @Override
        public GetRequestBuilder addPathParameter(String key, String value) {
            this.mPathParameterMap.put(key, value);
            return this;
        }

        @Override
        public GetRequestBuilder addHeaders(String key, String value) {
            this.mHeadersMap.put(key, value);
            return this;
        }

        @Override
        public GetRequestBuilder addHeaders(HashMap<String, String> headerMap) {
            if (headerMap != null) {
                for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                    this.mHeadersMap.put(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        @Override
        public GetRequestBuilder doNotCacheResponse() {
            this.mCacheControl = new CacheControl.Builder().noStore().build();
            return this;
        }

        @Override
        public GetRequestBuilder getResponseOnlyIfCached() {
            this.mCacheControl = CacheControl.FORCE_CACHE;
            return this;
        }

        @Override
        public GetRequestBuilder getResponseOnlyFromNetwork() {
            this.mCacheControl = CacheControl.FORCE_NETWORK;
            return this;
        }

        @Override
        public GetRequestBuilder setMaxAgeCacheControl(int maxAge, TimeUnit timeUnit) {
            this.mCacheControl = new CacheControl.Builder().maxAge(maxAge, timeUnit).build();
            return this;
        }

        @Override
        public GetRequestBuilder setMaxStaleCacheControl(int maxStale, TimeUnit timeUnit) {
            this.mCacheControl = new CacheControl.Builder().maxStale(maxStale, timeUnit).build();
            return this;
        }

        @Override
        public GetRequestBuilder setExecutor(Executor executor) {
            this.mExecutor = executor;
            return this;
        }

        @Override
        public GetRequestBuilder setOkHttpClient(OkHttpClient okHttpClient) {
            this.mOkHttpClient = okHttpClient;
            return this;
        }

        @Override
        public GetRequestBuilder setUserAgent(String userAgent) {
            this.mUserAgent = userAgent;
            return this;
        }

        public GetRequestBuilder setBitmapConfig(Bitmap.Config bitmapConfig) {
            this.mDecodeConfig = bitmapConfig;
            return this;
        }

        public GetRequestBuilder setBitmapMaxHeight(int maxHeight) {
            this.mMaxHeight = maxHeight;
            return this;
        }

        public GetRequestBuilder setBitmapMaxWidth(int maxWidth) {
            this.mMaxWidth = maxWidth;
            return this;
        }

        public GetRequestBuilder setImageScaleType(ImageView.ScaleType imageScaleType) {
            this.mScaleType = imageScaleType;
            return this;
        }

        public ANRequest build() {
            return new ANRequest(this);
        }
    }

    public static class HeadRequestBuilder
    extends GetRequestBuilder {
        public HeadRequestBuilder(String url) {
            super(url, 4);
        }
    }
}

