/*
 * Decompiled with CFR 0.152.
 */
package webconnect.com.webconnect;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import webconnect.com.webconnect.WebParam;
import webconnect.com.webconnect.listener.ProgressListener;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lwebconnect/com/webconnect/HTTPInternalNetworking;", "", "()V", "ProgressResponseBody", "http_release"})
public final class HTTPInternalNetworking {

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lwebconnect/com/webconnect/HTTPInternalNetworking$ProgressResponseBody;", "Lokhttp3/ResponseBody;", "responseBody", "webParam", "Lwebconnect/com/webconnect/WebParam;", "(Lokhttp3/ResponseBody;Lwebconnect/com/webconnect/WebParam;)V", "bufferedSource", "Lokio/BufferedSource;", "contentLength", "", "contentType", "Lokhttp3/MediaType;", "source", "Lokio/Source;", "http_release"})
    public static final class ProgressResponseBody
    extends ResponseBody {
        private BufferedSource bufferedSource;
        private final ResponseBody responseBody;
        private final WebParam webParam;

        @Nullable
        public MediaType contentType() {
            return this.responseBody.contentType();
        }

        public long contentLength() {
            return this.responseBody.contentLength();
        }

        @Nullable
        public BufferedSource source() {
            if (this.bufferedSource == null) {
                BufferedSource bufferedSource = this.responseBody.source();
                Intrinsics.checkExpressionValueIsNotNull((Object)bufferedSource, (String)"responseBody.source()");
                this.bufferedSource = Okio.buffer((Source)this.source((Source)bufferedSource));
                Okio.source((InputStream)this.responseBody.byteStream());
            }
            return this.bufferedSource;
        }

        private final Source source(Source source2) {
            return (Source)new ForwardingSource(this, source2, source2){
                private long totalBytesRead;
                final /* synthetic */ ProgressResponseBody this$0;
                final /* synthetic */ Source $source;

                public final long getTotalBytesRead$http_release() {
                    return this.totalBytesRead;
                }

                public final void setTotalBytesRead$http_release(long l) {
                    this.totalBytesRead = l;
                }

                public long read(@NotNull Buffer sink, long byteCount) throws IOException {
                    Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
                    long bytesRead = super.read(sink, byteCount);
                    long length = ProgressResponseBody.access$getResponseBody$p(this.this$0).contentLength();
                    if (length == -1L) {
                        return bytesRead;
                    }
                    this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                    float progress = 0.0f;
                    try {
                        progress = (long)100 * this.totalBytesRead / length;
                        Log.d((String)HTTPInternalNetworking.class.getSimpleName(), (String)("progress = " + progress));
                    }
                    catch (Exception e) {
                        Log.e((String)HTTPInternalNetworking.class.getSimpleName(), (String)("Exception = " + e.getMessage()));
                    }
                    if (ProgressResponseBody.access$getWebParam$p(this.this$0).getProgressListener$http_release() != null) {
                        ProgressListener progressListener2 = ProgressResponseBody.access$getWebParam$p(this.this$0).getProgressListener$http_release();
                        if (progressListener2 == null) {
                            Intrinsics.throwNpe();
                        }
                        progressListener2.onProgress(this.totalBytesRead, ProgressResponseBody.access$getResponseBody$p(this.this$0).contentLength(), progress);
                    }
                    return bytesRead;
                }
                {
                    this.this$0 = $outer;
                    this.$source = $captured_local_variable$1;
                    super($super_call_param$2);
                }
            };
        }

        public ProgressResponseBody(@NotNull ResponseBody responseBody, @NotNull WebParam webParam) {
            Intrinsics.checkParameterIsNotNull((Object)responseBody, (String)"responseBody");
            Intrinsics.checkParameterIsNotNull((Object)webParam, (String)"webParam");
            this.responseBody = responseBody;
            this.webParam = webParam;
        }

        public static final /* synthetic */ ResponseBody access$getResponseBody$p(ProgressResponseBody $this) {
            return $this.responseBody;
        }

        public static final /* synthetic */ WebParam access$getWebParam$p(ProgressResponseBody $this) {
            return $this.webParam;
        }
    }
}

