/*
 * Decompiled with CFR 0.152.
 */
package com.amirarcane.lockscreen.fingerprint;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.fingerprint.FingerprintManager;
import android.os.CancellationSignal;
import android.support.v4.app.ActivityCompat;
import com.amirarcane.lockscreen.fingerprint.FingerPrintListener;

@TargetApi(value=23)
public class FingerprintHandler
extends FingerprintManager.AuthenticationCallback {
    private CancellationSignal cancellationSignal;
    private Context context;
    private FingerPrintListener mfingerPrintListener;

    public FingerprintHandler(Context mContext) {
        this.context = mContext;
    }

    public void startAuth(FingerprintManager manager, FingerprintManager.CryptoObject cryptoObject) {
        this.cancellationSignal = new CancellationSignal();
        if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.USE_FINGERPRINT") != 0) {
            return;
        }
        manager.authenticate(cryptoObject, this.cancellationSignal, 0, (FingerprintManager.AuthenticationCallback)this, null);
    }

    public void setFingerPrintListener(FingerPrintListener mfingerPrintListener) {
        this.mfingerPrintListener = mfingerPrintListener;
    }

    public void onAuthenticationError(int errMsgId, CharSequence errString) {
        this.mfingerPrintListener.onError(errString);
    }

    public void onAuthenticationFailed() {
        this.mfingerPrintListener.onFailed();
    }

    public void onAuthenticationHelp(int helpMsgId, CharSequence helpString) {
        this.mfingerPrintListener.onHelp(helpString);
    }

    public void onAuthenticationSucceeded(FingerprintManager.AuthenticationResult result) {
        this.mfingerPrintListener.onSuccess();
    }
}

