/*
 * Decompiled with CFR 0.152.
 */
package com.amirarcane.lockscreen.andrognito.pinlockview;

import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;

public class ItemSpaceDecoration
extends RecyclerView.ItemDecoration {
    private final int mHorizontalSpaceWidth;
    private final int mVerticalSpaceHeight;
    private final int mSpanCount;
    private final boolean mIncludeEdge;

    public ItemSpaceDecoration(int horizontalSpaceWidth, int verticalSpaceHeight, int spanCount, boolean includeEdge) {
        this.mHorizontalSpaceWidth = horizontalSpaceWidth;
        this.mVerticalSpaceHeight = verticalSpaceHeight;
        this.mSpanCount = spanCount;
        this.mIncludeEdge = includeEdge;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        int position = parent.getChildAdapterPosition(view);
        int column = position % this.mSpanCount;
        if (this.mIncludeEdge) {
            outRect.right = this.mHorizontalSpaceWidth - column * this.mHorizontalSpaceWidth / this.mSpanCount;
            outRect.left = (column + 1) * this.mHorizontalSpaceWidth / this.mSpanCount;
            if (position < this.mSpanCount) {
                outRect.top = this.mVerticalSpaceHeight;
            }
            outRect.bottom = this.mVerticalSpaceHeight;
        } else {
            outRect.right = column * this.mHorizontalSpaceWidth / this.mSpanCount;
            outRect.left = this.mHorizontalSpaceWidth - (column + 1) * this.mHorizontalSpaceWidth / this.mSpanCount;
            if (position >= this.mSpanCount) {
                outRect.top = this.mVerticalSpaceHeight;
            }
        }
    }
}

