/*
 * Decompiled with CFR 0.152.
 */
package com.aminyazdanpanah.maps.android.charts;

import android.content.res.Resources;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Arrays;

public class DonutChart
extends Drawable {
    private float radius = 120.0f;
    private Paint paint;
    private Path myPath;
    private RectF outterCircle;
    private RectF innerCircle;
    private int[] COLORS;
    private float[] value_degree;
    private final float[] value_real;
    private int start = -1;
    private Paint paint_text = new Paint(1);

    DonutChart(float[] values, int[] colors) {
        this.COLORS = Arrays.copyOf(colors, colors.length);
        this.value_real = Arrays.copyOf(values, values.length);
        this.value_degree = this.calculateData(values);
        this.paint = new Paint();
        this.paint.setDither(true);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setStrokeJoin(Paint.Join.ROUND);
        this.paint.setStrokeCap(Paint.Cap.ROUND);
        this.paint.setAntiAlias(true);
        this.paint.setStrokeWidth(this.radius / 14.0f);
        Paint shadowPaint = new Paint();
        shadowPaint.setColor(-268435456);
        shadowPaint.setStyle(Paint.Style.STROKE);
        shadowPaint.setAntiAlias(true);
        shadowPaint.setStrokeWidth(6.0f);
        shadowPaint.setMaskFilter((MaskFilter)new BlurMaskFilter(4.0f, BlurMaskFilter.Blur.SOLID));
        this.myPath = new Path();
        this.outterCircle = new RectF();
        this.innerCircle = new RectF();
        RectF shadowRectF = new RectF();
        float adjust = 0.019f * this.radius;
        shadowRectF.set(adjust, adjust, this.radius * 2.0f - adjust, this.radius * 2.0f - adjust);
        adjust = 0.038f * this.radius;
        this.outterCircle.set(adjust, adjust, this.radius * 2.0f - adjust, this.radius * 2.0f - adjust);
        adjust = 0.276f * this.radius;
        this.innerCircle.set(adjust, adjust, this.radius * 2.0f - adjust, this.radius * 2.0f - adjust);
    }

    public void draw(@NonNull Canvas canvas) {
        this.paint.setShader(null);
        float adjust = 0.0095f * this.radius;
        this.paint.setShadowLayer(8.0f, adjust, -adjust, -1442840576);
        this.drawDonut(canvas, this.paint, 0.0f, 359.9f);
        for (int i = 0; i < this.value_degree.length; ++i) {
            float sweep = this.value_degree[i];
            if (i != 0) {
                this.start = (int)((float)this.start + this.value_degree[i - 1]);
            }
            if (this.start == -1 && sweep == 0.0f) {
                sweep = 359.0f;
            }
            this.setGradient(this.COLORS[i], this.darkenColor(this.COLORS[i]));
            this.drawDonut(canvas, this.paint, this.start, sweep);
            if (this.value_real[i] == 0.0f) continue;
            this.paint_text.setColor(-16777216);
            this.paint_text.setTextSize(DonutChart.convertDpToPixel(13.0f));
            double x = 35.0 * Math.cos(Math.toRadians((float)this.start + sweep / 2.0f)) + 35.0;
            double y = 35.0 * Math.sin(Math.toRadians((float)this.start + sweep / 2.0f)) + 45.0;
            canvas.drawText((int)this.value_real[i] + "", DonutChart.convertDpToPixel((float)x), DonutChart.convertDpToPixel((float)y), this.paint_text);
        }
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return 0;
    }

    private void drawDonut(Canvas canvas, Paint paint, float start, float sweep) {
        this.myPath.reset();
        this.myPath.arcTo(this.outterCircle, start, sweep, false);
        this.myPath.arcTo(this.innerCircle, start + sweep, -sweep, false);
        this.myPath.close();
        canvas.drawPath(this.myPath, paint);
    }

    private void setGradient(int sColor, int eColor) {
        this.paint.setShader((Shader)new RadialGradient(this.radius, this.radius, this.radius - 5.0f, new int[]{sColor, eColor}, new float[]{0.6f, 0.95f}, Shader.TileMode.CLAMP));
    }

    private float[] calculateData(float[] data) {
        float total = 0.0f;
        for (float aData : data) {
            total += aData;
        }
        for (int i = 0; i < data.length; ++i) {
            data[i] = 360.0f * (data[i] / total);
        }
        return data;
    }

    private int darkenColor(int color) {
        int a = Color.alpha((int)color);
        int r = Math.round((float)Color.red((int)color) * 0.8f);
        int g = Math.round((float)Color.green((int)color) * 0.8f);
        int b = Math.round((float)Color.blue((int)color) * 0.8f);
        return Color.argb((int)a, (int)Math.min(r, 255), (int)Math.min(g, 255), (int)Math.min(b, 255));
    }

    private static float convertDpToPixel(float dp) {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return Math.round(px);
    }
}

