/*
 * Decompiled with CFR 0.152.
 */
package com.aminyazdanpanah.maps.android.charts;

import android.content.Context;
import com.aminyazdanpanah.maps.android.charts.model.CMarker;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.maps.android.clustering.Cluster;
import com.google.maps.android.clustering.ClusterManager;
import com.google.maps.android.clustering.view.DefaultClusterRenderer;
import com.google.maps.android.ui.IconGenerator;
import java.util.Arrays;

public class ChartRenderer
extends DefaultClusterRenderer<CMarker> {
    final IconGenerator mClusterIconGenerator;
    int[] COLORS = new int[]{-65536, -16711936, -16776961, -256};
    private String[] names;

    ChartRenderer(Context context, GoogleMap map, ClusterManager<CMarker> clusterManager) {
        super(context, map, clusterManager);
        this.mClusterIconGenerator = new IconGenerator(context);
    }

    protected void onBeforeClusterItemRendered(CMarker CMarker2, MarkerOptions markerOptions) {
        markerOptions.icon(BitmapDescriptorFactory.fromResource((int)CMarker2.getMarker())).title(CMarker2.getTitle());
    }

    public void colors(int[] colors) {
        this.COLORS = Arrays.copyOf(colors, colors.length);
    }

    public void names(String[] c_names) {
        this.names = Arrays.copyOf(c_names, c_names.length);
    }

    float[] values(Cluster<CMarker> cluster) {
        float[] values = new float[this.names.length];
        Arrays.fill(values, 0.0f);
        for (CMarker p : cluster.getItems()) {
            int key;
            int n = key = Arrays.asList(this.names).indexOf(p.getName());
            values[n] = values[n] + 1.0f;
        }
        return values;
    }

    protected boolean shouldRenderAsCluster(Cluster cluster) {
        return cluster.getSize() > 1;
    }
}

