/*
 * Decompiled with CFR 0.152.
 */
package com.aminyazdanpanah.maps.android.charts;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import com.aminyazdanpanah.maps.android.charts.BarChart;
import com.aminyazdanpanah.maps.android.charts.ChartRenderer;
import com.aminyazdanpanah.maps.android.charts.R;
import com.aminyazdanpanah.maps.android.charts.model.CMarker;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.maps.android.clustering.Cluster;
import com.google.maps.android.clustering.ClusterManager;

public class BarChartRenderer
extends ChartRenderer {
    private final ImageView mClusterImageView;

    public BarChartRenderer(Context context, GoogleMap map, ClusterManager<CMarker> clusterManager) {
        super(context, map, clusterManager);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View barChart = inflater.inflate(R.layout.barchart_cluster, null);
        this.mClusterIconGenerator.setContentView(barChart);
        this.mClusterImageView = (ImageView)barChart.findViewById(R.id.image);
    }

    protected void onBeforeClusterRendered(Cluster<CMarker> cluster, MarkerOptions markerOptions) {
        ColorDrawable backgroundColor = new ColorDrawable(-1);
        this.mClusterIconGenerator.setBackground((Drawable)backgroundColor);
        BarChart Chart = new BarChart(this.values(cluster), this.COLORS);
        this.mClusterImageView.setImageDrawable((Drawable)Chart);
        Bitmap icon = this.mClusterIconGenerator.makeIcon((CharSequence)(cluster.getSize() + ""));
        markerOptions.icon(BitmapDescriptorFactory.fromBitmap((Bitmap)icon)).anchor(0.5f, 0.5f);
    }
}

