/*
 * Decompiled with CFR 0.152.
 */
package com.aminyazdanpanah.maps.android.charts;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Arrays;

public class BarChart
extends Drawable {
    private Paint paint = new Paint(1);
    private int[] COLORS;
    private float[] value_siza;
    private final float[] value_real;
    private float leftx = 17.0f;
    private float rightx = 3.0f;

    BarChart(float[] values, int[] colors) {
        this.COLORS = Arrays.copyOf(colors, colors.length);
        this.value_real = Arrays.copyOf(values, values.length);
        this.value_siza = this.calculateData(values);
    }

    public void draw(@NonNull Canvas canvas) {
        float bottomy = 70.0f;
        for (int i = 0; i < this.value_siza.length; ++i) {
            this.paint.setTextSize(BarChart.convertDpToPixel(13.0f));
            this.paint.setColor(-16777216);
            canvas.drawText((int)this.value_real[i] + "", BarChart.convertDpToPixel(this.rightx), BarChart.convertDpToPixel(this.value_siza[i] - 10.0f), this.paint);
            this.paint.setColor(this.COLORS[i]);
            canvas.drawRect(BarChart.convertDpToPixel(this.leftx), BarChart.convertDpToPixel(this.value_siza[i]), BarChart.convertDpToPixel(this.rightx), BarChart.convertDpToPixel(bottomy), this.paint);
            this.leftx += 17.0f;
            this.rightx += 17.0f;
        }
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return 0;
    }

    private static float convertDpToPixel(float dp) {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return Math.round(px);
    }

    private float[] calculateData(float[] data) {
        float total = 0.0f;
        for (float aData : data) {
            total += aData;
        }
        for (int i = 0; i < data.length; ++i) {
            data[i] = (1.0f - data[i] / total) * 70.0f;
        }
        return data;
    }
}

