/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.spring;

import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletResponseWriter;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.spring.AwsSpringHttpProcessingUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.cloud.function.serverless.web.ServerlessMVC;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public final class AwsSpringWebCustomRuntimeEventLoop
implements SmartLifecycle {
    private static Log logger = LogFactory.getLog(AwsSpringWebCustomRuntimeEventLoop.class);
    static final String LAMBDA_VERSION_DATE = "2018-06-01";
    private static final String LAMBDA_ERROR_URL_TEMPLATE = "http://{0}/{1}/runtime/invocation/{2}/error";
    private static final String LAMBDA_RUNTIME_URL_TEMPLATE = "http://{0}/{1}/runtime/invocation/next";
    private static final String LAMBDA_INVOCATION_URL_TEMPLATE = "http://{0}/{1}/runtime/invocation/{2}/response";
    private static final String USER_AGENT_VALUE = String.format("spring-cloud-function/%s-%s", System.getProperty("java.runtime.version"), AwsSpringHttpProcessingUtils.extractVersion());
    private final ServletWebServerApplicationContext applicationContext;
    private volatile boolean running;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public AwsSpringWebCustomRuntimeEventLoop(ServletWebServerApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void run() {
        this.running = true;
        this.executor.execute(() -> this.eventLoop(this.applicationContext));
    }

    public void start() {
        this.run();
    }

    public void stop() {
        this.executor.shutdownNow();
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    private void eventLoop(ServletWebServerApplicationContext context) {
        ServerlessMVC mvc = ServerlessMVC.INSTANCE((ServletWebServerApplicationContext)context);
        ConfigurableEnvironment environment = context.getEnvironment();
        logger.info((Object)"Starting AWSWebRuntimeEventLoop");
        String runtimeApi = environment.getProperty("AWS_LAMBDA_RUNTIME_API");
        String eventUri = MessageFormat.format(LAMBDA_RUNTIME_URL_TEMPLATE, runtimeApi, LAMBDA_VERSION_DATE);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Event URI: " + eventUri));
        }
        RequestEntity requestEntity = RequestEntity.get((URI)URI.create(eventUri)).header("User-Agent", new String[]{USER_AGENT_VALUE}).build();
        RestTemplate rest = new RestTemplate();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        AwsProxyHttpServletResponseWriter responseWriter = new AwsProxyHttpServletResponseWriter();
        logger.info((Object)"Entering event loop");
        while (this.isRunning()) {
            logger.debug((Object)"Attempting to get new event");
            ResponseEntity incomingEvent = rest.exchange(requestEntity, String.class);
            if (incomingEvent == null || !incomingEvent.hasBody()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("New Event received from AWS Gateway: " + (String)incomingEvent.getBody()));
            }
            String requestId = incomingEvent.getHeaders().getFirst("Lambda-Runtime-Aws-Request-Id");
            try {
                logger.debug((Object)"Submitting request to the user's web application");
                AwsProxyResponse awsResponse = AwsSpringHttpProcessingUtils.processRequest(AwsSpringHttpProcessingUtils.generateHttpServletRequest((String)incomingEvent.getBody(), null, mvc.getServletContext(), mapper), mvc, responseWriter);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Received response - body: " + awsResponse.getBody() + "; status: " + awsResponse.getStatusCode() + "; headers: " + String.valueOf(awsResponse.getHeaders())));
                }
                String invocationUrl = MessageFormat.format(LAMBDA_INVOCATION_URL_TEMPLATE, runtimeApi, LAMBDA_VERSION_DATE, requestId);
                ResponseEntity result = rest.exchange(((RequestEntity.BodyBuilder)RequestEntity.post((URI)URI.create(invocationUrl)).header("User-Agent", new String[]{USER_AGENT_VALUE})).body((Object)awsResponse), byte[].class);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Response sent: body: " + String.valueOf(result.getBody()) + "; status: " + String.valueOf(result.getStatusCode()) + "; headers: " + String.valueOf(result.getHeaders())));
                }
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)("Result POST status: " + String.valueOf(result)));
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.propagateAwsError(requestId, e, mapper, runtimeApi, rest);
            }
        }
    }

    private void propagateAwsError(String requestId, Exception e, ObjectMapper mapper, String runtimeApi, RestTemplate rest) {
        String errorMessage = e.getMessage();
        String errorType = e.getClass().getSimpleName();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String stackTrace = sw.toString();
        HashMap<String, String> em = new HashMap<String, String>();
        em.put("errorMessage", errorMessage);
        em.put("errorType", errorType);
        em.put("stackTrace", stackTrace);
        try {
            byte[] outputBody = mapper.writeValueAsBytes(em);
            String errorUrl = MessageFormat.format(LAMBDA_ERROR_URL_TEMPLATE, runtimeApi, LAMBDA_VERSION_DATE, requestId);
            ResponseEntity result = rest.exchange(((RequestEntity.BodyBuilder)RequestEntity.post((URI)URI.create(errorUrl)).header("User-Agent", new String[]{USER_AGENT_VALUE})).body((Object)outputBody), Object.class);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Result ERROR status: " + String.valueOf(result.getStatusCode())));
            }
        }
        catch (Exception e2) {
            throw new IllegalArgumentException("Failed to report error", e2);
        }
    }
}

