/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.spring;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.proxy.AsyncInitializationWrapper;
import com.amazonaws.serverless.proxy.InitializationTypeHelper;
import com.amazonaws.serverless.proxy.internal.InitializableLambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletResponseWriter;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.spring.AwsSpringHttpProcessingUtils;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.cloud.function.serverless.web.FunctionClassUtils;
import org.springframework.cloud.function.serverless.web.ServerlessMVC;

public class SpringDelegatingLambdaContainerHandler
implements RequestStreamHandler {
    private final ServerlessMVC mvc;
    private final ObjectMapper mapper;
    private final AwsProxyHttpServletResponseWriter responseWriter;

    public SpringDelegatingLambdaContainerHandler() throws ContainerInitializationException {
        this(FunctionClassUtils.getStartClass());
    }

    public SpringDelegatingLambdaContainerHandler(Class<?> ... startupClasses) throws ContainerInitializationException {
        SpringDelegatingInitHandler initHandler = new SpringDelegatingInitHandler(startupClasses);
        if (InitializationTypeHelper.isAsyncInitializationDisabled()) {
            initHandler.initialize();
        } else {
            AsyncInitializationWrapper asyncInitWrapper = new AsyncInitializationWrapper();
            asyncInitWrapper.start((InitializableLambdaContainerHandler)initHandler);
        }
        this.mvc = initHandler.getMvc();
        this.mapper = new ObjectMapper();
        this.responseWriter = new AwsProxyHttpServletResponseWriter();
    }

    public void handleRequest(InputStream input, OutputStream output, Context lambdaContext) throws IOException {
        HttpServletRequest httpServletRequest = AwsSpringHttpProcessingUtils.generateHttpServletRequest(input, lambdaContext, this.mvc.getServletContext(), this.mapper);
        AwsProxyResponse awsProxyResponse = AwsSpringHttpProcessingUtils.processRequest(httpServletRequest, this.mvc, this.responseWriter);
        this.mapper.writeValue(output, (Object)awsProxyResponse);
    }

    private static final class SpringDelegatingInitHandler
    implements InitializableLambdaContainerHandler {
        private ServerlessMVC mvc;
        private final Class<?>[] startupClasses;

        public SpringDelegatingInitHandler(Class<?> ... startupClasses) {
            this.startupClasses = startupClasses;
        }

        public void initialize() throws ContainerInitializationException {
            this.mvc = ServerlessMVC.INSTANCE((Class[])this.startupClasses);
            this.mvc.waitForContext();
        }

        public ServerlessMVC getMvc() {
            return this.mvc;
        }
    }
}

