/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.jersey;

import com.amazonaws.serverless.proxy.AwsProxyExceptionHandler;
import com.amazonaws.serverless.proxy.AwsProxySecurityContextWriter;
import com.amazonaws.serverless.proxy.ExceptionHandler;
import com.amazonaws.serverless.proxy.RequestReader;
import com.amazonaws.serverless.proxy.ResponseWriter;
import com.amazonaws.serverless.proxy.SecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.serverless.proxy.internal.servlet.AwsLambdaServletContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequestReader;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletResponseWriter;
import com.amazonaws.serverless.proxy.internal.testutils.Timer;
import com.amazonaws.serverless.proxy.jersey.JerseyHandlerFilter;
import com.amazonaws.serverless.proxy.jersey.suppliers.AwsProxyServletContextSupplier;
import com.amazonaws.serverless.proxy.jersey.suppliers.AwsProxyServletRequestSupplier;
import com.amazonaws.serverless.proxy.jersey.suppliers.AwsProxyServletResponseSupplier;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.services.lambda.runtime.Context;
import java.util.EnumSet;
import java.util.concurrent.CountDownLatch;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ResourceConfig;

public class JerseyLambdaContainerHandler<RequestType, ResponseType>
extends AwsLambdaServletContainerHandler<RequestType, ResponseType, AwsProxyHttpServletRequest, AwsHttpServletResponse> {
    private JerseyHandlerFilter jerseyFilter;
    private boolean initialized;

    public static JerseyLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse> getAwsProxyHandler(Application jaxRsApplication) {
        JerseyLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse> newHandler = new JerseyLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse>(AwsProxyRequest.class, AwsProxyResponse.class, (RequestReader<AwsProxyRequest, AwsProxyHttpServletRequest>)new AwsProxyHttpServletRequestReader(), (ResponseWriter<AwsHttpServletResponse, AwsProxyResponse>)new AwsProxyHttpServletResponseWriter(), (SecurityContextWriter<AwsProxyRequest>)new AwsProxySecurityContextWriter(), (ExceptionHandler<AwsProxyResponse>)new AwsProxyExceptionHandler(), jaxRsApplication);
        newHandler.initialize();
        return newHandler;
    }

    public JerseyLambdaContainerHandler(Class<RequestType> requestTypeClass, Class<ResponseType> responseTypeClass, RequestReader<RequestType, AwsProxyHttpServletRequest> requestReader, ResponseWriter<AwsHttpServletResponse, ResponseType> responseWriter, SecurityContextWriter<RequestType> securityContextWriter, ExceptionHandler<ResponseType> exceptionHandler, Application jaxRsApplication) {
        super(requestTypeClass, responseTypeClass, requestReader, responseWriter, securityContextWriter, exceptionHandler);
        Timer.start((String)"JERSEY_CONTAINER_CONSTRUCTOR");
        this.initialized = false;
        if (jaxRsApplication instanceof ResourceConfig) {
            ((ResourceConfig)jaxRsApplication).register((Object)new AbstractBinder(){

                protected void configure() {
                    ((SupplierClassBinding)((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(AwsProxyServletContextSupplier.class).proxy(true)).proxyForSameScope(true)).to(ServletContext.class)).in(RequestScoped.class);
                    ((SupplierClassBinding)((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(AwsProxyServletRequestSupplier.class).proxy(true)).proxyForSameScope(true)).to(HttpServletRequest.class)).in(RequestScoped.class);
                    ((SupplierClassBinding)((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(AwsProxyServletResponseSupplier.class).proxy(true)).proxyForSameScope(true)).to(HttpServletResponse.class)).in(RequestScoped.class);
                }
            });
        }
        this.jerseyFilter = new JerseyHandlerFilter(jaxRsApplication);
        Timer.stop((String)"JERSEY_CONTAINER_CONSTRUCTOR");
    }

    protected AwsHttpServletResponse getContainerResponse(AwsProxyHttpServletRequest request, CountDownLatch latch) {
        return new AwsHttpServletResponse((AwsHttpServletRequest)request, latch);
    }

    protected void handleRequest(AwsProxyHttpServletRequest httpServletRequest, AwsHttpServletResponse httpServletResponse, Context lambdaContext) throws Exception {
        if (!this.initialized) {
            this.initialize();
        }
        Timer.start((String)"JERSEY_HANDLE_REQUEST");
        httpServletRequest.setServletContext(this.getServletContext());
        this.doFilter((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, null);
        Timer.stop((String)"JERSEY_HANDLE_REQUEST");
    }

    public void initialize() {
        Timer.start((String)"JERSEY_COLD_START_INIT");
        FilterRegistration.Dynamic jerseyFilterReg = this.getServletContext().addFilter("JerseyFilter", (Filter)this.jerseyFilter);
        jerseyFilterReg.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/*"});
        Timer.stop((String)"JERSEY_COLD_START_INIT");
        this.initialized = true;
    }

    public InjectionManager getInjectionManager() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.jerseyFilter.getApplicationHandler().getInjectionManager();
    }
}

