/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.jersey;

import com.amazonaws.serverless.exceptions.InvalidRequestEventException;
import com.amazonaws.serverless.proxy.internal.RequestReader;
import com.amazonaws.serverless.proxy.internal.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.internal.model.ContainerConfig;
import com.amazonaws.services.lambda.runtime.Context;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.server.ContainerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JerseyAwsProxyRequestReader
extends RequestReader<AwsProxyRequest, ContainerRequest> {
    private static AwsProxyRequest currentRequest;
    private static Context currentLambdaContext;
    private Logger log = LoggerFactory.getLogger(JerseyAwsProxyRequestReader.class);

    public ContainerRequest readRequest(AwsProxyRequest request, SecurityContext securityContext, Context lambdaContext, ContainerConfig config) throws InvalidRequestEventException {
        URI basePathUri;
        currentRequest = request;
        currentLambdaContext = lambdaContext;
        request.setPath(this.stripBasePath(request.getPath(), config));
        String basePath = "/";
        try {
            basePathUri = new URI(basePath);
        }
        catch (URISyntaxException e) {
            this.log.error("Could not read base path URI", (Throwable)e);
            throw new InvalidRequestEventException("Error while generating base path URI: " + basePath, (Exception)e);
        }
        UriBuilder uriBuilder = UriBuilder.fromPath((String)request.getPath());
        if (request.getQueryStringParameters() != null) {
            for (String paramKey : request.getQueryStringParameters().keySet()) {
                uriBuilder = uriBuilder.queryParam(paramKey, new Object[]{request.getQueryStringParameters().get(paramKey)});
            }
        }
        URI requestPathUri = uriBuilder.build(new Object[0]);
        MapPropertiesDelegate apiGatewayProperties = new MapPropertiesDelegate();
        apiGatewayProperties.setProperty("com.amazonaws.apigateway.request.context", (Object)request.getRequestContext());
        apiGatewayProperties.setProperty("com.amazonaws.apigateway.stage.variables", (Object)request.getStageVariables());
        apiGatewayProperties.setProperty("com.amazonaws.lambda.context", (Object)lambdaContext);
        ContainerRequest requestContext = new ContainerRequest(basePathUri, requestPathUri, request.getHttpMethod(), securityContext, (PropertiesDelegate)apiGatewayProperties);
        if (request.getBody() != null) {
            if (request.isBase64Encoded()) {
                requestContext.setEntityStream((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(request.getBody())));
            } else {
                requestContext.setEntityStream((InputStream)new ByteArrayInputStream(request.getBody().getBytes()));
            }
        }
        if (request.getHeaders() != null) {
            for (String headerName : request.getHeaders().keySet()) {
                requestContext.headers(headerName, new Object[]{request.getHeaders().get(headerName)});
            }
        }
        return requestContext;
    }

    protected Class<? extends AwsProxyRequest> getRequestClass() {
        return AwsProxyRequest.class;
    }

    public static AwsProxyRequest getCurrentRequest() {
        return currentRequest;
    }

    public static Context getCurrentLambdaContext() {
        return currentLambdaContext;
    }
}

