/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.model;

import com.amazonaws.serverless.proxy.model.AwsProxyRequestContext;
import com.amazonaws.serverless.proxy.model.Headers;
import com.amazonaws.serverless.proxy.model.MultiValuedTreeMap;
import com.amazonaws.serverless.proxy.model.RequestSource;
import com.amazonaws.serverless.proxy.model.SingleValueHeaders;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AwsProxyRequest {
    private String body;
    private String version;
    private String resource;
    private AwsProxyRequestContext requestContext;
    private MultiValuedTreeMap<String, String> multiValueQueryStringParameters;
    private Map<String, String> queryStringParameters;
    private Headers multiValueHeaders = new Headers();
    private SingleValueHeaders headers;
    private Map<String, String> pathParameters;
    private String httpMethod;
    private Map<String, String> stageVariables;
    private String path;
    private boolean isBase64Encoded;

    public AwsProxyRequest() {
        this.multiValueQueryStringParameters = new MultiValuedTreeMap();
        this.pathParameters = new HashMap<String, String>();
        this.stageVariables = new HashMap<String, String>();
    }

    @JsonIgnore
    public String getQueryString() {
        StringBuilder params = new StringBuilder("");
        if (this.getMultiValueQueryStringParameters() == null) {
            return "";
        }
        for (String key : this.getMultiValueQueryStringParameters().keySet()) {
            Iterator iterator = this.getMultiValueQueryStringParameters().get(key).iterator();
            while (iterator.hasNext()) {
                String val = (String)iterator.next();
                String separator = params.length() == 0 ? "?" : "&";
                params.append(separator).append(key).append("=").append(val);
            }
        }
        return params.toString();
    }

    public RequestSource getRequestSource() {
        if (this.getRequestContext() != null && this.getRequestContext().getElb() != null) {
            return RequestSource.ALB;
        }
        return RequestSource.API_GATEWAY;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getResource() {
        return this.resource;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public AwsProxyRequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(AwsProxyRequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public MultiValuedTreeMap<String, String> getMultiValueQueryStringParameters() {
        return this.multiValueQueryStringParameters;
    }

    public void setMultiValueQueryStringParameters(MultiValuedTreeMap<String, String> multiValueQueryStringParameters) {
        this.multiValueQueryStringParameters = multiValueQueryStringParameters;
    }

    public Map<String, String> getQueryStringParameters() {
        return this.queryStringParameters;
    }

    public void setQueryStringParameters(Map<String, String> queryStringParameters) {
        this.queryStringParameters = queryStringParameters;
    }

    public Headers getMultiValueHeaders() {
        return this.multiValueHeaders;
    }

    public void setMultiValueHeaders(Headers multiValueHeaders) {
        this.multiValueHeaders = multiValueHeaders;
    }

    public SingleValueHeaders getHeaders() {
        return this.headers;
    }

    public void setHeaders(SingleValueHeaders headers) {
        this.headers = headers;
    }

    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    public void setPathParameters(Map<String, String> pathParameters) {
        this.pathParameters = pathParameters;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public Map<String, String> getStageVariables() {
        return this.stageVariables;
    }

    public void setStageVariables(Map<String, String> stageVariables) {
        this.stageVariables = stageVariables;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @JsonProperty(value="isBase64Encoded")
    public boolean isBase64Encoded() {
        return this.isBase64Encoded;
    }

    public void setIsBase64Encoded(boolean base64Encoded) {
        this.isBase64Encoded = base64Encoded;
    }
}

