/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.SecurityUtils;
import com.amazonaws.serverless.proxy.internal.servlet.AwsLambdaServletContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyRequestDispatcher;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletRegistration;
import com.amazonaws.serverless.proxy.internal.servlet.FilterHolder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsServletContext
implements ServletContext {
    public static final int SERVLET_API_MAJOR_VERSION = 6;
    public static final int SERVLET_API_MINOR_VERSION = 0;
    public static final String SERVER_INFO = "aws-serverless-java-container/6.0";
    private Map<String, FilterHolder> filters;
    private Map<String, AwsServletRegistration> servletRegistrations;
    private Map<String, Object> attributes;
    private Map<String, String> initParameters;
    private AwsLambdaServletContainerHandler containerHandler;
    private Logger log = LoggerFactory.getLogger(AwsServletContext.class);
    private static AwsServletContext instance;

    public AwsServletContext(AwsLambdaServletContainerHandler containerHandler) {
        this.containerHandler = containerHandler;
        this.attributes = new HashMap<String, Object>();
        this.initParameters = new HashMap<String, String>();
        this.filters = new LinkedHashMap<String, FilterHolder>();
        this.servletRegistrations = new HashMap<String, AwsServletRegistration>();
    }

    public static void clearServletContextCache() {
        instance = null;
    }

    public String getContextPath() {
        return "";
    }

    public void setResponseCharacterEncoding(String encoding) {
        throw new UnsupportedOperationException();
    }

    public String getResponseCharacterEncoding() {
        return null;
    }

    public void setRequestCharacterEncoding(String encoding) {
        throw new UnsupportedOperationException();
    }

    public String getRequestCharacterEncoding() {
        return null;
    }

    public void setSessionTimeout(int sessionTimeout) {
        throw new UnsupportedOperationException();
    }

    public int getSessionTimeout() {
        return 0;
    }

    public ServletContext getContext(String s) {
        return this;
    }

    public int getMajorVersion() {
        return 6;
    }

    public int getMinorVersion() {
        return 0;
    }

    public int getEffectiveMajorVersion() {
        return 6;
    }

    public int getEffectiveMinorVersion() {
        return 0;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    public String getMimeType(String file) {
        if (file == null || !file.contains(".")) {
            return null;
        }
        String mimeType = null;
        try {
            mimeType = Files.probeContentType(Paths.get(file, new String[0]));
        }
        catch (IOException | InvalidPathException e) {
            this.log("unable to probe for content type, will use fallback", e);
        }
        if (mimeType == null) {
            try {
                String mimeTypeGuess = URLConnection.guessContentTypeFromName(new File(file).getName());
                if (mimeTypeGuess != null) {
                    mimeType = mimeTypeGuess;
                }
            }
            catch (Exception e) {
                this.log("couldn't find a better contentType than " + mimeType + " for file " + file, e);
            }
        }
        return mimeType;
    }

    public Set<String> getResourcePaths(String s) {
        throw new UnsupportedOperationException();
    }

    public URL getResource(String s) throws MalformedURLException {
        return AwsServletContext.class.getResource(s);
    }

    public InputStream getResourceAsStream(String s) {
        return AwsServletContext.class.getResourceAsStream(s);
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return new AwsProxyRequestDispatcher(s, false, this.containerHandler);
    }

    public RequestDispatcher getNamedDispatcher(String s) {
        return new AwsProxyRequestDispatcher(s, true, this.containerHandler);
    }

    public Servlet getServletForPath(String path) {
        String[] pathParts = path.split("/");
        for (AwsServletRegistration reg : this.servletRegistrations.values()) {
            for (String p : reg.getMappings()) {
                if ("".equals(p) || "/".equals(p) || "/*".equals(p)) {
                    return reg.getServlet();
                }
                if ("".equals(path) || "/".equals(path)) continue;
                String[] regParts = p.split("/");
                for (int i = 0; i < regParts.length && (regParts[i].equals(pathParts[i]) || "*".equals(regParts[i])); ++i) {
                    if (i != regParts.length - 1 || !regParts[i].equals(pathParts[i]) && !"*".equals(regParts[i])) continue;
                    return reg.getServlet();
                }
            }
        }
        return null;
    }

    public void log(String s) {
        this.log.info(SecurityUtils.encode(s));
    }

    public void log(String s, Throwable throwable) {
        this.log.error(SecurityUtils.encode(s), throwable);
    }

    public String getRealPath(String s) {
        String absPath = null;
        URL fileUrl = ClassLoader.getSystemResource(s);
        if (fileUrl != null) {
            try {
                absPath = new File(fileUrl.toURI()).getAbsolutePath();
            }
            catch (URISyntaxException e) {
                this.log.error("Error while looking for real path {}: {}", (Object)SecurityUtils.encode(s), (Object)SecurityUtils.encode(e.getMessage()));
            }
        }
        return absPath;
    }

    public String getServerInfo() {
        return SERVER_INFO;
    }

    public String getInitParameter(String s) {
        return this.initParameters.get(s);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParameters.keySet());
    }

    public boolean setInitParameter(String s, String s1) {
        this.initParameters.put(s, s1);
        return true;
    }

    public Object getAttribute(String s) {
        return this.attributes.get(s);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public void setAttribute(String s, Object o) {
        this.attributes.put(s, o);
    }

    public void removeAttribute(String s) {
        this.attributes.remove(s);
    }

    public String getServletContextName() {
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String s, String s1) {
        try {
            Class<?> servletClass = this.getClassLoader().loadClass(s1);
            Object servlet = this.createServlet(servletClass);
            this.servletRegistrations.put(s, new AwsServletRegistration(s, (Servlet)servlet, this));
            return this.servletRegistrations.get(s);
        }
        catch (ServletException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ServletRegistration.Dynamic addServlet(String s, Servlet servlet) {
        this.servletRegistrations.put(s, new AwsServletRegistration(s, servlet, this));
        return this.servletRegistrations.get(s);
    }

    public ServletRegistration.Dynamic addServlet(String s, Class<? extends Servlet> aClass) {
        try {
            Servlet servlet = this.createServlet(aClass);
            this.servletRegistrations.put(s, new AwsServletRegistration(s, servlet, this));
            return this.servletRegistrations.get(s);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
    }

    public ServletRegistration.Dynamic addJspFile(String s, String s1) {
        throw new UnsupportedOperationException();
    }

    public <T extends Servlet> T createServlet(Class<T> aClass) throws ServletException {
        try {
            return (T)((Servlet)aClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public ServletRegistration getServletRegistration(String s) {
        return this.servletRegistrations.get(s);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.servletRegistrations;
    }

    public FilterRegistration.Dynamic addFilter(String name, String filterClass) {
        try {
            Class<?> newFilterClass = this.getClassLoader().loadClass(filterClass);
            if (!Filter.class.isAssignableFrom(newFilterClass)) {
                throw new IllegalArgumentException(filterClass + " does not implement Filter");
            }
            Class<?> filterCastClass = newFilterClass;
            return this.addFilter(name, filterCastClass);
        }
        catch (ClassNotFoundException e) {
            this.log.error("Could not find filter class", (Throwable)e);
            throw new IllegalStateException("Filter class " + filterClass + " not found");
        }
    }

    public FilterRegistration.Dynamic addFilter(String name, Filter filter) {
        if (name == null || "".equals(name.trim())) {
            throw new IllegalArgumentException("Missing filter name");
        }
        if (this.filters.containsKey(name)) {
            return null;
        }
        this.log.debug("Adding filter '{}' from {}", (Object)SecurityUtils.encode(name), (Object)SecurityUtils.encode(filter.toString()));
        FilterHolder newFilter = new FilterHolder(name, filter, this);
        this.filters.put(newFilter.getFilterName(), newFilter);
        return newFilter.getRegistration();
    }

    public FilterRegistration.Dynamic addFilter(String name, Class<? extends Filter> filterClass) {
        try {
            this.log.debug("Adding filter '{}' from {}", (Object)SecurityUtils.encode(name), (Object)SecurityUtils.encode(filterClass.getName()));
            Filter newFilter = this.createFilter(filterClass);
            return this.addFilter(name, newFilter);
        }
        catch (ServletException e) {
            this.log.error("Could not register filter: ", (Throwable)e);
            return null;
        }
    }

    public <T extends Filter> T createFilter(Class<T> aClass) throws ServletException {
        try {
            return (T)((Filter)aClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.log.error("Could not initialize filter class " + aClass.getName(), (Throwable)e);
            throw new ServletException();
        }
    }

    public FilterRegistration getFilterRegistration(String s) {
        if (!this.filters.containsKey(s)) {
            return null;
        }
        return this.filters.get(s).getRegistration();
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        LinkedHashMap<String, FilterHolder.Registration> registrations = new LinkedHashMap<String, FilterHolder.Registration>();
        for (Map.Entry<String, FilterHolder> entry : this.filters.entrySet()) {
            registrations.put(entry.getKey(), entry.getValue().getRegistration());
        }
        return registrations;
    }

    Map<String, FilterHolder> getFilterHolders() {
        return this.filters;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return null;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> set) {
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return null;
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return null;
    }

    public void addListener(String s) {
    }

    public <T extends EventListener> void addListener(T t) {
    }

    public void addListener(Class<? extends EventListener> aClass) {
    }

    public <T extends EventListener> T createListener(Class<T> aClass) throws ServletException {
        return null;
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public void declareRoles(String ... strings) {
    }

    public String getVirtualServerName() {
        return null;
    }
}

