/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.LogFormatter;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.serverless.proxy.model.AwsProxyRequestContext;
import com.amazonaws.serverless.proxy.model.HttpApiV2ProxyRequestContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.SecurityContext;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Locale;

public class ApacheCombinedServletLogFormatter<ContainerRequestType extends HttpServletRequest, ContainerResponseType extends HttpServletResponse>
implements LogFormatter<ContainerRequestType, ContainerResponseType> {
    private final DateTimeFormatter dateFormat;
    private final Clock clock;

    public ApacheCombinedServletLogFormatter() {
        this(Clock.systemDefaultZone());
    }

    ApacheCombinedServletLogFormatter(Clock clock) {
        this.clock = clock;
        this.dateFormat = new DateTimeFormatterBuilder().parseCaseInsensitive().appendLiteral("[").appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral("/").appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral("/").appendValue(ChronoField.YEAR, 4).appendLiteral(":").appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(":").appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(":").appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendOffset("+HHMM", "Z").optionalEnd().appendLiteral("]").toFormatter();
    }

    @Override
    @SuppressFBWarnings(value={"SERVLET_HEADER_REFERER", "SERVLET_HEADER_USER_AGENT"})
    public String format(ContainerRequestType servletRequest, ContainerResponseType servletResponse, SecurityContext ctx) {
        StringBuilder logLineBuilder = new StringBuilder();
        AwsProxyRequestContext gatewayContext = (AwsProxyRequestContext)servletRequest.getAttribute("com.amazonaws.apigateway.request.context");
        HttpApiV2ProxyRequestContext httpApiContext = (HttpApiV2ProxyRequestContext)servletRequest.getAttribute("com.amazonaws.httpapi.request.context");
        logLineBuilder.append(servletRequest.getRemoteAddr());
        logLineBuilder.append(" ");
        if (servletRequest.getUserPrincipal() != null) {
            logLineBuilder.append(servletRequest.getUserPrincipal().getName());
        } else {
            logLineBuilder.append("-");
        }
        if (gatewayContext != null && gatewayContext.getIdentity() != null && gatewayContext.getIdentity().getUserArn() != null) {
            logLineBuilder.append(gatewayContext.getIdentity().getUserArn());
        } else {
            logLineBuilder.append("-");
        }
        logLineBuilder.append(" ");
        if (servletRequest.getUserPrincipal() != null) {
            logLineBuilder.append(servletRequest.getUserPrincipal().getName());
        }
        logLineBuilder.append(" ");
        long timeEpoch = ZonedDateTime.now(this.clock).toEpochSecond();
        if (gatewayContext != null && gatewayContext.getRequestTimeEpoch() > 0L) {
            timeEpoch = gatewayContext.getRequestTimeEpoch() / 1000L;
        } else if (httpApiContext != null && httpApiContext.getTimeEpoch() > 0L) {
            timeEpoch = httpApiContext.getTimeEpoch() / 1000L;
        }
        logLineBuilder.append(this.dateFormat.format(ZonedDateTime.of(LocalDateTime.ofEpochSecond(timeEpoch, 0, ZoneOffset.UTC), this.clock.getZone())));
        logLineBuilder.append(" ");
        logLineBuilder.append("\"");
        logLineBuilder.append(servletRequest.getMethod().toUpperCase(Locale.ENGLISH));
        logLineBuilder.append(" ");
        logLineBuilder.append(servletRequest.getRequestURI());
        logLineBuilder.append(" ");
        logLineBuilder.append(servletRequest.getProtocol());
        logLineBuilder.append("\" ");
        logLineBuilder.append(servletResponse.getStatus());
        logLineBuilder.append(" ");
        if (servletResponse instanceof AwsHttpServletResponse) {
            AwsHttpServletResponse awsResponse = (AwsHttpServletResponse)servletResponse;
            if (awsResponse.getAwsResponseBodyBytes().length > 0) {
                logLineBuilder.append(awsResponse.getAwsResponseBodyBytes().length);
            } else {
                logLineBuilder.append("-");
            }
        } else {
            logLineBuilder.append("-");
        }
        logLineBuilder.append(" ");
        logLineBuilder.append("\"");
        if (servletRequest.getHeader("referer") != null) {
            logLineBuilder.append(servletRequest.getHeader("referer"));
        } else {
            logLineBuilder.append("-");
        }
        logLineBuilder.append("\" ");
        logLineBuilder.append("\"");
        if (servletRequest.getHeader("user-agent") != null) {
            logLineBuilder.append(servletRequest.getHeader("user-agent"));
        } else {
            logLineBuilder.append("-");
        }
        logLineBuilder.append("\" ");
        logLineBuilder.append("combined");
        return logLineBuilder.toString();
    }
}

