/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.proxy.InitializationTypeHelper;
import com.amazonaws.serverless.proxy.InitializationWrapper;
import com.amazonaws.serverless.proxy.internal.InitializableLambdaContainerHandler;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.management.ManagementFactory;
import java.time.Instant;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncInitializationWrapper
extends InitializationWrapper {
    private static final int DEFAULT_INIT_GRACE_TIME_MS = 150;
    private static final String INIT_GRACE_TIME_ENVIRONMENT_VARIABLE_NAME = "AWS_SERVERLESS_JAVA_CONTAINER_INIT_GRACE_TIME";
    private static final int INIT_GRACE_TIME_MS = Integer.parseInt(System.getenv().getOrDefault("AWS_SERVERLESS_JAVA_CONTAINER_INIT_GRACE_TIME", Integer.toString(150)));
    private static final int LAMBDA_MAX_INIT_TIME_MS = 10000;
    private CountDownLatch initializationLatch;
    private final long actualStartTime;
    private final Logger log = LoggerFactory.getLogger(AsyncInitializationWrapper.class);

    public AsyncInitializationWrapper(long startTime) {
        this.actualStartTime = startTime;
    }

    public AsyncInitializationWrapper() {
        this.actualStartTime = ManagementFactory.getRuntimeMXBean().getStartTime();
    }

    @Override
    public void start(InitializableLambdaContainerHandler handler) throws ContainerInitializationException {
        if (InitializationTypeHelper.isAsyncInitializationDisabled()) {
            this.log.info("Async init disabled due to \"{}\" initialization", (Object)InitializationTypeHelper.getInitializationType());
            super.start(handler);
            return;
        }
        this.initializationLatch = new CountDownLatch(1);
        AsyncInitializer initializer = new AsyncInitializer(this.initializationLatch, handler);
        Thread initThread = new Thread(initializer);
        initThread.start();
        try {
            long curTime = Instant.now().toEpochMilli();
            long awaitTime = this.actualStartTime + 10000L - curTime - (long)INIT_GRACE_TIME_MS;
            this.log.info("Async initialization will wait for {}ms (init grace time is configured to {})", (Object)awaitTime, (Object)INIT_GRACE_TIME_MS);
            if (!this.initializationLatch.await(awaitTime, TimeUnit.MILLISECONDS)) {
                this.log.info("Initialization took longer than 10000, setting new CountDownLatch and continuing in event handler");
                this.initializationLatch = new CountDownLatch(1);
                initializer.replaceLatch(this.initializationLatch);
            }
        }
        catch (InterruptedException e) {
            throw new ContainerInitializationException("Container initialization interrupted", e);
        }
    }

    public long getActualStartTimeMs() {
        return this.actualStartTime;
    }

    @Override
    public CountDownLatch getInitializationLatch() {
        if (InitializationTypeHelper.isAsyncInitializationDisabled()) {
            return super.getInitializationLatch();
        }
        return this.initializationLatch;
    }

    private static class AsyncInitializer
    implements Runnable {
        private final InitializableLambdaContainerHandler handler;
        private CountDownLatch initLatch;
        private final Logger log = LoggerFactory.getLogger(AsyncInitializationWrapper.class);

        AsyncInitializer(CountDownLatch latch, InitializableLambdaContainerHandler h) {
            this.initLatch = latch;
            this.handler = h;
        }

        synchronized void replaceLatch(CountDownLatch newLatch) {
            this.initLatch = newLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressFBWarnings(value={"DM_EXIT"})
        public void run() {
            this.log.info("Starting async initializer");
            try {
                this.handler.initialize();
            }
            catch (ContainerInitializationException e) {
                this.log.error("Failed to initialize container handler", (Throwable)e);
                System.exit(1);
            }
            AsyncInitializer asyncInitializer = this;
            synchronized (asyncInitializer) {
                this.initLatch.countDown();
            }
        }
    }
}

