/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.model;

import com.amazonaws.serverless.proxy.model.Headers;
import com.amazonaws.serverless.proxy.model.MultiValuedTreeMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MultiValuedTreeMapTest {
    @Test
    void add_sameNameCaseSensitive_expectBothValues() {
        MultiValuedTreeMap map = new MultiValuedTreeMap();
        map.add((Object)"Test", (Object)"test");
        map.add((Object)"Test", (Object)"test2");
        Assertions.assertNotNull((Object)map.get((Object)"Test"));
        Assertions.assertEquals((int)2, (int)map.get((Object)"Test").size());
        Assertions.assertEquals((Object)"test", (Object)map.getFirst((Object)"Test"));
        Assertions.assertEquals((Object)"test2", map.get((Object)"Test").get(1));
        Assertions.assertNull((Object)map.get((Object)"test"));
        map.add((Object)"test", (Object)"test");
        Assertions.assertNotNull((Object)map.get((Object)"test"));
        Assertions.assertEquals((int)1, (int)map.get((Object)"test").size());
    }

    @Test
    void add_sameNameCaseInsensitive_expectOneValue() {
        Headers map = new Headers();
        map.add((Object)"Test", (Object)"test");
        Assertions.assertNotNull((Object)map.get((Object)"Test"));
        Assertions.assertNotNull((Object)map.get((Object)"test"));
        Assertions.assertEquals((int)1, (int)map.get((Object)"Test").size());
        map.add((Object)"test", (Object)"test2");
        Assertions.assertNotNull((Object)map.get((Object)"Test"));
        Assertions.assertEquals((int)2, (int)map.get((Object)"Test").size());
    }

    @Test
    void addFirst_sameNameKey_ExpectFirstReplaced() {
        MultiValuedTreeMap map = new MultiValuedTreeMap();
        map.add((Object)"Test", (Object)"test1");
        map.add((Object)"Test", (Object)"test2");
        Assertions.assertNotNull((Object)map.get((Object)"Test"));
        Assertions.assertEquals((int)2, (int)map.get((Object)"Test").size());
        Assertions.assertEquals((Object)"test1", (Object)map.getFirst((Object)"Test"));
        map.addFirst((Object)"Test", (Object)"test3");
        Assertions.assertEquals((int)3, (int)map.get((Object)"Test").size());
        Assertions.assertEquals((Object)"test3", (Object)map.getFirst((Object)"Test"));
    }
}

