/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.testutils;

import com.amazonaws.serverless.proxy.internal.testutils.AwsProxyRequestBuilder;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.MultiValuedTreeMap;
import java.io.IOException;
import java.net.URLEncoder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AwsProxyRequestBuilderTest {
    private static final String TEST_KEY = "testkey";
    private static final String TEST_VALUE = "testvalue";
    private static final String TEST_KEY_FOR_ENCODING = "test@key 1";
    private static final String TEST_VALUE_FOR_ENCODING = "test value!!";

    void baseConstructorAsserts(AwsProxyRequest request) {
        Assertions.assertEquals((int)0, (int)request.getMultiValueHeaders().size());
        Assertions.assertEquals((int)0, (int)request.getHeaders().size());
        Assertions.assertEquals((int)0, (int)request.getMultiValueQueryStringParameters().size());
        Assertions.assertNotNull((Object)request.getRequestContext());
        Assertions.assertNotNull((Object)request.getRequestContext().getRequestId());
        Assertions.assertNotNull((Object)request.getRequestContext().getExtendedRequestId());
        Assertions.assertEquals((Object)"test", (Object)request.getRequestContext().getStage());
        Assertions.assertEquals((Object)"HTTP/1.1", (Object)request.getRequestContext().getProtocol());
        Assertions.assertNotNull((Object)request.getRequestContext().getRequestTimeEpoch());
        Assertions.assertNotNull((Object)request.getRequestContext().getIdentity());
        Assertions.assertEquals((Object)"127.0.0.1", (Object)request.getRequestContext().getIdentity().getSourceIp());
    }

    @Test
    void constructor_path_httpMethod() {
        AwsProxyRequestBuilder builder = new AwsProxyRequestBuilder("/path", "GET");
        AwsProxyRequest request = builder.build();
        Assertions.assertEquals((Object)"/path", (Object)request.getPath());
        Assertions.assertEquals((Object)"GET", (Object)request.getHttpMethod());
        this.baseConstructorAsserts(request);
    }

    @Test
    void constructor_path_nullHttpMethod() {
        AwsProxyRequestBuilder builder = new AwsProxyRequestBuilder("/path");
        AwsProxyRequest request = builder.build();
        Assertions.assertNull((Object)request.getHttpMethod());
        Assertions.assertEquals((Object)"/path", (Object)request.getPath());
        this.baseConstructorAsserts(request);
    }

    @Test
    void constructor_nullPath_nullHttpMethod() {
        AwsProxyRequestBuilder builder = new AwsProxyRequestBuilder();
        AwsProxyRequest request = builder.build();
        Assertions.assertNull((Object)request.getHttpMethod());
        Assertions.assertNull((Object)request.getPath());
        this.baseConstructorAsserts(request);
    }

    @Test
    void form_key_value() {
        AwsProxyRequestBuilder builder = new AwsProxyRequestBuilder("/path", "POST");
        builder.form(TEST_KEY, TEST_VALUE);
        AwsProxyRequest request = builder.build();
        Assertions.assertEquals((int)1, (int)request.getMultiValueHeaders().get((Object)"Content-Type").size());
        Assertions.assertEquals((Object)"application/x-www-form-urlencoded", (Object)request.getMultiValueHeaders().getFirst((Object)"Content-Type"));
        Assertions.assertNull((Object)request.getHeaders().get((Object)"Content-Type"));
        Assertions.assertNotNull((Object)request.getBody());
        Assertions.assertEquals((Object)"testkey=testvalue", (Object)request.getBody());
    }

    @Test
    void form_key_nullKey_nullValue() {
        AwsProxyRequestBuilder builder = new AwsProxyRequestBuilder("/path", "POST");
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.form(null, TEST_VALUE));
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.form(TEST_KEY, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.form(null, null));
    }

    @Test
    void form_keyEncoded_valueEncoded() throws IOException {
        AwsProxyRequestBuilder builder = new AwsProxyRequestBuilder("/path", "POST");
        builder.form(TEST_KEY_FOR_ENCODING, TEST_VALUE_FOR_ENCODING);
        AwsProxyRequest request = builder.build();
        Assertions.assertEquals((int)1, (int)request.getMultiValueHeaders().get((Object)"Content-Type").size());
        Assertions.assertEquals((Object)"application/x-www-form-urlencoded", (Object)request.getMultiValueHeaders().getFirst((Object)"Content-Type"));
        Assertions.assertNull((Object)request.getHeaders().get((Object)"Content-Type"));
        Assertions.assertNotNull((Object)request.getBody());
        String expected = URLEncoder.encode(TEST_KEY_FOR_ENCODING, "UTF-8") + "=" + URLEncoder.encode(TEST_VALUE_FOR_ENCODING, "UTF-8");
        Assertions.assertEquals((Object)expected, (Object)request.getBody());
    }

    @Test
    void queryString_key_value() {
        AwsProxyRequestBuilder builder = new AwsProxyRequestBuilder("/path", "POST");
        builder.queryString(TEST_KEY, TEST_VALUE);
        AwsProxyRequest request = builder.build();
        Assertions.assertNull((Object)request.getQueryStringParameters());
        Assertions.assertEquals((int)1, (int)request.getMultiValueQueryStringParameters().size());
        Assertions.assertEquals((Object)TEST_KEY, request.getMultiValueQueryStringParameters().keySet().iterator().next());
        Assertions.assertEquals((Object)TEST_VALUE, request.getMultiValueQueryStringParameters().get((Object)TEST_KEY).get(0));
        Assertions.assertEquals((Object)TEST_VALUE, (Object)request.getMultiValueQueryStringParameters().getFirst((Object)TEST_KEY));
    }

    @Test
    void queryString_keyNotEncoded_valueNotEncoded() {
        AwsProxyRequestBuilder builder = new AwsProxyRequestBuilder("/path", "POST");
        builder.queryString(TEST_KEY_FOR_ENCODING, TEST_VALUE_FOR_ENCODING);
        AwsProxyRequest request = builder.build();
        Assertions.assertNull((Object)request.getQueryStringParameters());
        Assertions.assertEquals((int)1, (int)request.getMultiValueQueryStringParameters().size());
        Assertions.assertEquals((Object)TEST_KEY_FOR_ENCODING, request.getMultiValueQueryStringParameters().keySet().iterator().next());
        Assertions.assertEquals((Object)TEST_VALUE_FOR_ENCODING, request.getMultiValueQueryStringParameters().get((Object)TEST_KEY_FOR_ENCODING).get(0));
        Assertions.assertEquals((Object)TEST_VALUE_FOR_ENCODING, (Object)request.getMultiValueQueryStringParameters().getFirst((Object)TEST_KEY_FOR_ENCODING));
    }

    @Test
    void queryString_alb_key_value() {
        AwsProxyRequestBuilder builder = new AwsProxyRequestBuilder("/path", "POST");
        builder.queryString(TEST_KEY, TEST_VALUE);
        AwsProxyRequest request = builder.alb().build();
        Assertions.assertNull((Object)request.getQueryStringParameters());
        Assertions.assertEquals((int)1, (int)request.getMultiValueQueryStringParameters().size());
        Assertions.assertEquals((Object)TEST_KEY, request.getMultiValueQueryStringParameters().keySet().iterator().next());
        Assertions.assertEquals((Object)TEST_VALUE, request.getMultiValueQueryStringParameters().get((Object)TEST_KEY).get(0));
        Assertions.assertEquals((Object)TEST_VALUE, (Object)request.getMultiValueQueryStringParameters().getFirst((Object)TEST_KEY));
    }

    @Test
    void alb_keyEncoded_valueEncoded() throws IOException {
        AwsProxyRequestBuilder builder = new AwsProxyRequestBuilder("/path", "POST");
        MultiValuedTreeMap map = new MultiValuedTreeMap();
        map.add((Object)TEST_KEY_FOR_ENCODING, (Object)TEST_VALUE_FOR_ENCODING);
        builder.multiValueQueryString((MultiValuedTreeMap<String, String>)map);
        AwsProxyRequest request = builder.alb().build();
        String expectedKey = URLEncoder.encode(TEST_KEY_FOR_ENCODING, "UTF-8");
        String expectedValue = URLEncoder.encode(TEST_VALUE_FOR_ENCODING, "UTF-8");
        Assertions.assertEquals((int)1, (int)request.getMultiValueQueryStringParameters().size());
        Assertions.assertEquals((Object)expectedKey, request.getMultiValueQueryStringParameters().keySet().iterator().next());
        Assertions.assertEquals((Object)expectedValue, request.getMultiValueQueryStringParameters().get((Object)expectedKey).get(0));
        Assertions.assertEquals((Object)expectedValue, (Object)request.getMultiValueQueryStringParameters().getFirst((Object)expectedKey));
        Assertions.assertEquals((Object)expectedKey, request.getMultiValueQueryStringParameters().keySet().iterator().next());
        Assertions.assertEquals((Object)expectedValue, request.getMultiValueQueryStringParameters().get((Object)expectedKey).get(0));
        Assertions.assertEquals((Object)expectedValue, (Object)request.getMultiValueQueryStringParameters().getFirst((Object)expectedKey));
    }
}

