/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.proxy.AwsProxyExceptionHandler;
import com.amazonaws.serverless.proxy.AwsProxySecurityContextWriter;
import com.amazonaws.serverless.proxy.ExceptionHandler;
import com.amazonaws.serverless.proxy.RequestReader;
import com.amazonaws.serverless.proxy.ResponseWriter;
import com.amazonaws.serverless.proxy.SecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.serverless.proxy.internal.servlet.AwsLambdaServletContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequestReader;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletResponseWriter;
import com.amazonaws.serverless.proxy.internal.servlet.ServletLambdaContainerHandlerBuilder;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.services.lambda.runtime.Context;
import jakarta.servlet.http.HttpServletRequest;
import java.util.concurrent.CountDownLatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ServletLambdaContainerHandlerBuilderTest {
    @Test
    void validation_throwsException() {
        TestBuilder testBuilder = new TestBuilder();
        try {
            testBuilder.validate();
        }
        catch (ContainerInitializationException e) {
            return;
        }
        Assertions.fail((String)"Did not throw exception");
    }

    @Test
    void additionalMethod_testSetter() {
        TestBuilder test = ((TestBuilder)new TestBuilder().exceptionHandler((ExceptionHandler)new AwsProxyExceptionHandler())).name("test");
        Assertions.assertEquals((Object)"test", (Object)test.getName());
    }

    @Test
    void defaultProxy_setsValuesCorrectly() {
        TestBuilder test = ((TestBuilder)new TestBuilder().defaultProxy()).name("test");
        Assertions.assertNotNull((Object)test.initializationWrapper);
        Assertions.assertTrue((boolean)(test.exceptionHandler instanceof AwsProxyExceptionHandler));
        Assertions.assertTrue((boolean)(test.requestReader instanceof AwsProxyHttpServletRequestReader));
        Assertions.assertTrue((boolean)(test.responseWriter instanceof AwsProxyHttpServletResponseWriter));
        Assertions.assertTrue((boolean)(test.securityContextWriter instanceof AwsProxySecurityContextWriter));
        Assertions.assertSame(AwsProxyRequest.class, (Object)test.requestTypeClass);
        Assertions.assertSame(AwsProxyResponse.class, (Object)test.responseTypeClass);
        Assertions.assertEquals((Object)"test", (Object)test.name);
    }

    public static final class TestBuilder
    extends ServletLambdaContainerHandlerBuilder<AwsProxyRequest, AwsProxyResponse, HttpServletRequest, TestHandler, TestBuilder> {
        private String name;

        public TestBuilder name(String n) {
            this.name = n;
            return this;
        }

        public String getName() {
            return this.name;
        }

        protected TestBuilder self() {
            return this;
        }

        public TestHandler build() throws ContainerInitializationException {
            return null;
        }

        public TestHandler buildAndInitialize() throws ContainerInitializationException {
            return null;
        }
    }

    public static final class TestHandler
    extends AwsLambdaServletContainerHandler<AwsProxyRequest, AwsProxyResponse, HttpServletRequest, AwsHttpServletResponse> {
        public TestHandler() {
            super(AwsProxyRequest.class, AwsProxyResponse.class, (RequestReader)new AwsProxyHttpServletRequestReader(), (ResponseWriter)new AwsProxyHttpServletResponseWriter(), (SecurityContextWriter)new AwsProxySecurityContextWriter(), (ExceptionHandler)new AwsProxyExceptionHandler());
        }

        protected AwsHttpServletResponse getContainerResponse(HttpServletRequest request, CountDownLatch latch) {
            return null;
        }

        protected void handleRequest(HttpServletRequest containerRequest, AwsHttpServletResponse containerResponse, Context lambdaContext) throws Exception {
        }

        public void initialize() throws ContainerInitializationException {
        }
    }
}

