/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletRequestWrapper;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletContext;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletRegistration;
import com.amazonaws.serverless.proxy.internal.servlet.filters.UrlPathValidator;
import com.amazonaws.serverless.proxy.internal.testutils.AwsProxyRequestBuilder;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class AwsServletContextTest {
    private static String TMP_DIR = System.getProperty("java.io.tmpdir");
    private static final AwsServletContext STATIC_CTX = new AwsServletContext(null);

    @BeforeAll
    public static void setUp() {
        LambdaContainerHandler.getContainerConfig().addValidFilePath("/private/var/task");
        File tmpFile = new File(TMP_DIR);
        try {
            LambdaContainerHandler.getContainerConfig().addValidFilePath(tmpFile.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            Assertions.fail((String)"Could not add tmp dir to valid paths");
        }
        LambdaContainerHandler.getContainerConfig().addValidFilePath("C:\\MyTestFolder");
    }

    @Test
    @Disabled
    void getMimeType_disabledPath_expectException() {
        AwsServletContext ctx = new AwsServletContext(null);
        try {
            Assertions.assertNull((Object)ctx.getMimeType("/usr/local/lib/nothing"));
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("File path not allowed"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)"Unrecognized exception");
        }
    }

    @Test
    void getMimeType_nonExistentFileInTaskPath_expectNull() {
        AwsServletContext ctx = new AwsServletContext(null);
        Assertions.assertNull((Object)ctx.getMimeType("/var/task/nothing"));
    }

    @Test
    void getMimeType_mimeTypeOfCorrectFile_expectMime() {
        String tmpFilePath = TMP_DIR + "test_text.txt";
        AwsServletContext ctx = new AwsServletContext(null);
        String mimeType = ctx.getMimeType(tmpFilePath);
        Assertions.assertEquals((Object)"text/plain", (Object)mimeType);
        mimeType = ctx.getMimeType("file://" + tmpFilePath);
        Assertions.assertEquals((Object)"text/plain", (Object)mimeType);
    }

    @Test
    void getMimeType_mimeTypeOfJavascript_expectApplicationJavascript() {
        String tmpFilePath = TMP_DIR + "some.js";
        AwsServletContext ctx = new AwsServletContext(null);
        String mimeType = ctx.getMimeType(tmpFilePath);
        Assertions.assertEquals((Object)"text/javascript", (Object)mimeType);
    }

    @Test
    void getMimeType_unknownExtension_expectNull() {
        AwsServletContext ctx = new AwsServletContext(null);
        String mimeType = ctx.getMimeType("myfile.unkext");
        Assertions.assertNull((Object)mimeType);
    }

    @Test
    void addFilter_nonExistentFilterClass_expectException() {
        AwsServletContext ctx = new AwsServletContext(null);
        String filterClass = "com.amazonaws.serverless.TestingFilterClassNonExistent";
        try {
            ctx.addFilter("filter", filterClass);
        }
        catch (IllegalStateException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Filter class " + filterClass));
            return;
        }
        Assertions.fail((String)"Expected IllegalStateException");
    }

    @Test
    void addFilter_doesNotImplementFilter_expectException() {
        AwsServletContext ctx = new AwsServletContext(null);
        try {
            ctx.addFilter("filter", this.getClass().getName());
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith(this.getClass().getName() + " does not implement Filter"));
            return;
        }
        Assertions.fail((String)"Expected IllegalArgumentException");
    }

    @Test
    void addFilter_validFilter_expectSuccess() {
        AwsServletContext ctx = new AwsServletContext(null);
        FilterRegistration.Dynamic reg = ctx.addFilter("filter", UrlPathValidator.class.getName());
        Assertions.assertNotNull((Object)reg);
        Assertions.assertNotNull((Object)ctx.getFilterHolders());
        Assertions.assertEquals((int)1, (int)ctx.getFilterHolders().size());
        Assertions.assertEquals((Object)reg, (Object)ctx.getFilterRegistration("UrlPathValidator"));
        Assertions.assertNotNull((Object)ctx.getFilterRegistrations());
        Assertions.assertEquals((int)1, (int)ctx.getFilterRegistrations().size());
    }

    @Test
    void addFilter_validFilter_expectSuccessWithCustomFilterName() {
        AwsServletContext ctx = new AwsServletContext(null);
        FilterRegistration.Dynamic reg = ctx.addFilter("filter", TestFilter.class.getName());
        Assertions.assertNotNull((Object)reg);
        Assertions.assertNotNull((Object)ctx.getFilterHolders());
        Assertions.assertEquals((int)1, (int)ctx.getFilterHolders().size());
        Assertions.assertEquals((Object)reg, (Object)ctx.getFilterRegistration("filter"));
        Assertions.assertNotNull((Object)ctx.getFilterRegistrations());
        Assertions.assertEquals((int)1, (int)ctx.getFilterRegistrations().size());
    }

    @Test
    void getContextPath_expectEmpty() {
        Assertions.assertEquals((Object)"", (Object)STATIC_CTX.getContextPath());
    }

    @Test
    void getContext_returnsSameContext() {
        Assertions.assertEquals((Object)STATIC_CTX, (Object)STATIC_CTX.getContext("1"));
        Assertions.assertEquals((Object)STATIC_CTX, (Object)STATIC_CTX.getContext("2"));
    }

    @Test
    void getVersions_expectStaticVersions() {
        Assertions.assertEquals((int)6, (int)STATIC_CTX.getMajorVersion());
        Assertions.assertEquals((int)0, (int)STATIC_CTX.getMinorVersion());
        Assertions.assertEquals((int)6, (int)STATIC_CTX.getEffectiveMajorVersion());
        Assertions.assertEquals((int)0, (int)STATIC_CTX.getEffectiveMinorVersion());
    }

    @Test
    void startAsync_expectPopulatedAsyncContext() {
        AwsProxyHttpServletRequest req = new AwsProxyHttpServletRequest(new AwsProxyRequestBuilder("/", "GET").build(), null, null);
        Assertions.assertNotNull((Object)req);
        AsyncContext ctx = req.startAsync();
        Assertions.assertNotNull((Object)ctx);
        Assertions.assertEquals((Object)req, (Object)ctx.getRequest());
    }

    @Test
    void startAsyncWithNewRequest_expectPopulatedAsyncContext() {
        AwsProxyHttpServletRequest req = new AwsProxyHttpServletRequest(new AwsProxyRequestBuilder("/", "GET").build(), null, null);
        Assertions.assertNotNull((Object)req);
        AwsHttpServletRequestWrapper newReq = new AwsHttpServletRequestWrapper((HttpServletRequest)req, "/new");
        AwsHttpServletResponse newResp = new AwsHttpServletResponse((HttpServletRequest)newReq, new CountDownLatch(1));
        AsyncContext ctx = req.startAsync((ServletRequest)newReq, (ServletResponse)newResp);
        Assertions.assertNotNull((Object)ctx);
        Assertions.assertNotNull((Object)req.getAsyncContext());
        Assertions.assertNotNull((Object)newReq.getAsyncContext());
        Assertions.assertEquals((Object)newReq, (Object)ctx.getRequest());
        Assertions.assertEquals((Object)newResp, (Object)ctx.getResponse());
    }

    @Test
    void unsupportedOperations_expectExceptions() {
        int exCount = 0;
        try {
            STATIC_CTX.getResourcePaths("1");
        }
        catch (UnsupportedOperationException e) {
            ++exCount;
        }
        Assertions.assertEquals((int)1, (int)exCount);
        Assertions.assertNull((Object)STATIC_CTX.getServletRegistration("1"));
    }

    @Test
    void servletMappings_expectCorrectServlet() {
        AwsServletContext ctx = new AwsServletContext(null);
        TestServlet srv1 = new TestServlet("srv1");
        TestServlet srv2 = new TestServlet("srv2");
        ServletRegistration.Dynamic reg1 = ctx.addServlet("srv1", (Servlet)srv1);
        ServletRegistration.Dynamic reg2 = ctx.addServlet("srv2", (Servlet)srv2);
        reg1.addMapping(new String[]{"/srv1"});
        reg2.addMapping(new String[]{"/srv2"});
        Assertions.assertEquals((Object)srv1, (Object)ctx.getServletForPath("/srv1/hello"));
        Assertions.assertEquals((Object)srv1, (Object)ctx.getServletForPath("/srv1/hello/test"));
        Assertions.assertEquals((Object)srv2, (Object)ctx.getServletForPath("/srv2"));
        Assertions.assertEquals((Object)srv2, (Object)ctx.getServletForPath("/srv2/hello"));
        Assertions.assertNull((Object)ctx.getServletForPath("/srv3"));
        Assertions.assertNull((Object)ctx.getServletForPath(""));
        reg2.addMapping(new String[]{"/"});
        Assertions.assertEquals((Object)srv2, (Object)ctx.getServletForPath("/srv3"));
    }

    @Test
    void addServlet_callsDefaultConstructor() throws ServletException {
        AwsServletContext ctx = new AwsServletContext(null);
        ctx.addServlet("srv1", TestServlet.class);
        Assertions.assertNotNull((Object)((AwsServletRegistration)ctx.getServletRegistration("srv1")).getServlet());
        Assertions.assertEquals((Object)"", (Object)((TestServlet)((AwsServletRegistration)ctx.getServletRegistration("srv1")).getServlet()).getId());
    }

    @Test
    void getNamedDispatcher_returnsDispatcher() {
        AwsServletContext ctx = new AwsServletContext(null);
        Assertions.assertNotNull((Object)ctx.getNamedDispatcher("/hello"));
    }

    public static class TestFilter
    implements Filter {
        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        }

        public void destroy() {
        }
    }

    public static class TestServlet
    implements Servlet {
        private String id;

        public TestServlet() {
            this("");
        }

        public TestServlet(String identifier) {
            this.id = identifier;
        }

        public void init(ServletConfig servletConfig) throws ServletException {
        }

        public ServletConfig getServletConfig() {
            return null;
        }

        public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        }

        public String getServletInfo() {
            return null;
        }

        public void destroy() {
        }

        public String getId() {
            return this.id;
        }
    }
}

