/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.exceptions.InvalidRequestEventException;
import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequestReader;
import com.amazonaws.serverless.proxy.internal.testutils.AwsProxyRequestBuilder;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import jakarta.servlet.http.HttpServletRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AwsProxyHttpServletRequestReaderTest {
    private AwsProxyHttpServletRequestReader reader = new AwsProxyHttpServletRequestReader();
    private static final String TEST_HEADER_KEY = "x-test";
    private static final String TEST_HEADER_VALUE = "header";
    private static final String ENCODED_REQUEST_PATH = "/foo/bar/Some%20Thing";
    private static final String DECODED_REQUEST_PATH = "/foo/bar/Some Thing";

    @Test
    void readRequest_validAwsProxy_populatedRequest() {
        AwsProxyRequest request = new AwsProxyRequestBuilder("/path", "GET").header(TEST_HEADER_KEY, TEST_HEADER_VALUE).build();
        try {
            HttpServletRequest servletRequest = this.reader.readRequest(request, null, null, ContainerConfig.defaultConfig());
            Assertions.assertNotNull((Object)servletRequest.getHeader(TEST_HEADER_KEY));
            Assertions.assertEquals((Object)TEST_HEADER_VALUE, (Object)servletRequest.getHeader(TEST_HEADER_KEY));
        }
        catch (InvalidRequestEventException e) {
            e.printStackTrace();
            Assertions.fail((String)"Could not read request");
        }
    }

    @Test
    void readRequest_urlDecode_expectDecodedPath() {
        AwsProxyRequest request = new AwsProxyRequestBuilder(ENCODED_REQUEST_PATH, "GET").build();
        try {
            HttpServletRequest servletRequest = this.reader.readRequest(request, null, null, ContainerConfig.defaultConfig());
            Assertions.assertNotNull((Object)servletRequest);
            Assertions.assertEquals((Object)DECODED_REQUEST_PATH, (Object)servletRequest.getPathInfo());
            Assertions.assertEquals((Object)ENCODED_REQUEST_PATH, (Object)servletRequest.getRequestURI());
        }
        catch (InvalidRequestEventException e) {
            e.printStackTrace();
            Assertions.fail((String)"Could not read request");
        }
    }

    @Test
    void readRequest_contentCharset_doesNotOverrideRequestCharset() {
        String requestCharset = "application/json; charset=UTF-8";
        AwsProxyRequest request = new AwsProxyRequestBuilder(ENCODED_REQUEST_PATH, "GET").header("Content-Type", requestCharset).build();
        try {
            HttpServletRequest servletRequest = this.reader.readRequest(request, null, null, ContainerConfig.defaultConfig());
            Assertions.assertNotNull((Object)servletRequest);
            Assertions.assertNotNull((Object)servletRequest.getHeader("Content-Type"));
            Assertions.assertEquals((Object)requestCharset, (Object)servletRequest.getHeader("Content-Type"));
            Assertions.assertEquals((Object)"UTF-8", (Object)servletRequest.getCharacterEncoding());
        }
        catch (InvalidRequestEventException e) {
            e.printStackTrace();
            Assertions.fail((String)"Could not read request");
        }
    }

    @Test
    void readRequest_contentCharset_setsDefaultCharsetWhenNotSpecified() {
        String requestCharset = "application/json";
        AwsProxyRequest request = new AwsProxyRequestBuilder(ENCODED_REQUEST_PATH, "GET").header("Content-Type", requestCharset).build();
        try {
            HttpServletRequest servletRequest = this.reader.readRequest(request, null, null, ContainerConfig.defaultConfig());
            Assertions.assertNotNull((Object)servletRequest);
            Assertions.assertNotNull((Object)servletRequest.getHeader("Content-Type"));
            String contentAndCharset = requestCharset + "; charset=" + LambdaContainerHandler.getContainerConfig().getDefaultContentCharset();
            Assertions.assertEquals((Object)contentAndCharset, (Object)servletRequest.getHeader("Content-Type"));
            Assertions.assertEquals((Object)LambdaContainerHandler.getContainerConfig().getDefaultContentCharset(), (Object)servletRequest.getCharacterEncoding());
        }
        catch (InvalidRequestEventException e) {
            e.printStackTrace();
            Assertions.fail((String)"Could not read request");
        }
    }

    @Test
    void readRequest_contentCharset_appendsCharsetToComplextContentType() {
        String contentType = "multipart/form-data; boundary=something";
        AwsProxyRequest request = new AwsProxyRequestBuilder(ENCODED_REQUEST_PATH, "GET").header("Content-Type", contentType).build();
        try {
            HttpServletRequest servletRequest = this.reader.readRequest(request, null, null, ContainerConfig.defaultConfig());
            Assertions.assertNotNull((Object)servletRequest);
            Assertions.assertNotNull((Object)servletRequest.getHeader("Content-Type"));
            String contentAndCharset = contentType + "; charset=" + LambdaContainerHandler.getContainerConfig().getDefaultContentCharset();
            Assertions.assertEquals((Object)contentAndCharset, (Object)servletRequest.getHeader("Content-Type"));
            Assertions.assertEquals((Object)LambdaContainerHandler.getContainerConfig().getDefaultContentCharset(), (Object)servletRequest.getCharacterEncoding());
        }
        catch (InvalidRequestEventException e) {
            e.printStackTrace();
            Assertions.fail((String)"Could not read request");
        }
    }

    @Test
    void readRequest_validEventEmptyPath_expectException() {
        try {
            AwsProxyRequest req = new AwsProxyRequestBuilder(null, "GET").build();
            HttpServletRequest servletReq = this.reader.readRequest(req, null, null, ContainerConfig.defaultConfig());
            Assertions.assertNotNull((Object)servletReq);
        }
        catch (InvalidRequestEventException e) {
            e.printStackTrace();
            Assertions.fail((String)"Could not read a request with a null path");
        }
    }

    @Test
    void readRequest_invalidEventEmptyMethod_expectException() {
        try {
            AwsProxyRequest req = new AwsProxyRequestBuilder("/path", null).build();
            this.reader.readRequest(req, null, null, ContainerConfig.defaultConfig());
            Assertions.fail((String)"Expected InvalidRequestEventException");
        }
        catch (InvalidRequestEventException e) {
            Assertions.assertEquals((Object)"The incoming event is not a valid request from Amazon API Gateway or an Application Load Balancer", (Object)e.getMessage());
        }
    }

    @Test
    void readRequest_invalidEventEmptyContext_expectException() {
        try {
            AwsProxyRequest req = new AwsProxyRequestBuilder("/path", "GET").build();
            req.setRequestContext(null);
            this.reader.readRequest(req, null, null, ContainerConfig.defaultConfig());
            Assertions.fail((String)"Expected InvalidRequestEventException");
        }
        catch (InvalidRequestEventException e) {
            Assertions.assertEquals((Object)"The incoming event is not a valid request from Amazon API Gateway or an Application Load Balancer", (Object)e.getMessage());
        }
    }

    @Test
    void readRequest_nullHeaders_expectSuccess() {
        AwsProxyRequest req = new AwsProxyRequestBuilder("/path", "GET").build();
        req.setMultiValueHeaders(null);
        try {
            HttpServletRequest servletReq = this.reader.readRequest(req, null, null, ContainerConfig.defaultConfig());
            String headerValue = servletReq.getHeader("Content-Type");
            Assertions.assertNull((Object)headerValue);
        }
        catch (InvalidRequestEventException e) {
            e.printStackTrace();
            Assertions.fail((String)"Failed to read request with null headers");
        }
    }

    @Test
    void readRequest_emptyHeaders_expectSuccess() {
        AwsProxyRequest req = new AwsProxyRequestBuilder("/path", "GET").build();
        try {
            HttpServletRequest servletReq = this.reader.readRequest(req, null, null, ContainerConfig.defaultConfig());
            String headerValue = servletReq.getHeader("Content-Type");
            Assertions.assertNull((Object)headerValue);
        }
        catch (InvalidRequestEventException e) {
            e.printStackTrace();
            Assertions.fail((String)"Failed to read request with null headers");
        }
    }
}

