/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.testutils.AwsProxyRequestBuilder;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AwsProxyHttpServletRequestFormTest {
    private static final String PART_KEY_1 = "test1";
    private static final String PART_VALUE_1 = "value1";
    private static final String PART_KEY_2 = "test2";
    private static final String PART_VALUE_2 = "value2";
    private static final String FILE_KEY = "file_upload_1";
    private static final String FILE_KEY_2 = "file_upload_2";
    private static final String FILE_NAME = "testImage.jpg";
    private static final String ENCODED_VALUE = "test123a%3D1%262@3";
    private static final HttpEntity MULTIPART_FORM_DATA = MultipartEntityBuilder.create().addTextBody("test1", "value1").addTextBody("test2", "value2").build();
    private static final int FILE_SIZE = 512;
    private static byte[] FILE_BYTES = new byte[512];
    private static byte[] FILE_BYTES_2 = new byte[512];
    private static final HttpEntity MULTIPART_BINARY_DATA;
    private static final HttpEntity MULTIPART_BINARY_DATA_2;
    private static final String ENCODED_FORM_ENTITY = "test1=test123a%3D1%262@3&test2=value2";

    @Test
    void postForm_getParam_getEncodedFullValue() {
        try {
            AwsProxyRequest proxyRequest = new AwsProxyRequestBuilder("/form", "POST").header("Content-Type", "application/x-www-form-urlencoded").body(ENCODED_FORM_ENTITY).build();
            AwsProxyHttpServletRequest request = new AwsProxyHttpServletRequest(proxyRequest, null, null);
            Assertions.assertNotNull((Object)request.getParts());
            Assertions.assertEquals((Object)"test123a=1&2@3", (Object)request.getParameter(PART_KEY_1));
        }
        catch (ServletException | IOException e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void postForm_getParts_parsing() {
        try {
            AwsProxyRequest proxyRequest = new AwsProxyRequestBuilder("/form", "POST").header("Content-Type", MULTIPART_FORM_DATA.getContentType()).body(IOUtils.toString((InputStream)MULTIPART_FORM_DATA.getContent(), (Charset)Charset.defaultCharset())).build();
            AwsProxyHttpServletRequest request = new AwsProxyHttpServletRequest(proxyRequest, null, null);
            Assertions.assertNotNull((Object)request.getParts());
            Assertions.assertEquals((int)2, (int)request.getParts().size());
            Assertions.assertEquals((Object)PART_VALUE_1, (Object)IOUtils.toString((InputStream)request.getPart(PART_KEY_1).getInputStream(), (Charset)Charset.defaultCharset()));
            Assertions.assertEquals((Object)PART_VALUE_2, (Object)IOUtils.toString((InputStream)request.getPart(PART_KEY_2).getInputStream(), (Charset)Charset.defaultCharset()));
        }
        catch (ServletException | IOException e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void multipart_getParts_binary() {
        try {
            AwsProxyRequest proxyRequest = new AwsProxyRequestBuilder("/form", "POST").header("Content-Type", MULTIPART_BINARY_DATA.getContentType()).header("Content-Length", MULTIPART_BINARY_DATA.getContentLength() + "").binaryBody(MULTIPART_BINARY_DATA.getContent()).build();
            AwsProxyHttpServletRequest request = new AwsProxyHttpServletRequest(proxyRequest, null, null);
            Assertions.assertNotNull((Object)request.getParts());
            Assertions.assertEquals((int)3, (int)request.getParts().size());
            Assertions.assertNotNull((Object)request.getPart(FILE_KEY));
            Assertions.assertEquals((long)512L, (long)request.getPart(FILE_KEY).getSize());
            Assertions.assertEquals((Object)FILE_KEY, (Object)request.getPart(FILE_KEY).getName());
            Assertions.assertEquals((Object)FILE_NAME, (Object)request.getPart(FILE_KEY).getSubmittedFileName());
            Assertions.assertEquals((Object)PART_VALUE_1, (Object)IOUtils.toString((InputStream)request.getPart(PART_KEY_1).getInputStream(), (Charset)Charset.defaultCharset()));
            Assertions.assertEquals((Object)PART_VALUE_2, (Object)IOUtils.toString((InputStream)request.getPart(PART_KEY_2).getInputStream(), (Charset)Charset.defaultCharset()));
        }
        catch (ServletException | IOException e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void multipart_getParts_returnsMultiplePartsWithSameFieldName() {
        try {
            AwsProxyRequest proxyRequest = new AwsProxyRequestBuilder("/form", "POST").header("Content-Type", MULTIPART_BINARY_DATA_2.getContentType()).header("Content-Length", MULTIPART_BINARY_DATA_2.getContentLength() + "").binaryBody(MULTIPART_BINARY_DATA_2.getContent()).build();
            AwsProxyHttpServletRequest request = new AwsProxyHttpServletRequest(proxyRequest, null, null);
            Assertions.assertNotNull((Object)request.getParts());
            Assertions.assertEquals((int)2, (int)request.getParts().size());
            Assertions.assertNotNull((Object)request.getPart(FILE_KEY));
            ArrayList partList = new ArrayList(request.getParts());
            Assertions.assertEquals((Object)((Part)partList.get(0)).getSubmittedFileName(), (Object)((Part)partList.get(1)).getSubmittedFileName());
            Assertions.assertEquals((Object)((Part)partList.get(0)).getName(), (Object)((Part)partList.get(1)).getName());
            Assertions.assertEquals((long)512L, (long)request.getPart(FILE_KEY).getSize());
            Assertions.assertEquals((Object)FILE_KEY, (Object)request.getPart(FILE_KEY).getName());
            Assertions.assertEquals((Object)FILE_NAME, (Object)request.getPart(FILE_KEY).getSubmittedFileName());
        }
        catch (ServletException | IOException e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void postForm_getParamsBase64Encoded_expectAllParams() {
        AwsProxyRequest proxyRequest = new AwsProxyRequestBuilder("/form", "POST").header("Content-Type", "application/x-www-form-urlencoded").build();
        proxyRequest.setBody(Base64.getEncoder().encodeToString(ENCODED_FORM_ENTITY.getBytes(Charset.defaultCharset())));
        proxyRequest.setIsBase64Encoded(true);
        AwsProxyHttpServletRequest request = new AwsProxyHttpServletRequest(proxyRequest, null, null);
        Map params = request.getParameterMap();
        Assertions.assertNotNull((Object)params);
        Assertions.assertEquals((int)2, (int)params.size());
        Assertions.assertTrue((boolean)params.containsKey(PART_KEY_1));
        Assertions.assertEquals((int)2, (int)Collections.list(request.getParameterNames()).size());
    }

    @Test
    void postForm_emptyParamPresent() {
        AwsProxyRequest proxyRequest = new AwsProxyRequestBuilder("/form", "POST").header("Content-Type", "application/x-www-form-urlencoded").build();
        String body = "test1=&test2=value2";
        proxyRequest.setBody(body);
        AwsProxyHttpServletRequest request = new AwsProxyHttpServletRequest(proxyRequest, null, null);
        Map params = request.getParameterMap();
        Assertions.assertNotNull((Object)params);
        Assertions.assertEquals((int)2, (int)params.size());
        Assertions.assertTrue((boolean)params.containsKey(PART_KEY_1));
        Assertions.assertEquals((int)2, (int)Collections.list(request.getParameterNames()).size());
    }

    static {
        new Random().nextBytes(FILE_BYTES);
        MULTIPART_BINARY_DATA = MultipartEntityBuilder.create().addTextBody(PART_KEY_1, PART_VALUE_1).addTextBody(PART_KEY_2, PART_VALUE_2).addBinaryBody(FILE_KEY, FILE_BYTES, ContentType.IMAGE_JPEG, FILE_NAME).build();
        MULTIPART_BINARY_DATA_2 = MultipartEntityBuilder.create().addBinaryBody(FILE_KEY, FILE_BYTES, ContentType.IMAGE_JPEG, FILE_NAME).addBinaryBody(FILE_KEY, FILE_BYTES_2, ContentType.IMAGE_JPEG, FILE_NAME).build();
    }
}

