/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.exceptions.InvalidRequestEventException;
import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpApiV2HttpServletRequestReader;
import com.amazonaws.serverless.proxy.internal.testutils.AwsProxyRequestBuilder;
import com.amazonaws.serverless.proxy.model.HttpApiV2ProxyRequest;
import com.amazonaws.serverless.proxy.model.HttpApiV2ProxyRequestContext;
import jakarta.servlet.http.HttpServletRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AwsHttpApiV2HttpServletRequestReaderTest {
    private AwsHttpApiV2HttpServletRequestReader reader = new AwsHttpApiV2HttpServletRequestReader();

    @Test
    void reflection_getRequestClass_returnsCorrectType() {
        Assertions.assertSame(HttpApiV2ProxyRequest.class, (Object)this.reader.getRequestClass());
    }

    @Test
    void baseRequest_read_populatesSuccessfully() {
        HttpApiV2ProxyRequest req = new AwsProxyRequestBuilder("/hello", "GET").referer("localhost").userAgent("Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/102.0.5005.61 Safari/537.36").queryString("param1", "value1").header("custom", "value").cookie("cookey", "cooval").apiId("test").toHttpApiV2Request();
        AwsHttpApiV2HttpServletRequestReader reader = new AwsHttpApiV2HttpServletRequestReader();
        try {
            HttpServletRequest servletRequest = reader.readRequest(req, null, null, LambdaContainerHandler.getContainerConfig());
            Assertions.assertEquals((Object)"/hello", (Object)servletRequest.getPathInfo());
            Assertions.assertEquals((Object)"value1", (Object)servletRequest.getParameter("param1"));
            Assertions.assertEquals((Object)"value", (Object)servletRequest.getHeader("CUSTOM"));
            Assertions.assertEquals((Object)"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/102.0.5005.61 Safari/537.36", (Object)servletRequest.getHeader("User-Agent"));
            Assertions.assertNotNull((Object)servletRequest.getCookies());
            Assertions.assertEquals((int)1, (int)servletRequest.getCookies().length);
            Assertions.assertEquals((Object)"cookey", (Object)servletRequest.getCookies()[0].getName());
            Assertions.assertEquals((Object)"cooval", (Object)servletRequest.getCookies()[0].getValue());
            Assertions.assertNotNull((Object)servletRequest.getAttribute("com.amazonaws.httpapi.request.context"));
            Assertions.assertEquals((Object)"test", (Object)((HttpApiV2ProxyRequestContext)servletRequest.getAttribute("com.amazonaws.httpapi.request.context")).getApiId());
        }
        catch (InvalidRequestEventException e) {
            e.printStackTrace();
            Assertions.fail((String)"Could not read request");
        }
    }
}

