/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.jaxrs;

import com.amazonaws.serverless.proxy.internal.jaxrs.AwsProxySecurityContext;
import com.amazonaws.serverless.proxy.internal.testutils.AwsProxyRequestBuilder;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import java.security.Principal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AwsProxySecurityContextTest {
    private static final String CLAIM_KEY = "custom:claim";
    private static final String CLAIM_VALUE = "customClaimant";
    private static final String COGNITO_IDENTITY_ID = "us-east-2:123123123123";
    private static final AwsProxyRequest REQUEST_NO_AUTH = new AwsProxyRequestBuilder("/hello", "GET").build();
    private static final AwsProxyRequest ALB_REQUEST_NO_AUTH = new AwsProxyRequestBuilder("/hello", "GET").alb().build();
    private static final AwsProxyRequest REQUEST_COGNITO_USER_POOL = new AwsProxyRequestBuilder("/hello", "GET").cognitoUserPool("us-east-2:123123123123").claim("custom:claim", "customClaimant").build();
    private static final AwsProxyRequest ALB_REQUEST_COGNITO_USER_POOL = new AwsProxyRequestBuilder("/hello", "GET").alb().header("x-amzn-oidc-accesstoken", "xxxxx").header("x-amzn-oidc-identity", "us-east-2:123123123123").build();

    @Test
    void localVars_constructor_nullValues() {
        AwsProxySecurityContext context = new AwsProxySecurityContext(null, null);
        Assertions.assertNull((Object)context.getEvent());
        Assertions.assertNull((Object)context.getLambdaContext());
    }

    @Test
    void localVars_constructor_ValidRequest() {
        AwsProxySecurityContext context = new AwsProxySecurityContext(null, REQUEST_NO_AUTH);
        Assertions.assertEquals((Object)REQUEST_NO_AUTH, (Object)context.getEvent());
        Assertions.assertNull((Object)context.getLambdaContext());
    }

    @Test
    void alb_noAuth_expectEmptyScheme() {
        AwsProxySecurityContext context = new AwsProxySecurityContext(null, ALB_REQUEST_NO_AUTH);
        Assertions.assertEquals((Object)ALB_REQUEST_NO_AUTH, (Object)context.getEvent());
        Assertions.assertNull((Object)context.getLambdaContext());
        Assertions.assertFalse((boolean)context.isSecure());
        Assertions.assertNull((Object)context.getAuthenticationScheme());
    }

    @Test
    void authScheme_getAuthenticationScheme_userPool() {
        AwsProxySecurityContext context = new AwsProxySecurityContext(null, REQUEST_COGNITO_USER_POOL);
        Assertions.assertNotNull((Object)context.getAuthenticationScheme());
        Assertions.assertEquals((Object)"COGNITO_USER_POOL", (Object)context.getAuthenticationScheme());
    }

    @Test
    void authScheme_getPrincipal_userPool() {
        AwsProxySecurityContext context = new AwsProxySecurityContext(null, REQUEST_COGNITO_USER_POOL);
        Assertions.assertEquals((Object)"COGNITO_USER_POOL", (Object)context.getAuthenticationScheme());
        Assertions.assertEquals((Object)COGNITO_IDENTITY_ID, (Object)context.getUserPrincipal().getName());
    }

    @Test
    void alb_cognitoAuth_expectCustomSchemeAndCorrectPrincipal() {
        AwsProxySecurityContext context = new AwsProxySecurityContext(null, ALB_REQUEST_COGNITO_USER_POOL);
        Assertions.assertTrue((boolean)context.isSecure());
        Assertions.assertEquals((Object)"CUSTOM_AUTHORIZER", (Object)context.getAuthenticationScheme());
        Assertions.assertEquals((Object)COGNITO_IDENTITY_ID, (Object)context.getUserPrincipal().getName());
    }

    @Test
    void userPool_getClaims_retrieveCustomClaim() {
        AwsProxySecurityContext context = new AwsProxySecurityContext(null, REQUEST_COGNITO_USER_POOL);
        Principal userPrincipal = context.getUserPrincipal();
        Assertions.assertNotNull((Object)userPrincipal.getName());
        Assertions.assertEquals((Object)COGNITO_IDENTITY_ID, (Object)userPrincipal.getName());
        Assertions.assertTrue((boolean)(userPrincipal instanceof AwsProxySecurityContext.CognitoUserPoolPrincipal));
        Assertions.assertNotNull((Object)((AwsProxySecurityContext.CognitoUserPoolPrincipal)userPrincipal).getClaims().getClaim(CLAIM_KEY));
        Assertions.assertEquals((Object)CLAIM_VALUE, (Object)((AwsProxySecurityContext.CognitoUserPoolPrincipal)userPrincipal).getClaims().getClaim(CLAIM_KEY));
    }
}

