/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy;

import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequestReader;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RequestReaderTest {
    private static final String ORDERS_URL = "/orders";
    private static final String BASE_PATH_MAPPING = "svc1";
    private static final AwsProxyHttpServletRequestReader requestReader = new AwsProxyHttpServletRequestReader();

    @Test
    void defaultConfig_doNotStripBasePath() {
        ContainerConfig config = ContainerConfig.defaultConfig();
        Assertions.assertFalse((boolean)config.isStripBasePath());
        Assertions.assertNull((Object)config.getServiceBasePath());
    }

    @Test
    void setServiceBasePath_addSlashes() {
        ContainerConfig config = new ContainerConfig();
        config.setServiceBasePath(BASE_PATH_MAPPING);
        Assertions.assertEquals((Object)"/svc1", (Object)config.getServiceBasePath());
        config.setServiceBasePath("svc1/");
        Assertions.assertEquals((Object)"/svc1", (Object)config.getServiceBasePath());
    }

    @Test
    void requestReader_stripBasePath() {
        ContainerConfig config = ContainerConfig.defaultConfig();
        String requestPath = "/svc1/orders";
        String finalPath = requestReader.stripBasePath(requestPath, config);
        Assertions.assertNotNull((Object)finalPath);
        Assertions.assertEquals((Object)requestPath, (Object)finalPath);
        config.setStripBasePath(true);
        config.setServiceBasePath(BASE_PATH_MAPPING);
        finalPath = requestReader.stripBasePath(requestPath, config);
        Assertions.assertNotNull((Object)finalPath);
        Assertions.assertEquals((Object)ORDERS_URL, (Object)finalPath);
        finalPath = requestReader.stripBasePath(ORDERS_URL, config);
        Assertions.assertNotNull((Object)finalPath);
        Assertions.assertEquals((Object)ORDERS_URL, (Object)finalPath);
    }

    @Test
    void requestReader_doubleBasePath() {
        ContainerConfig config = ContainerConfig.defaultConfig();
        config.setStripBasePath(true);
        config.setServiceBasePath(BASE_PATH_MAPPING);
        String finalPath = requestReader.stripBasePath("/svc1/svc1", config);
        Assertions.assertNotNull((Object)finalPath);
        Assertions.assertEquals((Object)"/svc1", (Object)finalPath);
        finalPath = requestReader.stripBasePath("/custom/svc1", config);
        Assertions.assertNotNull((Object)finalPath);
        Assertions.assertEquals((Object)"/custom/svc1", (Object)finalPath);
        finalPath = requestReader.stripBasePath(BASE_PATH_MAPPING, config);
        Assertions.assertNotNull((Object)finalPath);
        Assertions.assertEquals((Object)BASE_PATH_MAPPING, (Object)finalPath);
    }
}

