/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy;

import com.amazonaws.serverless.exceptions.InvalidRequestEventException;
import com.amazonaws.serverless.exceptions.InvalidResponseObjectException;
import com.amazonaws.serverless.proxy.AwsProxyExceptionHandler;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.model.ErrorModel;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.InternalServerErrorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class AwsProxyExceptionHandlerTest {
    private static final String INTERNAL_SERVER_ERROR_MESSAGE = "Internal server error";
    private static final String INVALID_REQUEST_MESSAGE = "Invalid request error";
    private static final String INVALID_RESPONSE_MESSAGE = "Invalid response error";
    private AwsProxyExceptionHandler exceptionHandler;
    private ObjectMapper objectMapper;

    @BeforeEach
    public void setUp() {
        this.exceptionHandler = new AwsProxyExceptionHandler();
        this.objectMapper = new ObjectMapper();
    }

    @Test
    void typedHandle_InvalidRequestEventException_500State() {
        AwsProxyResponse resp = this.exceptionHandler.handle((Throwable)new InvalidRequestEventException(INVALID_REQUEST_MESSAGE, null));
        Assertions.assertNotNull((Object)resp);
        Assertions.assertEquals((int)500, (int)resp.getStatusCode());
    }

    @Test
    void typedHandle_InvalidRequestEventException_responseString() throws JsonProcessingException {
        AwsProxyResponse resp = this.exceptionHandler.handle((Throwable)new InvalidRequestEventException(INVALID_REQUEST_MESSAGE, null));
        Assertions.assertNotNull((Object)resp);
        String body = this.objectMapper.writeValueAsString((Object)new ErrorModel(AwsProxyExceptionHandler.INTERNAL_SERVER_ERROR));
        Assertions.assertEquals((Object)body, (Object)resp.getBody());
    }

    @Test
    void typedHandle_InvalidRequestEventException_jsonContentTypeHeader() {
        AwsProxyResponse resp = this.exceptionHandler.handle((Throwable)new InvalidRequestEventException(INVALID_REQUEST_MESSAGE, null));
        Assertions.assertNotNull((Object)resp);
        Assertions.assertTrue((boolean)resp.getMultiValueHeaders().containsKey((Object)"Content-Type"));
        Assertions.assertEquals((Object)"application/json", (Object)resp.getMultiValueHeaders().getFirst((Object)"Content-Type"));
    }

    @Test
    void typedHandle_InvalidResponseObjectException_502State() {
        AwsProxyResponse resp = this.exceptionHandler.handle((Throwable)new InvalidResponseObjectException(INVALID_RESPONSE_MESSAGE, null));
        Assertions.assertNotNull((Object)resp);
        Assertions.assertEquals((int)502, (int)resp.getStatusCode());
    }

    @Test
    void typedHandle_InvalidResponseObjectException_responseString() throws JsonProcessingException {
        AwsProxyResponse resp = this.exceptionHandler.handle((Throwable)new InvalidResponseObjectException(INVALID_RESPONSE_MESSAGE, null));
        Assertions.assertNotNull((Object)resp);
        String body = this.objectMapper.writeValueAsString((Object)new ErrorModel(AwsProxyExceptionHandler.GATEWAY_TIMEOUT_ERROR));
        Assertions.assertEquals((Object)body, (Object)resp.getBody());
    }

    @Test
    void typedHandle_InvalidResponseObjectException_jsonContentTypeHeader() {
        AwsProxyResponse resp = this.exceptionHandler.handle((Throwable)new InvalidResponseObjectException(INVALID_RESPONSE_MESSAGE, null));
        Assertions.assertNotNull((Object)resp);
        Assertions.assertTrue((boolean)resp.getMultiValueHeaders().containsKey((Object)"Content-Type"));
        Assertions.assertEquals((Object)"application/json", (Object)resp.getMultiValueHeaders().getFirst((Object)"Content-Type"));
    }

    @Test
    void typedHandle_InternalServerErrorException_500State() {
        InternalServerErrorException mockInternalServerErrorException = (InternalServerErrorException)Mockito.mock(InternalServerErrorException.class);
        Mockito.when((Object)mockInternalServerErrorException.getMessage()).thenReturn((Object)INTERNAL_SERVER_ERROR_MESSAGE);
        AwsProxyResponse resp = this.exceptionHandler.handle((Throwable)mockInternalServerErrorException);
        Assertions.assertNotNull((Object)resp);
        Assertions.assertEquals((int)500, (int)resp.getStatusCode());
    }

    @Test
    void typedHandle_InternalServerErrorException_responseString() throws JsonProcessingException {
        InternalServerErrorException mockInternalServerErrorException = (InternalServerErrorException)Mockito.mock(InternalServerErrorException.class);
        Mockito.when((Object)mockInternalServerErrorException.getMessage()).thenReturn((Object)INTERNAL_SERVER_ERROR_MESSAGE);
        AwsProxyResponse resp = this.exceptionHandler.handle((Throwable)mockInternalServerErrorException);
        Assertions.assertNotNull((Object)resp);
        String body = this.objectMapper.writeValueAsString((Object)new ErrorModel(AwsProxyExceptionHandler.INTERNAL_SERVER_ERROR));
        Assertions.assertEquals((Object)body, (Object)resp.getBody());
    }

    @Test
    void typedHandle_InternalServerErrorException_jsonContentTypeHeader() {
        InternalServerErrorException mockInternalServerErrorException = (InternalServerErrorException)Mockito.mock(InternalServerErrorException.class);
        Mockito.when((Object)mockInternalServerErrorException.getMessage()).thenReturn((Object)INTERNAL_SERVER_ERROR_MESSAGE);
        AwsProxyResponse resp = this.exceptionHandler.handle((Throwable)mockInternalServerErrorException);
        Assertions.assertNotNull((Object)resp);
        Assertions.assertTrue((boolean)resp.getMultiValueHeaders().containsKey((Object)"Content-Type"));
        Assertions.assertEquals((Object)"application/json", (Object)resp.getMultiValueHeaders().getFirst((Object)"Content-Type"));
    }

    @Test
    void typedHandle_NullPointerException_responseObject() throws JsonProcessingException {
        AwsProxyResponse resp = this.exceptionHandler.handle((Throwable)new NullPointerException());
        Assertions.assertNotNull((Object)resp);
        Assertions.assertEquals((int)502, (int)resp.getStatusCode());
        Assertions.assertTrue((boolean)resp.getMultiValueHeaders().containsKey((Object)"Content-Type"));
        Assertions.assertEquals((Object)"application/json", (Object)resp.getMultiValueHeaders().getFirst((Object)"Content-Type"));
        String body = this.objectMapper.writeValueAsString((Object)new ErrorModel(AwsProxyExceptionHandler.GATEWAY_TIMEOUT_ERROR));
        Assertions.assertEquals((Object)body, (Object)resp.getBody());
    }

    @Test
    void streamHandle_InvalidRequestEventException_500State() throws IOException {
        ByteArrayOutputStream respStream = new ByteArrayOutputStream();
        this.exceptionHandler.handle((Throwable)new InvalidRequestEventException(INVALID_REQUEST_MESSAGE, null), (OutputStream)respStream);
        Assertions.assertNotNull((Object)respStream);
        Assertions.assertTrue((respStream.size() > 0 ? 1 : 0) != 0);
        AwsProxyResponse resp = (AwsProxyResponse)this.objectMapper.readValue((InputStream)new ByteArrayInputStream(respStream.toByteArray()), AwsProxyResponse.class);
        Assertions.assertNotNull((Object)resp);
        Assertions.assertEquals((int)500, (int)resp.getStatusCode());
    }

    @Test
    void streamHandle_InvalidRequestEventException_responseString() throws IOException {
        ByteArrayOutputStream respStream = new ByteArrayOutputStream();
        this.exceptionHandler.handle((Throwable)new InvalidRequestEventException(INVALID_REQUEST_MESSAGE, null), (OutputStream)respStream);
        Assertions.assertNotNull((Object)respStream);
        Assertions.assertTrue((respStream.size() > 0 ? 1 : 0) != 0);
        AwsProxyResponse resp = (AwsProxyResponse)this.objectMapper.readValue((InputStream)new ByteArrayInputStream(respStream.toByteArray()), AwsProxyResponse.class);
        Assertions.assertNotNull((Object)resp);
        String body = this.objectMapper.writeValueAsString((Object)new ErrorModel(AwsProxyExceptionHandler.INTERNAL_SERVER_ERROR));
        Assertions.assertEquals((Object)body, (Object)resp.getBody());
    }

    @Test
    void streamHandle_InvalidRequestEventException_jsonContentTypeHeader() throws IOException {
        ByteArrayOutputStream respStream = new ByteArrayOutputStream();
        this.exceptionHandler.handle((Throwable)new InvalidRequestEventException(INVALID_REQUEST_MESSAGE, null), (OutputStream)respStream);
        Assertions.assertNotNull((Object)respStream);
        Assertions.assertTrue((respStream.size() > 0 ? 1 : 0) != 0);
        AwsProxyResponse resp = (AwsProxyResponse)this.objectMapper.readValue((InputStream)new ByteArrayInputStream(respStream.toByteArray()), AwsProxyResponse.class);
        Assertions.assertNotNull((Object)resp);
        Assertions.assertTrue((boolean)resp.getMultiValueHeaders().containsKey((Object)"Content-Type"));
        Assertions.assertEquals((Object)"application/json", (Object)resp.getMultiValueHeaders().getFirst((Object)"Content-Type"));
    }

    @Test
    void streamHandle_InvalidResponseObjectException_502State() throws IOException {
        ByteArrayOutputStream respStream = new ByteArrayOutputStream();
        this.exceptionHandler.handle((Throwable)new InvalidResponseObjectException(INVALID_RESPONSE_MESSAGE, null), (OutputStream)respStream);
        Assertions.assertNotNull((Object)respStream);
        Assertions.assertTrue((respStream.size() > 0 ? 1 : 0) != 0);
        AwsProxyResponse resp = (AwsProxyResponse)this.objectMapper.readValue((InputStream)new ByteArrayInputStream(respStream.toByteArray()), AwsProxyResponse.class);
        Assertions.assertNotNull((Object)resp);
        Assertions.assertEquals((int)502, (int)resp.getStatusCode());
    }

    @Test
    void streamHandle_InvalidResponseObjectException_responseString() throws IOException {
        ByteArrayOutputStream respStream = new ByteArrayOutputStream();
        this.exceptionHandler.handle((Throwable)new InvalidResponseObjectException(INVALID_RESPONSE_MESSAGE, null), (OutputStream)respStream);
        Assertions.assertNotNull((Object)respStream);
        Assertions.assertTrue((respStream.size() > 0 ? 1 : 0) != 0);
        AwsProxyResponse resp = (AwsProxyResponse)this.objectMapper.readValue((InputStream)new ByteArrayInputStream(respStream.toByteArray()), AwsProxyResponse.class);
        Assertions.assertNotNull((Object)resp);
        String body = this.objectMapper.writeValueAsString((Object)new ErrorModel(AwsProxyExceptionHandler.GATEWAY_TIMEOUT_ERROR));
        Assertions.assertEquals((Object)body, (Object)resp.getBody());
    }

    @Test
    void streamHandle_InvalidResponseObjectException_jsonContentTypeHeader() throws IOException {
        ByteArrayOutputStream respStream = new ByteArrayOutputStream();
        this.exceptionHandler.handle((Throwable)new InvalidResponseObjectException(INVALID_RESPONSE_MESSAGE, null), (OutputStream)respStream);
        Assertions.assertNotNull((Object)respStream);
        Assertions.assertTrue((respStream.size() > 0 ? 1 : 0) != 0);
        AwsProxyResponse resp = (AwsProxyResponse)this.objectMapper.readValue((InputStream)new ByteArrayInputStream(respStream.toByteArray()), AwsProxyResponse.class);
        Assertions.assertNotNull((Object)resp);
        Assertions.assertTrue((boolean)resp.getMultiValueHeaders().containsKey((Object)"Content-Type"));
        Assertions.assertEquals((Object)"application/json", (Object)resp.getMultiValueHeaders().getFirst((Object)"Content-Type"));
    }

    @Test
    void errorMessage_InternalServerError_staticString() {
        Assertions.assertEquals((Object)"Internal Server Error", (Object)AwsProxyExceptionHandler.INTERNAL_SERVER_ERROR);
    }

    @Test
    void errorMessage_GatewayTimeout_staticString() {
        Assertions.assertEquals((Object)"Gateway Timeout", (Object)AwsProxyExceptionHandler.GATEWAY_TIMEOUT_ERROR);
    }

    @Test
    void getErrorJson_ErrorModel_validJson() throws IOException {
        String output = this.exceptionHandler.getErrorJson(INVALID_RESPONSE_MESSAGE);
        Assertions.assertNotNull((Object)output);
        ErrorModel error = (ErrorModel)this.objectMapper.readValue(output, ErrorModel.class);
        Assertions.assertNotNull((Object)error);
        Assertions.assertEquals((Object)INVALID_RESPONSE_MESSAGE, (Object)error.getMessage());
    }

    @Test
    void getErrorJson_JsonParsinException_validJson() throws IOException {
        ObjectMapper mockMapper = (ObjectMapper)Mockito.mock(ObjectMapper.class);
        JsonProcessingException exception = (JsonProcessingException)((Object)Mockito.mock(JsonProcessingException.class));
        Mockito.when((Object)mockMapper.writeValueAsString(ArgumentMatchers.any(Object.class))).thenThrow(new Throwable[]{exception});
        String output = this.exceptionHandler.getErrorJson(INVALID_RESPONSE_MESSAGE);
        Assertions.assertNotNull((Object)output);
        ErrorModel error = (ErrorModel)this.objectMapper.readValue(output, ErrorModel.class);
        Assertions.assertNotNull((Object)error);
        Assertions.assertEquals((Object)INVALID_RESPONSE_MESSAGE, (Object)error.getMessage());
    }
}

