/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.jaxrs;

import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.SecurityUtils;
import com.amazonaws.serverless.proxy.model.HttpApiV2ProxyRequest;
import com.amazonaws.services.lambda.runtime.Context;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import jakarta.ws.rs.core.SecurityContext;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsHttpApiV2SecurityContext
implements SecurityContext {
    public static final String AUTH_SCHEME_JWT = "JWT";
    private static Logger log = LoggerFactory.getLogger(AwsHttpApiV2SecurityContext.class);
    private Context lambdaContext;
    private HttpApiV2ProxyRequest event;

    public AwsHttpApiV2SecurityContext(Context lambdaCtx, HttpApiV2ProxyRequest request) {
        this.lambdaContext = lambdaCtx;
        this.event = request;
    }

    public Principal getUserPrincipal() {
        String[] parts;
        if (this.getAuthenticationScheme() == null || !this.event.getHeaders().containsKey("Authorization")) {
            return null;
        }
        String authValue = this.event.getHeaders().get("Authorization");
        if (authValue.startsWith("Bearer ")) {
            authValue = authValue.replace("Bearer ", "");
        }
        if ((parts = authValue.split("\\.")).length != 3) {
            log.warn("Could not parse JWT token for requestId: " + SecurityUtils.crlf(this.event.getRequestContext().getRequestId()));
            return null;
        }
        String decodedBody = new String(Base64.getMimeDecoder().decode(parts[1]), StandardCharsets.UTF_8);
        try {
            JsonNode parsedBody = LambdaContainerHandler.getObjectMapper().readTree(decodedBody);
            if (!parsedBody.isObject() && parsedBody.has("sub")) {
                log.debug("Could not find \"sub\" field in JWT body for requestId: " + SecurityUtils.crlf(this.event.getRequestContext().getRequestId()));
                return null;
            }
            String subject = parsedBody.get("sub").asText();
            return () -> subject;
        }
        catch (JsonProcessingException e) {
            log.error("Error while attempting to parse JWT body for requestId: " + SecurityUtils.crlf(this.event.getRequestContext().getRequestId()), (Throwable)e);
            return null;
        }
    }

    public boolean isUserInRole(String s) {
        if (this.getAuthenticationScheme() == null) {
            return false;
        }
        return this.event.getRequestContext().getAuthorizer().getJwtAuthorizer().getScopes().contains(s) || this.event.getRequestContext().getAuthorizer().getJwtAuthorizer().getClaims().containsKey(s);
    }

    public boolean isSecure() {
        return this.getAuthenticationScheme() != null;
    }

    public String getAuthenticationScheme() {
        if (this.event.getRequestContext().getAuthorizer() == null) {
            return null;
        }
        if (this.event.getRequestContext().getAuthorizer().isJwt()) {
            return AUTH_SCHEME_JWT;
        }
        return null;
    }
}

