/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.SecurityUtils;
import com.amazonaws.serverless.proxy.internal.servlet.CookieProcessor;
import jakarta.servlet.http.Cookie;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsCookieProcessor
implements CookieProcessor {
    static final String COOKIE_COMMENT_ATTR = "Comment";
    static final String COOKIE_DOMAIN_ATTR = "Domain";
    static final String COOKIE_EXPIRES_ATTR = "Expires";
    static final String COOKIE_MAX_AGE_ATTR = "Max-Age";
    static final String COOKIE_PATH_ATTR = "Path";
    static final String COOKIE_SECURE_ATTR = "Secure";
    static final String COOKIE_HTTP_ONLY_ATTR = "HttpOnly";
    static final String COOKIE_SAME_SITE_ATTR = "SameSite";
    static final String COOKIE_PARTITIONED_ATTR = "Partitioned";
    static final String EMPTY_STRING = "";
    static final BitSet tokenValid = AwsCookieProcessor.createTokenValidSet();
    static final BitSet domainValid = AwsCookieProcessor.createDomainValidSet();
    static final DateTimeFormatter COOKIE_DATE_FORMATTER = DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneId.of("GMT"));
    static final String ANCIENT_DATE = COOKIE_DATE_FORMATTER.format(Instant.ofEpochMilli(10000L));
    private final Logger log = LoggerFactory.getLogger(AwsCookieProcessor.class);

    static BitSet createTokenValidSet() {
        int c;
        BitSet tokenSet = new BitSet(128);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            tokenSet.set(c);
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            tokenSet.set(c);
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            tokenSet.set(c);
        }
        for (char c2 : "!#$%&'*+-.^_`|~".toCharArray()) {
            tokenSet.set(c2);
        }
        return tokenSet;
    }

    static BitSet createDomainValidSet() {
        int c;
        BitSet domainValid = new BitSet(128);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            domainValid.set(c);
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            domainValid.set(c);
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            domainValid.set(c);
        }
        domainValid.set(46);
        domainValid.set(45);
        return domainValid;
    }

    @Override
    public Cookie[] parseCookieHeader(String cookieHeader) {
        if (cookieHeader == null || cookieHeader.trim().isEmpty()) {
            return new Cookie[0];
        }
        return (Cookie[])Arrays.stream(cookieHeader.split("\\s*;\\s*")).map(this::parseCookiePair).filter(Objects::nonNull).toArray(Cookie[]::new);
    }

    private Cookie parseCookiePair(String cookiePair) {
        String[] kv = cookiePair.split("=", 2);
        if (kv.length != 2) {
            this.log.warn("Ignoring invalid cookie: {}", (Object)cookiePair);
            return null;
        }
        String cookieName = kv[0];
        String cookieValue = kv[1];
        if (!this.isToken(cookieName)) {
            this.log.warn("Ignoring cookie with invalid name: {}={}", (Object)cookieName, (Object)cookieValue);
            return null;
        }
        if (!this.isValidCookieValue(cookieValue)) {
            this.log.warn("Ignoring cookie with invalid value: {}={}", (Object)cookieName, (Object)cookieValue);
            return null;
        }
        return new Cookie(SecurityUtils.crlf(cookieName), SecurityUtils.crlf(cookieValue));
    }

    @Override
    public String generateHeader(Cookie cookie) {
        String partitioned;
        String sameSite;
        String path;
        int maxAge;
        StringBuilder header = new StringBuilder();
        header.append(cookie.getName()).append('=');
        String value = cookie.getValue();
        if (value != null && value.length() > 0) {
            this.validateCookieValue(value);
            header.append(value);
        }
        if ((maxAge = cookie.getMaxAge()) == 0) {
            this.appendAttribute(header, COOKIE_EXPIRES_ATTR, ANCIENT_DATE);
        } else if (maxAge > 0) {
            Instant expiresAt = Instant.now().plusSeconds(maxAge);
            this.appendAttribute(header, COOKIE_EXPIRES_ATTR, COOKIE_DATE_FORMATTER.format(expiresAt));
            this.appendAttribute(header, COOKIE_MAX_AGE_ATTR, String.valueOf(maxAge));
        }
        String domain = cookie.getDomain();
        if (domain != null && !domain.isEmpty()) {
            this.validateDomain(domain);
            this.appendAttribute(header, COOKIE_DOMAIN_ATTR, domain);
        }
        if ((path = cookie.getPath()) != null && !path.isEmpty()) {
            this.validatePath(path);
            this.appendAttribute(header, COOKIE_PATH_ATTR, path);
        }
        if (cookie.getSecure()) {
            this.appendAttributeWithoutValue(header, COOKIE_SECURE_ATTR);
        }
        if (cookie.isHttpOnly()) {
            this.appendAttributeWithoutValue(header, COOKIE_HTTP_ONLY_ATTR);
        }
        if ((sameSite = cookie.getAttribute(COOKIE_SAME_SITE_ATTR)) != null) {
            this.appendAttribute(header, COOKIE_SAME_SITE_ATTR, sameSite);
        }
        if (EMPTY_STRING.equals(partitioned = cookie.getAttribute(COOKIE_PARTITIONED_ATTR))) {
            this.appendAttributeWithoutValue(header, COOKIE_PARTITIONED_ATTR);
        }
        this.addAdditionalAttributes(cookie, header);
        return header.toString();
    }

    private void appendAttribute(StringBuilder header, String name, String value) {
        header.append("; ").append(name);
        if (!EMPTY_STRING.equals(value)) {
            header.append('=').append(value);
        }
    }

    private void appendAttributeWithoutValue(StringBuilder header, String name) {
        header.append("; ").append(name);
    }

    private void addAdditionalAttributes(Cookie cookie, StringBuilder header) {
        block13: for (Map.Entry entry : cookie.getAttributes().entrySet()) {
            switch ((String)entry.getKey()) {
                case "Comment": 
                case "Domain": 
                case "Max-Age": 
                case "Path": 
                case "Secure": 
                case "HttpOnly": 
                case "SameSite": 
                case "Partitioned": {
                    continue block13;
                }
            }
            this.validateAttribute((String)entry.getKey(), (String)entry.getValue());
            this.appendAttribute(header, (String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void validateCookieValue(String value) {
        if (!this.isValidCookieValue(value)) {
            throw new IllegalArgumentException("Invalid cookie value: " + value);
        }
    }

    private void validateDomain(String domain) {
        if (!this.isValidDomain(domain)) {
            throw new IllegalArgumentException("Invalid cookie domain: " + domain);
        }
    }

    private void validatePath(String path) {
        for (char ch : path.toCharArray()) {
            if (ch >= ' ' && ch <= '~' && ch != ';') continue;
            throw new IllegalArgumentException("Invalid cookie path: " + path);
        }
    }

    private void validateAttribute(String name, String value) {
        if (!this.isToken(name)) {
            throw new IllegalArgumentException("Invalid cookie attribute name: " + name);
        }
        for (char ch : value.toCharArray()) {
            if (ch >= ' ' && ch <= '~' && ch != ';') continue;
            throw new IllegalArgumentException("Invalid cookie attribute value: " + ch);
        }
    }

    private boolean isValidCookieValue(String value) {
        int start = 0;
        int end = value.length();
        boolean quoted = end > 1 && value.charAt(0) == '\"' && value.charAt(end - 1) == '\"';
        char[] chars = value.toCharArray();
        for (int i = start; i < end; ++i) {
            char c;
            if (quoted && (i == start || i == end - 1) || this.isValidCookieChar(c = chars[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isValidDomain(String domain) {
        if (domain.isEmpty()) {
            return false;
        }
        int prev = -1;
        for (int n : domain.toCharArray()) {
            if (!domainValid.get(n) || this.isInvalidLabelStartOrEnd(prev, (char)n)) {
                return false;
            }
            prev = n;
        }
        return prev != 46 && prev != 45;
    }

    private boolean isInvalidLabelStartOrEnd(int prev, char current) {
        return (prev == 46 || prev == -1) && (current == '.' || current == '-') || prev == 45 && current == '.';
    }

    private boolean isToken(String s) {
        if (s.isEmpty()) {
            return false;
        }
        for (char c : s.toCharArray()) {
            if (tokenValid.get(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidCookieChar(char c) {
        return c >= '!' && c <= '~' && c != '\"' && c != ',' && c != ';' && c != '\\';
    }
}

