/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.NullInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsServletInputStream
extends ServletInputStream {
    private static Logger log = LoggerFactory.getLogger(AwsServletInputStream.class);
    private InputStream bodyStream;
    private ReadListener listener;
    private boolean finished;

    public AwsServletInputStream(InputStream body) {
        this.bodyStream = body;
        this.finished = false;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isReady() {
        if (this.finished && this.listener != null) {
            try {
                this.listener.onAllDataRead();
            }
            catch (IOException e) {
                log.error("Could not notify listeners that input stream data is ready", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return !this.finished;
    }

    public void setReadListener(ReadListener readListener) {
        this.listener = readListener;
        try {
            this.listener.onDataAvailable();
        }
        catch (IOException e) {
            log.error("Could not notify listeners that data is available", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int read() throws IOException {
        if (this.bodyStream == null || this.bodyStream instanceof NullInputStream) {
            return -1;
        }
        int readByte = this.bodyStream.read();
        if (readByte == -1) {
            this.finished = true;
        }
        return readByte;
    }
}

