/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy;

import com.amazonaws.serverless.exceptions.InvalidRequestEventException;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import com.amazonaws.services.lambda.runtime.Context;
import jakarta.ws.rs.core.SecurityContext;

public abstract class RequestReader<RequestType, ContainerRequestType> {
    public static final String API_GATEWAY_CONTEXT_PROPERTY = "com.amazonaws.apigateway.request.context";
    public static final String API_GATEWAY_STAGE_VARS_PROPERTY = "com.amazonaws.apigateway.stage.variables";
    public static final String ALB_CONTEXT_PROPERTY = "com.amazonaws.alb.request.context";
    public static final String API_GATEWAY_EVENT_PROPERTY = "com.amazonaws.apigateway.request";
    public static final String LAMBDA_CONTEXT_PROPERTY = "com.amazonaws.lambda.context";
    public static final String JAX_SECURITY_CONTEXT_PROPERTY = "com.amazonaws.serverless.jaxrs.securityContext";
    public static final String HTTP_API_CONTEXT_PROPERTY = "com.amazonaws.httpapi.request.context";
    public static final String HTTP_API_STAGE_VARS_PROPERTY = "com.amazonaws.httpapi.stage.variables";
    public static final String HTTP_API_EVENT_PROPERTY = "com.amazonaws.httpapi.request";

    public abstract ContainerRequestType readRequest(RequestType var1, SecurityContext var2, Context var3, ContainerConfig var4) throws InvalidRequestEventException;

    protected abstract Class<? extends RequestType> getRequestClass();

    protected String stripBasePath(String requestPath, ContainerConfig config) {
        if (!config.isStripBasePath()) {
            return requestPath;
        }
        if (requestPath.startsWith(config.getServiceBasePath())) {
            String newRequestPath = requestPath.replaceFirst(config.getServiceBasePath(), "");
            if (!newRequestPath.startsWith("/")) {
                newRequestPath = "/" + newRequestPath;
            }
            return newRequestPath;
        }
        return requestPath;
    }
}

