/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.model;

import com.amazonaws.serverless.proxy.internal.testutils.AwsProxyRequestBuilder;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AwsProxyRequestTest {
    private static final String CUSTOM_HEADER_KEY_LOWER_CASE = "custom-header";
    private static final String CUSTOM_HEADER_VALUE = "123456";

    @Test
    void deserialize_multiValuedHeaders_caseInsensitive() throws IOException {
        AwsProxyRequest req = new AwsProxyRequestBuilder().fromJsonString(this.getRequestJson(true, CUSTOM_HEADER_KEY_LOWER_CASE, CUSTOM_HEADER_VALUE)).build();
        Assertions.assertNotNull((Object)req.getMultiValueHeaders().get((Object)CUSTOM_HEADER_KEY_LOWER_CASE.toUpperCase()));
        Assertions.assertEquals((Object)CUSTOM_HEADER_VALUE, req.getMultiValueHeaders().get((Object)CUSTOM_HEADER_KEY_LOWER_CASE.toUpperCase()).get(0));
        Assertions.assertTrue((boolean)req.isBase64Encoded());
    }

    @Test
    void deserialize_base64Encoded_readsBoolCorrectly() throws IOException {
        AwsProxyRequest req = new AwsProxyRequestBuilder().fromJsonString(this.getRequestJson(true, CUSTOM_HEADER_KEY_LOWER_CASE, CUSTOM_HEADER_VALUE)).build();
        Assertions.assertTrue((boolean)req.isBase64Encoded());
        req = new AwsProxyRequestBuilder().fromJsonString(this.getRequestJson(false, CUSTOM_HEADER_KEY_LOWER_CASE, CUSTOM_HEADER_VALUE)).build();
        Assertions.assertFalse((boolean)req.isBase64Encoded());
    }

    @Test
    void serialize_base64Encoded_fieldContainsIsPrefix() throws IOException {
        AwsProxyRequest req = new AwsProxyRequestBuilder().fromJsonString(this.getRequestJson(true, CUSTOM_HEADER_KEY_LOWER_CASE, CUSTOM_HEADER_VALUE)).build();
        ObjectMapper mapper = new ObjectMapper();
        String serializedRequest = mapper.writeValueAsString((Object)req);
        Assertions.assertTrue((boolean)serializedRequest.contains("\"isBase64Encoded\":true"));
    }

    private String getRequestJson(boolean base64Encoded, String headerKey, String headerValue) {
        return "{\n    \"resource\": \"/api/{proxy+}\",\n    \"path\": \"/api/endpoint\",\n    \"httpMethod\": \"OPTIONS\",\n    \"headers\": {\n        \"Accept\": \"*/*\",\n        \"User-Agent\": \"PostmanRuntime/7.1.1\",\n        \"" + headerKey + "\":\"" + headerValue + "\"\n    },\n    \"multiValueHeaders\": {\n        \"Accept\": [\n            \"*/*\"\n        ],\n        \"User-Agent\": [\n            \"PostmanRuntime/7.1.1\"\n        ],\n        \"" + headerKey + "\": [\n            \"" + headerValue + "\"\n        ]\n    },\n    \"queryStringParameters\": null,\n    \"multiValueQueryStringParameters\": null,\n    \"pathParameters\": {\n        \"proxy\": \"endpoint\"\n    },\n    \"stageVariables\": null,\n    \"requestContext\": {\n        \"resourceId\": null,\n        \"resourcePath\": \"/api/{proxy+}\",\n        \"httpMethod\": \"OPTIONS\",\n        \"extendedRequestId\": null,\n        \"requestTime\": \"15/Dec/2018:20:37:47 +0000\",\n        \"path\": \"/api/endpoint\",\n        \"accountId\": null,\n        \"protocol\": \"HTTP/1.1\",\n        \"stage\": \"stage_name\",\n        \"domainPrefix\": null,\n        \"requestTimeEpoch\": 1544906267828,\n        \"requestId\": null,\n        \"identity\": {\n            \"cognitoIdentityPoolId\": null,\n            \"accountId\": null,\n            \"cognitoIdentityId\": null,\n            \"caller\": null,\n            \"sourceIp\": \"54.240.196.171\",\n            \"accessKey\": null,\n            \"cognitoAuthenticationType\": null,\n            \"cognitoAuthenticationProvider\": null,\n            \"userArn\": null,\n            \"userAgent\": \"PostmanRuntime/7.1.1\",\n            \"user\": null\n        },\n        \"domainName\": \"https://apiId.execute-api.eu-central-1.amazonaws.com/\",\n        \"apiId\": \"apiId\"\n    },\n    \"body\": null,\n    \"isBase64Encoded\": " + (base64Encoded ? "true" : "false") + "\n}";
    }

    @Test
    void deserialize_singleValuedHeaders() throws IOException {
        AwsProxyRequest req = new AwsProxyRequestBuilder().fromJsonString(this.getSingleValueRequestJson()).build();
        MatcherAssert.assertThat((Object)((String)req.getHeaders().get((Object)"accept")), (Matcher)CoreMatchers.is((Object)"*"));
    }

    private String getSingleValueRequestJson() {
        return "{\n        \"requestContext\": {\n            \"elb\": {\n                \"targetGroupArn\": \"arn:aws:elasticloadbalancing:us-east-2:123456789012:targetgroup/prod-example-function/e77803ebb6d2c24\"\n            }\n        },\n        \"httpMethod\": \"PUT\",\n        \"path\": \"/path/to/resource\",\n        \"queryStringParameters\": {},\n        \"headers\": {\n            \"accept\": \"*\",\n            \"content-length\": \"17\",\n            \"content-type\": \"application/json\",\n            \"host\": \"stackoverflow.name\",\n            \"user-agent\": \"curl/7.77.0\",\n            \"x-amzn-trace-id\": \"Root=1-62e22402-3a5f246225e45edd7735c182\",\n            \"x-forwarded-for\": \"24.14.13.186\",\n            \"x-forwarded-port\": \"443\",\n            \"x-forwarded-proto\": \"https\",\n            \"x-jersey-tracing-accept\": \"true\"\n        },\n        \"body\": \"{\\\"alpha\\\":\\\"bravo\\\"}\",\n        \"isBase64Encoded\": false\n}      \n";
    }
}

