/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.testutils;

import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.model.AlbContext;
import com.amazonaws.serverless.proxy.model.ApiGatewayAuthorizerContext;
import com.amazonaws.serverless.proxy.model.ApiGatewayRequestIdentity;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyRequestContext;
import com.amazonaws.serverless.proxy.model.CognitoAuthorizerClaims;
import com.amazonaws.serverless.proxy.model.Headers;
import com.amazonaws.serverless.proxy.model.HttpApiV2AuthorizerMap;
import com.amazonaws.serverless.proxy.model.HttpApiV2HttpContext;
import com.amazonaws.serverless.proxy.model.HttpApiV2JwtAuthorizer;
import com.amazonaws.serverless.proxy.model.HttpApiV2ProxyRequest;
import com.amazonaws.serverless.proxy.model.HttpApiV2ProxyRequestContext;
import com.amazonaws.serverless.proxy.model.MultiValuedTreeMap;
import com.amazonaws.serverless.proxy.model.RequestSource;
import com.fasterxml.jackson.core.JsonProcessingException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.entity.mime.ByteArrayBody;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;

public class AwsProxyRequestBuilder {
    private AwsProxyRequest request;
    private MultipartEntityBuilder multipartBuilder;

    public AwsProxyRequestBuilder() {
        this(null, null);
    }

    public AwsProxyRequestBuilder(String path) {
        this(path, null);
    }

    public AwsProxyRequestBuilder(AwsProxyRequest req) {
        this.request = req;
    }

    public AwsProxyRequestBuilder(String path, String httpMethod) {
        this.request = new AwsProxyRequest();
        this.request.setMultiValueHeaders(new Headers());
        this.request.setHttpMethod(httpMethod);
        this.request.setPath(path);
        this.request.setMultiValueQueryStringParameters(new MultiValuedTreeMap());
        this.request.setRequestContext(new AwsProxyRequestContext());
        this.request.getRequestContext().setRequestId(UUID.randomUUID().toString());
        this.request.getRequestContext().setExtendedRequestId(UUID.randomUUID().toString());
        this.request.getRequestContext().setStage("test");
        this.request.getRequestContext().setProtocol("HTTP/1.1");
        this.request.getRequestContext().setRequestTimeEpoch(System.currentTimeMillis());
        ApiGatewayRequestIdentity identity = new ApiGatewayRequestIdentity();
        identity.setSourceIp("127.0.0.1");
        this.request.getRequestContext().setIdentity(identity);
    }

    public AwsProxyRequestBuilder alb() {
        this.request.setRequestContext(new AwsProxyRequestContext());
        this.request.getRequestContext().setElb(new AlbContext());
        this.request.getRequestContext().getElb().setTargetGroupArn("arn:aws:elasticloadbalancing:us-east-1:123456789012:targetgroup/lambda-target/d6190d154bc908a5");
        if (this.request.getMultiValueQueryStringParameters() != null) {
            MultiValuedTreeMap newQs = new MultiValuedTreeMap();
            for (Map.Entry e : this.request.getMultiValueQueryStringParameters().entrySet()) {
                for (String v : (List)e.getValue()) {
                    try {
                        String key = URLEncoder.encode((String)e.getKey(), "UTF-8").replaceAll("%2C", ",");
                        String value = URLEncoder.encode(v, "UTF-8").replaceAll("%2C", ",");
                        newQs.add((Object)key, (Object)value);
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new RuntimeException("Could not encode query string parameters: " + (String)e.getKey() + "=" + v, ex);
                    }
                }
            }
            this.request.setMultiValueQueryStringParameters(newQs);
        }
        return this;
    }

    public AwsProxyRequestBuilder stage(String stageName) {
        this.request.getRequestContext().setStage(stageName);
        return this;
    }

    public AwsProxyRequestBuilder method(String httpMethod) {
        this.request.setHttpMethod(httpMethod);
        return this;
    }

    public AwsProxyRequestBuilder path(String path) {
        this.request.setPath(path);
        return this;
    }

    public AwsProxyRequestBuilder json() {
        return this.header("Content-Type", "application/json");
    }

    public AwsProxyRequestBuilder form(String key, String value) {
        if (this.request.getMultiValueHeaders() == null) {
            this.request.setMultiValueHeaders(new Headers());
        }
        this.request.getMultiValueHeaders().add((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
        String body = this.request.getBody();
        if (body == null) {
            body = "";
        }
        body = body + (body.equals("") ? "" : "&") + key + "=" + value;
        this.request.setBody(body);
        return this;
    }

    public AwsProxyRequestBuilder formFilePart(String fieldName, String fileName, byte[] content) throws IOException {
        if (this.multipartBuilder == null) {
            this.multipartBuilder = MultipartEntityBuilder.create();
        }
        this.multipartBuilder.addPart(fieldName, (ContentBody)new ByteArrayBody(content, fileName));
        this.buildMultipartBody();
        return this;
    }

    public AwsProxyRequestBuilder formTextFieldPart(String fieldName, String fieldValue) throws IOException {
        if (this.request.getMultiValueHeaders() == null) {
            this.request.setMultiValueHeaders(new Headers());
        }
        if (this.multipartBuilder == null) {
            this.multipartBuilder = MultipartEntityBuilder.create();
        }
        this.multipartBuilder.addPart(fieldName, (ContentBody)new StringBody(fieldValue, ContentType.TEXT_PLAIN));
        this.buildMultipartBody();
        return this;
    }

    private void buildMultipartBody() throws IOException {
        HttpEntity bodyEntity = this.multipartBuilder.build();
        InputStream bodyStream = bodyEntity.getContent();
        byte[] buffer = new byte[bodyStream.available()];
        IOUtils.readFully((InputStream)bodyStream, (byte[])buffer);
        byte[] finalBuffer = new byte[buffer.length + 1];
        byte[] newLineBytes = "\n\n".getBytes(LambdaContainerHandler.getContainerConfig().getDefaultContentCharset());
        System.arraycopy(newLineBytes, 0, finalBuffer, 0, newLineBytes.length);
        System.arraycopy(buffer, 0, finalBuffer, newLineBytes.length - 1, buffer.length);
        this.request.setBody(Base64.getMimeEncoder().encodeToString(finalBuffer));
        this.request.setIsBase64Encoded(true);
        this.request.setMultiValueHeaders(new Headers());
        this.header("Content-Type", bodyEntity.getContentType());
        this.header("Content-Length", bodyEntity.getContentLength() + "");
    }

    public AwsProxyRequestBuilder header(String key, String value) {
        if (this.request.getMultiValueHeaders() == null) {
            this.request.setMultiValueHeaders(new Headers());
        }
        this.request.getMultiValueHeaders().add((Object)key, (Object)value);
        return this;
    }

    public AwsProxyRequestBuilder multiValueHeaders(Headers h) {
        this.request.setMultiValueHeaders(h);
        return this;
    }

    public AwsProxyRequestBuilder multiValueQueryString(MultiValuedTreeMap<String, String> params) {
        this.request.setMultiValueQueryStringParameters(params);
        return this;
    }

    public AwsProxyRequestBuilder queryString(String key, String value) {
        if (this.request.getMultiValueQueryStringParameters() == null) {
            this.request.setMultiValueQueryStringParameters(new MultiValuedTreeMap());
        }
        if (this.request.getRequestSource() == RequestSource.API_GATEWAY) {
            this.request.getMultiValueQueryStringParameters().add((Object)key, (Object)value);
        }
        if (this.request.getRequestSource() == RequestSource.ALB) {
            try {
                this.request.getMultiValueQueryStringParameters().add((Object)key, (Object)URLEncoder.encode(value, "ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public AwsProxyRequestBuilder body(String body) {
        this.request.setBody(body);
        return this;
    }

    public AwsProxyRequestBuilder nullBody() {
        this.request.setBody(null);
        return this;
    }

    public AwsProxyRequestBuilder body(Object body) {
        if (this.request.getMultiValueHeaders() != null && ((String)this.request.getMultiValueHeaders().getFirst((Object)"Content-Type")).startsWith("application/json")) {
            try {
                return this.body(LambdaContainerHandler.getObjectMapper().writeValueAsString(body));
            }
            catch (JsonProcessingException e) {
                throw new UnsupportedOperationException("Could not serialize object: " + e.getMessage());
            }
        }
        throw new UnsupportedOperationException("Unsupported content type in request");
    }

    public AwsProxyRequestBuilder apiId(String id) {
        if (this.request.getRequestContext() == null) {
            this.request.setRequestContext(new AwsProxyRequestContext());
        }
        this.request.getRequestContext().setApiId(id);
        return this;
    }

    public AwsProxyRequestBuilder binaryBody(InputStream is) throws IOException {
        this.request.setIsBase64Encoded(true);
        return this.body(Base64.getMimeEncoder().encodeToString(IOUtils.toByteArray((InputStream)is)));
    }

    public AwsProxyRequestBuilder authorizerPrincipal(String principal) {
        if (this.request.getRequestSource() == RequestSource.API_GATEWAY) {
            if (this.request.getRequestContext().getAuthorizer() == null) {
                this.request.getRequestContext().setAuthorizer(new ApiGatewayAuthorizerContext());
            }
            this.request.getRequestContext().getAuthorizer().setPrincipalId(principal);
            if (this.request.getRequestContext().getAuthorizer().getClaims() == null) {
                this.request.getRequestContext().getAuthorizer().setClaims(new CognitoAuthorizerClaims());
            }
            this.request.getRequestContext().getAuthorizer().getClaims().setSubject(principal);
        }
        if (this.request.getRequestSource() == RequestSource.ALB) {
            this.header("x-amzn-oidc-identity", principal);
            try {
                this.header("x-amzn-oidc-accesstoken", Base64.getMimeEncoder().encodeToString("test-token".getBytes("ISO-8859-1")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public AwsProxyRequestBuilder authorizerContextValue(String key, String value) {
        if (this.request.getRequestContext().getAuthorizer() == null) {
            this.request.getRequestContext().setAuthorizer(new ApiGatewayAuthorizerContext());
        }
        this.request.getRequestContext().getAuthorizer().setContextValue(key, value);
        return this;
    }

    public AwsProxyRequestBuilder cognitoUserPool(String identityId) {
        this.request.getRequestContext().getIdentity().setCognitoAuthenticationType("POOL");
        this.request.getRequestContext().getIdentity().setCognitoIdentityId(identityId);
        if (this.request.getRequestContext().getAuthorizer() == null) {
            this.request.getRequestContext().setAuthorizer(new ApiGatewayAuthorizerContext());
        }
        this.request.getRequestContext().getAuthorizer().setClaims(new CognitoAuthorizerClaims());
        this.request.getRequestContext().getAuthorizer().getClaims().setSubject(identityId);
        return this;
    }

    public AwsProxyRequestBuilder claim(String claim, String value) {
        this.request.getRequestContext().getAuthorizer().getClaims().setClaim(claim, value);
        return this;
    }

    public AwsProxyRequestBuilder cognitoIdentity(String identityId, String identityPoolId) {
        this.request.getRequestContext().getIdentity().setCognitoAuthenticationType("IDENTITY");
        this.request.getRequestContext().getIdentity().setCognitoIdentityId(identityId);
        this.request.getRequestContext().getIdentity().setCognitoIdentityPoolId(identityPoolId);
        return this;
    }

    public AwsProxyRequestBuilder cookie(String name, String value) {
        String cookies;
        if (this.request.getMultiValueHeaders() == null) {
            this.request.setMultiValueHeaders(new Headers());
        }
        if ((cookies = (String)this.request.getMultiValueHeaders().getFirst((Object)"Cookie")) == null) {
            cookies = "";
        }
        cookies = cookies + (cookies.equals("") ? "" : "; ") + name + "=" + value;
        this.request.getMultiValueHeaders().putSingle((Object)"Cookie", (Object)cookies);
        return this;
    }

    public AwsProxyRequestBuilder scheme(String scheme) {
        if (this.request.getMultiValueHeaders() == null) {
            this.request.setMultiValueHeaders(new Headers());
        }
        this.request.getMultiValueHeaders().putSingle((Object)"CloudFront-Forwarded-Proto", (Object)scheme);
        return this;
    }

    public AwsProxyRequestBuilder serverName(String serverName) {
        if (this.request.getMultiValueHeaders() == null) {
            this.request.setMultiValueHeaders(new Headers());
        }
        this.request.getMultiValueHeaders().putSingle((Object)"Host", (Object)serverName);
        return this;
    }

    public AwsProxyRequestBuilder userAgent(String agent) {
        if (this.request.getRequestContext() == null) {
            this.request.setRequestContext(new AwsProxyRequestContext());
        }
        if (this.request.getRequestContext().getIdentity() == null) {
            this.request.getRequestContext().setIdentity(new ApiGatewayRequestIdentity());
        }
        this.request.getRequestContext().getIdentity().setUserAgent(agent);
        return this;
    }

    public AwsProxyRequestBuilder referer(String referer) {
        if (this.request.getRequestContext() == null) {
            this.request.setRequestContext(new AwsProxyRequestContext());
        }
        if (this.request.getRequestContext().getIdentity() == null) {
            this.request.getRequestContext().setIdentity(new ApiGatewayRequestIdentity());
        }
        this.request.getRequestContext().getIdentity().setCaller(referer);
        return this;
    }

    public AwsProxyRequestBuilder basicAuth(String username, String password) {
        this.request.getMultiValueHeaders().remove((Object)"Authorization");
        String authHeader = "Basic " + Base64.getMimeEncoder().encodeToString((username + ":" + password).getBytes(Charset.defaultCharset()));
        this.request.getMultiValueHeaders().add((Object)"Authorization", (Object)authHeader);
        return this;
    }

    public AwsProxyRequestBuilder fromJsonString(String jsonContent) throws IOException {
        this.request = (AwsProxyRequest)LambdaContainerHandler.getObjectMapper().readValue(jsonContent, AwsProxyRequest.class);
        return this;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    public AwsProxyRequestBuilder fromJsonPath(String filePath) throws IOException {
        this.request = (AwsProxyRequest)LambdaContainerHandler.getObjectMapper().readValue(new File(filePath), AwsProxyRequest.class);
        return this;
    }

    public AwsProxyRequest build() {
        return this.request;
    }

    public InputStream buildStream() {
        try {
            String requestJson = LambdaContainerHandler.getObjectMapper().writeValueAsString((Object)this.request);
            return new ByteArrayInputStream(requestJson.getBytes(StandardCharsets.UTF_8));
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public InputStream toHttpApiV2RequestStream() {
        HttpApiV2ProxyRequest req = this.toHttpApiV2Request();
        try {
            String requestJson = LambdaContainerHandler.getObjectMapper().writeValueAsString((Object)req);
            return new ByteArrayInputStream(requestJson.getBytes(StandardCharsets.UTF_8));
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public HttpApiV2ProxyRequest toHttpApiV2Request() {
        HttpApiV2ProxyRequest req = new HttpApiV2ProxyRequest();
        req.setRawPath(this.request.getPath());
        req.setBase64Encoded(this.request.isBase64Encoded());
        req.setBody(this.request.getBody());
        if (this.request.getMultiValueHeaders() != null && this.request.getMultiValueHeaders().containsKey((Object)"Cookie")) {
            req.setCookies(Arrays.asList(((String)this.request.getMultiValueHeaders().getFirst((Object)"Cookie")).split(";")));
        }
        req.setHeaders(new TreeMap(String.CASE_INSENSITIVE_ORDER));
        if (this.request.getMultiValueHeaders() != null) {
            this.request.getMultiValueHeaders().forEach((key, value) -> {
                if (!"Cookie".equals(key)) {
                    req.getHeaders().put(key, (String)value.get(0));
                }
            });
        }
        if (this.request.getRequestContext() != null && this.request.getRequestContext().getIdentity() != null) {
            if (this.request.getRequestContext().getIdentity().getCaller() != null) {
                req.getHeaders().put("Referer", this.request.getRequestContext().getIdentity().getCaller());
            }
            if (this.request.getRequestContext().getIdentity().getUserAgent() != null) {
                req.getHeaders().put("User-Agent", this.request.getRequestContext().getIdentity().getUserAgent());
            }
        }
        if (this.request.getMultiValueQueryStringParameters() != null) {
            StringBuilder rawQueryString = new StringBuilder();
            this.request.getMultiValueQueryStringParameters().forEach((k, v) -> {
                for (String s : v) {
                    rawQueryString.append("&");
                    rawQueryString.append((String)k);
                    rawQueryString.append("=");
                    try {
                        rawQueryString.append(URLEncoder.encode(s, "UTF-8").replaceAll("%2C", ","));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            String qs = rawQueryString.toString();
            if (qs.length() > 1) {
                req.setRawQueryString(qs.substring(1));
            }
        }
        req.setRouteKey("$default");
        req.setVersion("2.0");
        req.setStageVariables(this.request.getStageVariables());
        HttpApiV2ProxyRequestContext ctx = new HttpApiV2ProxyRequestContext();
        HttpApiV2HttpContext httpCtx = new HttpApiV2HttpContext();
        httpCtx.setMethod(this.request.getHttpMethod());
        httpCtx.setPath(this.request.getPath());
        httpCtx.setProtocol("HTTP/1.1");
        if (this.request.getRequestContext() != null && this.request.getRequestContext().getIdentity() != null && this.request.getRequestContext().getIdentity().getSourceIp() != null) {
            httpCtx.setSourceIp(this.request.getRequestContext().getIdentity().getSourceIp());
        } else {
            httpCtx.setSourceIp("127.0.0.1");
        }
        if (this.request.getRequestContext() != null && this.request.getRequestContext().getIdentity() != null && this.request.getRequestContext().getIdentity().getUserAgent() != null) {
            httpCtx.setUserAgent(this.request.getRequestContext().getIdentity().getUserAgent());
        }
        ctx.setHttp(httpCtx);
        if (this.request.getRequestContext() != null) {
            ctx.setAccountId(this.request.getRequestContext().getAccountId());
            ctx.setApiId(this.request.getRequestContext().getApiId());
            ctx.setDomainName(this.request.getRequestContext().getApiId() + ".execute-api.us-east-1.apigateway.com");
            ctx.setDomainPrefix(this.request.getRequestContext().getApiId());
            ctx.setRequestId(this.request.getRequestContext().getRequestId());
            ctx.setRouteKey("$default");
            ctx.setStage(this.request.getRequestContext().getStage());
            ctx.setTimeEpoch(this.request.getRequestContext().getRequestTimeEpoch());
            ctx.setTime(this.request.getRequestContext().getRequestTime());
            if (this.request.getRequestContext().getAuthorizer() != null) {
                HttpApiV2AuthorizerMap auth = new HttpApiV2AuthorizerMap();
                HttpApiV2JwtAuthorizer jwt = new HttpApiV2JwtAuthorizer();
                jwt.setClaims(new HashMap());
                jwt.setScopes(new ArrayList());
                auth.putJwtAuthorizer(jwt);
                ctx.setAuthorizer(auth);
            }
        }
        req.setRequestContext(ctx);
        return req;
    }
}

