/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet.filters;

import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.filters.UrlPathValidator;
import com.amazonaws.serverless.proxy.internal.testutils.AwsProxyRequestBuilder;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UrlPathValidatorTest {
    @Test
    void init_noConfig_setsDefaultStatusCode() {
        UrlPathValidator pathValidator = new UrlPathValidator();
        try {
            pathValidator.init(null);
            Assertions.assertEquals((int)404, (int)pathValidator.getInvalidStatusCode());
        }
        catch (ServletException e) {
            e.printStackTrace();
            Assertions.fail((String)"Unexpected ServletException");
        }
    }

    @Test
    void init_withConfig_setsCorrectStatusCode() {
        UrlPathValidator pathValidator = new UrlPathValidator();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("invalid_status_code", "401");
        FilterConfig cnf = this.mockFilterConfig(params);
        try {
            pathValidator.init(cnf);
            Assertions.assertEquals((int)401, (int)pathValidator.getInvalidStatusCode());
        }
        catch (ServletException e) {
            e.printStackTrace();
            Assertions.fail((String)"Unexpected ServletException");
        }
    }

    @Test
    void init_withWrongConfig_setsDefaultStatusCode() {
        UrlPathValidator pathValidator = new UrlPathValidator();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("invalid_status_code", "hello");
        FilterConfig cnf = this.mockFilterConfig(params);
        try {
            pathValidator.init(cnf);
            Assertions.assertEquals((int)404, (int)pathValidator.getInvalidStatusCode());
        }
        catch (ServletException e) {
            e.printStackTrace();
            Assertions.fail((String)"Unexpected ServletException");
        }
    }

    @Test
    void doFilter_invalidRelativePathUri_setsDefaultStatusCode() {
        AwsProxyHttpServletRequest req = new AwsProxyHttpServletRequest(new AwsProxyRequestBuilder("../..", "GET").build(), null, null);
        AwsHttpServletResponse resp = new AwsHttpServletResponse((HttpServletRequest)req, null);
        UrlPathValidator pathValidator = new UrlPathValidator();
        try {
            pathValidator.init(null);
            pathValidator.doFilter((ServletRequest)req, (ServletResponse)resp, null);
            Assertions.assertEquals((int)404, (int)resp.getStatus());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)"Unexpected exception");
        }
    }

    @Test
    void doFilter_invalidUri_setsDefaultStatusCode() {
        AwsProxyHttpServletRequest req = new AwsProxyHttpServletRequest(new AwsProxyRequestBuilder("wonkyprotocol://\u02dd\u00d3#\t", "GET").build(), null, null);
        AwsHttpServletResponse resp = new AwsHttpServletResponse((HttpServletRequest)req, null);
        UrlPathValidator pathValidator = new UrlPathValidator();
        try {
            pathValidator.init(null);
            pathValidator.doFilter((ServletRequest)req, (ServletResponse)resp, null);
            Assertions.assertEquals((int)404, (int)resp.getStatus());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)"Unexpected exception");
        }
    }

    private FilterConfig mockFilterConfig(final Map<String, String> initParams) {
        return new FilterConfig(){

            public String getFilterName() {
                return null;
            }

            public ServletContext getServletContext() {
                return null;
            }

            public String getInitParameter(String s) {
                return (String)initParams.get(s);
            }

            public Enumeration<String> getInitParameterNames() {
                return Collections.enumeration(initParams.keySet());
            }
        };
    }
}

