/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.servlet.AwsServletContext;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletRegistration;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AwsServletRegistrationTest {
    @Test
    void getMappings_singleMapping_savedCorrectly() {
        AwsServletRegistration reg = new AwsServletRegistration("test", null, new AwsServletContext(null));
        reg.addMapping(new String[]{"/"});
        Assertions.assertEquals((int)1, (int)reg.getMappings().size());
        Set invalidMappings = reg.addMapping(new String[]{"/"});
        Assertions.assertEquals((int)1, (int)invalidMappings.size());
        Assertions.assertEquals((Object)"/", (Object)invalidMappings.toArray(new String[0])[0]);
        reg.addMapping(new String[]{"/hello", "/world"});
        Assertions.assertEquals((int)3, (int)reg.getMappings().size());
    }

    @Test
    void metadata_savedAndReturnedCorrectly() {
        AwsServletRegistration reg = new AwsServletRegistration("test", null, new AwsServletContext(null));
        Assertions.assertEquals((Object)"test", (Object)reg.getName());
        reg.setLoadOnStartup(2);
        Assertions.assertEquals((int)2, (int)reg.getLoadOnStartup());
        Assertions.assertNull((Object)reg.getRunAsRole());
        reg.setRunAsRole("role");
        Assertions.assertEquals((Object)"role", (Object)reg.getRunAsRole());
        reg.setAsyncSupported(true);
        Assertions.assertTrue((boolean)reg.isAsyncSupported());
    }

    @Test
    void setInitParameter_savedCorrectly() {
        AwsServletRegistration reg = new AwsServletRegistration("test", null, new AwsServletContext(null));
        Assertions.assertTrue((boolean)reg.setInitParameter("param", "value"));
        Assertions.assertFalse((boolean)reg.setInitParameter("param", "value"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("param2", "value2");
        params.put("param", "value");
        Set invalidParams = reg.setInitParameters(params);
        Assertions.assertEquals((int)1, (int)invalidParams.size());
        Assertions.assertEquals((Object)"param", (Object)invalidParams.toArray(new String[0])[0]);
        Assertions.assertEquals((int)2, (int)reg.getInitParameters().size());
        Assertions.assertEquals((Object)"value2", (Object)reg.getInitParameter("param2"));
    }

    @Test
    void servletConfig_populatesConfig() throws ServletException {
        AwsServletContext servletCtx = new AwsServletContext(null);
        TestServlet servlet = new TestServlet();
        AwsServletRegistration reg = new AwsServletRegistration("test", (Servlet)servlet, servletCtx);
        Assertions.assertEquals((Object)servlet, (Object)reg.getServlet());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("param2", "value2");
        params.put("param", "value");
        Set invalidParams = reg.setInitParameters(params);
        Assertions.assertEquals((int)0, (int)invalidParams.size());
        ServletConfig config = reg.getServletConfig();
        Assertions.assertNotNull((Object)config);
        Assertions.assertEquals((Object)"test", (Object)config.getServletName());
        Assertions.assertEquals((Object)servletCtx, (Object)config.getServletContext());
        int paramCnt = 0;
        Enumeration paramNames = config.getInitParameterNames();
        while (paramNames.hasMoreElements()) {
            paramNames.nextElement();
            ++paramCnt;
        }
        Assertions.assertEquals((int)2, (int)paramCnt);
    }

    private class TestServlet
    implements Servlet {
        private TestServlet() {
        }

        public void init(ServletConfig servletConfig) throws ServletException {
        }

        public ServletConfig getServletConfig() {
            return null;
        }

        public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        }

        public String getServletInfo() {
            return null;
        }

        public void destroy() {
        }
    }
}

