/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.exceptions.InvalidRequestEventException;
import com.amazonaws.serverless.proxy.AwsProxyExceptionHandler;
import com.amazonaws.serverless.proxy.AwsProxySecurityContextWriter;
import com.amazonaws.serverless.proxy.ExceptionHandler;
import com.amazonaws.serverless.proxy.RequestReader;
import com.amazonaws.serverless.proxy.ResponseWriter;
import com.amazonaws.serverless.proxy.SecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.serverless.proxy.internal.servlet.AwsLambdaServletContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequestReader;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletResponseWriter;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyRequestDispatcher;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletContext;
import com.amazonaws.serverless.proxy.internal.testutils.AwsProxyRequestBuilder;
import com.amazonaws.serverless.proxy.internal.testutils.MockLambdaContext;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import com.amazonaws.services.lambda.runtime.Context;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.CountDownLatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestWrapper;

public class AwsProxyRequestDispatcherTest {
    public static final String FORWARD_PATH = "/newpath";
    static AwsProxyHttpServletRequestReader requestReader = new AwsProxyHttpServletRequestReader();

    @Test
    void setPath_forwardByPath_proxyRequestObjectInPropertyReferencesSameProxyRequest() throws InvalidRequestEventException {
        AwsProxyRequest proxyRequest = new AwsProxyRequestBuilder("/hello", "GET").build();
        HttpServletRequest servletRequest = requestReader.readRequest(proxyRequest, null, (Context)new MockLambdaContext(), ContainerConfig.defaultConfig());
        AwsProxyRequestDispatcher dispatcher = new AwsProxyRequestDispatcher(FORWARD_PATH, false, null);
        dispatcher.setRequestPath((ServletRequest)servletRequest, FORWARD_PATH);
        Assertions.assertEquals((Object)FORWARD_PATH, (Object)servletRequest.getRequestURI());
    }

    @Test
    void setPathForWrappedRequest_forwardByPath_proxyRequestObjectInPropertyReferencesSameProxyRequest() throws InvalidRequestEventException {
        AwsProxyRequest proxyRequest = new AwsProxyRequestBuilder("/hello", "GET").build();
        HttpServletRequest servletRequest = requestReader.readRequest(proxyRequest, null, (Context)new MockLambdaContext(), ContainerConfig.defaultConfig());
        SecurityContextHolderAwareRequestWrapper springSecurityRequest = new SecurityContextHolderAwareRequestWrapper(servletRequest, "ADMIN");
        AwsProxyRequestDispatcher dispatcher = new AwsProxyRequestDispatcher(FORWARD_PATH, false, null);
        dispatcher.setRequestPath((ServletRequest)springSecurityRequest, FORWARD_PATH);
        Assertions.assertEquals((Object)FORWARD_PATH, (Object)springSecurityRequest.getRequestURI());
    }

    @Test
    void setPathForWrappedRequestWithoutGatewayEvent_forwardByPath_throwsException() {
        AwsProxyRequest proxyRequest = new AwsProxyRequestBuilder("/hello", "GET").build();
        AwsProxyHttpServletRequest servletRequest = new AwsProxyHttpServletRequest(proxyRequest, (Context)new MockLambdaContext(), null);
        SecurityContextHolderAwareRequestWrapper springSecurityRequest = new SecurityContextHolderAwareRequestWrapper((HttpServletRequest)servletRequest, "ADMIN");
        AwsProxyRequestDispatcher dispatcher = new AwsProxyRequestDispatcher(FORWARD_PATH, false, null);
        try {
            dispatcher.setRequestPath((ServletRequest)springSecurityRequest, FORWARD_PATH);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IllegalStateException));
            return;
        }
        Assertions.fail();
    }

    @Test
    void forwardRequest_nullHandler_throwsIllegalStateException() throws InvalidRequestEventException {
        AwsProxyRequest proxyRequest = new AwsProxyRequestBuilder("/hello", "GET").build();
        HttpServletRequest servletRequest = requestReader.readRequest(proxyRequest, null, (Context)new MockLambdaContext(), ContainerConfig.defaultConfig());
        AwsProxyRequestDispatcher dispatcher = new AwsProxyRequestDispatcher(FORWARD_PATH, false, null);
        try {
            dispatcher.forward((ServletRequest)servletRequest, (ServletResponse)new AwsHttpServletResponse(servletRequest, new CountDownLatch(1)));
        }
        catch (ServletException e) {
            Assertions.fail((String)"Unexpected ServletException");
        }
        catch (IOException e) {
            Assertions.fail((String)"Unexpected IOException");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IllegalStateException));
            return;
        }
        Assertions.fail();
    }

    @Test
    void forwardRequest_committedResponse_throwsIllegalStateException() throws InvalidRequestEventException {
        AwsProxyRequest proxyRequest = new AwsProxyRequestBuilder("/hello", "GET").build();
        HttpServletRequest servletRequest = requestReader.readRequest(proxyRequest, null, (Context)new MockLambdaContext(), ContainerConfig.defaultConfig());
        AwsProxyRequestDispatcher dispatcher = new AwsProxyRequestDispatcher(FORWARD_PATH, false, this.mockLambdaHandler(null));
        AwsHttpServletResponse resp = new AwsHttpServletResponse(servletRequest, new CountDownLatch(1));
        try {
            resp.flushBuffer();
            dispatcher.forward((ServletRequest)servletRequest, (ServletResponse)resp);
        }
        catch (ServletException e) {
            Assertions.fail((String)"Unexpected ServletException");
        }
        catch (IOException e) {
            Assertions.fail((String)"Unexpected IOException");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IllegalStateException));
            return;
        }
        Assertions.fail();
    }

    @Test
    void forwardRequest_partiallyWrittenResponse_resetsBuffer() throws InvalidRequestEventException {
        AwsProxyRequest proxyRequest = new AwsProxyRequestBuilder("/hello", "GET").build();
        HttpServletRequest servletRequest = requestReader.readRequest(proxyRequest, null, (Context)new MockLambdaContext(), ContainerConfig.defaultConfig());
        AwsProxyRequestDispatcher dispatcher = new AwsProxyRequestDispatcher(FORWARD_PATH, false, this.mockLambdaHandler(null));
        AwsHttpServletResponse resp = new AwsHttpServletResponse(servletRequest, new CountDownLatch(1));
        try {
            resp.getOutputStream().write("this is a test write".getBytes());
            Assertions.assertEquals((Object)"this is a test write", (Object)new String(resp.getAwsResponseBodyBytes(), Charset.defaultCharset()));
            dispatcher.forward((ServletRequest)servletRequest, (ServletResponse)resp);
            Assertions.assertEquals((int)0, (int)resp.getAwsResponseBodyBytes().length);
        }
        catch (ServletException e) {
            Assertions.fail((String)"Unexpected ServletException");
        }
        catch (IOException e) {
            Assertions.fail((String)"Unexpected IOException");
        }
    }

    @Test
    void include_addsToResponse_appendsCorrectly() throws InvalidRequestEventException, IOException {
        String firstPart = "first";
        String secondPart = "second";
        AwsProxyRequest proxyRequest = new AwsProxyRequestBuilder("/hello", "GET").build();
        AwsProxyResponse resp = (AwsProxyResponse)this.mockLambdaHandler((req, res) -> {
            if (req.getAttribute("cnt") == null) {
                res.getOutputStream().write("first".getBytes());
                req.setAttribute("cnt", (Object)1);
                req.getRequestDispatcher("/includer").include((ServletRequest)req, (ServletResponse)res);
                res.setStatus(200);
                res.flushBuffer();
            } else {
                res.getOutputStream().write("second".getBytes());
            }
        }).proxy((Object)proxyRequest, (Context)new MockLambdaContext());
        Assertions.assertEquals((Object)"firstsecond", (Object)resp.getBody());
    }

    @Test
    void include_appendsNewHeader_cannotAppendNewHeaders() throws InvalidRequestEventException, IOException {
        String firstPart = "first";
        String secondPart = "second";
        String headerKey = "X-Custom-Header";
        AwsProxyRequest proxyRequest = new AwsProxyRequestBuilder("/hello", "GET").build();
        AwsProxyResponse resp = (AwsProxyResponse)this.mockLambdaHandler((req, res) -> {
            if (req.getAttribute("cnt") == null) {
                res.getOutputStream().write("first".getBytes());
                req.setAttribute("cnt", (Object)1);
                req.getRequestDispatcher("/includer").include((ServletRequest)req, (ServletResponse)res);
                res.setStatus(200);
                res.flushBuffer();
            } else {
                res.getOutputStream().write("second".getBytes());
                res.addHeader("X-Custom-Header", "value");
            }
        }).proxy((Object)proxyRequest, (Context)new MockLambdaContext());
        Assertions.assertEquals((Object)"firstsecond", (Object)resp.getBody());
        Assertions.assertFalse((boolean)resp.getMultiValueHeaders().containsKey((Object)"X-Custom-Header"));
    }

    private AwsLambdaServletContainerHandler<AwsProxyRequest, AwsProxyResponse, HttpServletRequest, AwsHttpServletResponse> mockLambdaHandler(final RequestHandler h) {
        return new AwsLambdaServletContainerHandler<AwsProxyRequest, AwsProxyResponse, HttpServletRequest, AwsHttpServletResponse>(AwsProxyRequest.class, AwsProxyResponse.class, (RequestReader)new AwsProxyHttpServletRequestReader(), (ResponseWriter)new AwsProxyHttpServletResponseWriter(), (SecurityContextWriter)new AwsProxySecurityContextWriter(), (ExceptionHandler)new AwsProxyExceptionHandler()){

            protected void doFilter(HttpServletRequest request, HttpServletResponse response, Servlet servlet) throws IOException, ServletException {
                if (h != null) {
                    h.handleRequest((AwsProxyHttpServletRequest)request, (AwsHttpServletResponse)response);
                }
            }

            protected AwsHttpServletResponse getContainerResponse(HttpServletRequest request, CountDownLatch latch) {
                return new AwsHttpServletResponse(request, latch);
            }

            protected void handleRequest(HttpServletRequest containerRequest, AwsHttpServletResponse containerResponse, Context lambdaContext) throws Exception {
                if (h != null) {
                    this.setServletContext((ServletContext)new AwsServletContext((AwsLambdaServletContainerHandler)this));
                    ((AwsHttpServletRequest)containerRequest).setServletContext(this.getServletContext());
                    h.handleRequest((AwsProxyHttpServletRequest)containerRequest, containerResponse);
                }
                containerResponse.flushBuffer();
            }

            public void initialize() throws ContainerInitializationException {
            }
        };
    }

    private static interface RequestHandler {
        public void handleRequest(AwsProxyHttpServletRequest var1, AwsHttpServletResponse var2) throws ServletException, IOException;
    }
}

