/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpApiV2ProxyHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletRequestWrapper;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletInputStream;
import com.amazonaws.serverless.proxy.internal.testutils.AwsProxyRequestBuilder;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.services.lambda.runtime.Context;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class AwsProxyHttpServletRequestTest {
    private String requestType;
    private static final String CUSTOM_HEADER_KEY = "X-Custom-Header";
    private static final String CUSTOM_HEADER_VALUE = "Custom-Header-Value";
    private static final String FORM_PARAM_NAME = "name";
    private static final String FORM_PARAM_NAME_VALUE = "Stef";
    private static final String FORM_PARAM_TEST = "test_cookie_param";
    private static final String QUERY_STRING_NAME_VALUE = "Bob";
    private static final String REQUEST_SCHEME_HTTP = "http";
    private static final String USER_AGENT = "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/102.0.5005.61 Safari/537.36";
    private static final String REFERER = "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/User-Agent/Firefox";
    private static ZonedDateTime REQUEST_DATE = ZonedDateTime.now();
    private static final AwsProxyRequestBuilder REQUEST_FORM_URLENCODED = new AwsProxyRequestBuilder("/hello", "POST").form("name", "Stef");
    private static final AwsProxyRequestBuilder REQUEST_INVALID_FORM_URLENCODED = new AwsProxyRequestBuilder("/hello", "GET").form("name", "Stef");
    private static final AwsProxyRequestBuilder REQUEST_FORM_URLENCODED_AND_QUERY = new AwsProxyRequestBuilder("/hello", "POST").form("name", "Stef").queryString("name", "Bob");
    private static final AwsProxyRequestBuilder REQUEST_SINGLE_COOKIE = new AwsProxyRequestBuilder("/hello", "GET").cookie("name", "Stef");
    private static final AwsProxyRequestBuilder REQUEST_MULTIPLE_COOKIES = new AwsProxyRequestBuilder("/hello", "GET").cookie("name", "Stef").cookie("test_cookie_param", "Stef");
    private static final AwsProxyRequestBuilder REQUEST_MALFORMED_COOKIE = new AwsProxyRequestBuilder("/hello", "GET").header("Cookie", "Bob");
    private static final AwsProxyRequestBuilder REQUEST_MULTIPLE_FORM_AND_QUERY = new AwsProxyRequestBuilder("/hello", "POST").form("name", "Stef").queryString("test_cookie_param", "Bob");
    private static final AwsProxyRequestBuilder REQUEST_USER_AGENT_REFERER = new AwsProxyRequestBuilder("/hello", "POST").userAgent("Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/102.0.5005.61 Safari/537.36").referer("https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/User-Agent/Firefox");
    private static final AwsProxyRequestBuilder REQUEST_WITH_DATE = new AwsProxyRequestBuilder("/hello", "GET").header("Date", AwsHttpServletRequest.dateFormatter.format(REQUEST_DATE));
    private static final AwsProxyRequestBuilder REQUEST_WITH_LOWERCASE_HEADER = new AwsProxyRequestBuilder("/hello", "POST").header("Content-Type".toLowerCase(Locale.getDefault()), "application/json");
    private static final AwsProxyRequestBuilder REQUEST_NULL_QUERY_STRING;
    private static final AwsProxyRequestBuilder REQUEST_QUERY;
    private static final AwsProxyRequestBuilder REQUEST_QUERY_EMPTY_VALUE;

    public void initAwsProxyHttpServletRequestTest(String type) {
        this.requestType = type;
    }

    public static Collection<Object> data() {
        return Arrays.asList("API_GW", "ALB", "HTTP_API", "WRAP");
    }

    private HttpServletRequest getRequest(AwsProxyRequestBuilder req, Context lambdaCtx, SecurityContext securityCtx) {
        switch (this.requestType) {
            case "API_GW": {
                return new AwsProxyHttpServletRequest(req.build(), lambdaCtx, securityCtx);
            }
            case "ALB": {
                return new AwsProxyHttpServletRequest(req.alb().build(), lambdaCtx, securityCtx);
            }
            case "HTTP_API": {
                return new AwsHttpApiV2ProxyHttpServletRequest(req.toHttpApiV2Request(), lambdaCtx, securityCtx, LambdaContainerHandler.getContainerConfig());
            }
            case "WRAP": {
                AwsProxyHttpServletRequest servletRequest = new AwsProxyHttpServletRequest(req.build(), lambdaCtx, securityCtx);
                return new AwsHttpServletRequestWrapper((HttpServletRequest)servletRequest, req.build().getPath());
            }
        }
        throw new RuntimeException("Unknown test variant: " + this.requestType);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void headers_getHeader_validRequest(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(this.getRequestWithHeaders(), null, null);
        Assertions.assertNotNull((Object)request.getHeader(CUSTOM_HEADER_KEY));
        Assertions.assertEquals((Object)CUSTOM_HEADER_VALUE, (Object)request.getHeader(CUSTOM_HEADER_KEY));
        Assertions.assertEquals((Object)"application/json", (Object)request.getContentType());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void headers_getRefererAndUserAgent_returnsContextValues(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        Assumptions.assumeFalse((boolean)"ALB".equals(this.requestType));
        HttpServletRequest request = this.getRequest(REQUEST_USER_AGENT_REFERER, null, null);
        Assertions.assertNotNull((Object)request.getHeader("Referer"));
        Assertions.assertEquals((Object)REFERER, (Object)request.getHeader("Referer"));
        Assertions.assertEquals((Object)REFERER, (Object)request.getHeader("referer"));
        Assertions.assertNotNull((Object)request.getHeader("User-Agent"));
        Assertions.assertEquals((Object)USER_AGENT, (Object)request.getHeader("User-Agent"));
        Assertions.assertEquals((Object)USER_AGENT, (Object)request.getHeader("user-agent"));
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void formParams_getParameter_validForm(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(REQUEST_FORM_URLENCODED, null, null);
        Assertions.assertNotNull((Object)request);
        Assertions.assertNotNull((Object)request.getParameter(FORM_PARAM_NAME));
        Assertions.assertEquals((Object)FORM_PARAM_NAME_VALUE, (Object)request.getParameter(FORM_PARAM_NAME));
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void formParams_getParameter_null(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(REQUEST_INVALID_FORM_URLENCODED, null, null);
        Assertions.assertNotNull((Object)request);
        Assertions.assertNull((Object)request.getParameter(FORM_PARAM_NAME));
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void formParams_getParameter_multipleParams(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(REQUEST_FORM_URLENCODED_AND_QUERY, null, null);
        Assertions.assertNotNull((Object)request);
        Assertions.assertEquals((int)2, (int)request.getParameterValues(FORM_PARAM_NAME).length);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void formParams_getParameter_queryStringPrecendence(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(REQUEST_FORM_URLENCODED_AND_QUERY, null, null);
        Assertions.assertNotNull((Object)request);
        Assertions.assertEquals((int)2, (int)request.getParameterValues(FORM_PARAM_NAME).length);
        Assertions.assertEquals((Object)QUERY_STRING_NAME_VALUE, (Object)request.getParameter(FORM_PARAM_NAME));
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void dateHeader_noDate_returnNegativeOne(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(REQUEST_FORM_URLENCODED_AND_QUERY, null, null);
        Assertions.assertNotNull((Object)request);
        Assertions.assertEquals((long)-1L, (long)request.getDateHeader("Date"));
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void dateHeader_correctDate_parseToCorrectLong(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(REQUEST_WITH_DATE, null, null);
        Assertions.assertNotNull((Object)request);
        String instantString = AwsHttpServletRequest.dateFormatter.format(REQUEST_DATE);
        Assertions.assertEquals((long)Instant.from(AwsHttpServletRequest.dateFormatter.parse(instantString)).toEpochMilli(), (long)request.getDateHeader("Date"));
        Assertions.assertEquals((long)-1L, (long)request.getDateHeader("If-Modified-Since"));
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void scheme_getScheme_https(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(REQUEST_FORM_URLENCODED, null, null);
        Assertions.assertNotNull((Object)request);
        Assertions.assertNotNull((Object)request.getScheme());
        Assertions.assertEquals((Object)"https", (Object)request.getScheme());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void scheme_getScheme_http(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(this.getRequestWithHeaders(), null, null);
        Assertions.assertNotNull((Object)request);
        Assertions.assertNotNull((Object)request.getScheme());
        Assertions.assertEquals((Object)REQUEST_SCHEME_HTTP, (Object)request.getScheme());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void cookie_getCookies_noCookies(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(this.getRequestWithHeaders(), null, null);
        Assertions.assertNotNull((Object)request);
        Assertions.assertNotNull((Object)request.getCookies());
        Assertions.assertEquals((int)0, (int)request.getCookies().length);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void cookie_getCookies_singleCookie(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(REQUEST_SINGLE_COOKIE, null, null);
        Assertions.assertNotNull((Object)request);
        Assertions.assertNotNull((Object)request.getCookies());
        Assertions.assertEquals((int)1, (int)request.getCookies().length);
        Assertions.assertEquals((Object)FORM_PARAM_NAME, (Object)request.getCookies()[0].getName());
        Assertions.assertEquals((Object)FORM_PARAM_NAME_VALUE, (Object)request.getCookies()[0].getValue());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void cookie_getCookies_multipleCookies(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(REQUEST_MULTIPLE_COOKIES, null, null);
        Assertions.assertNotNull((Object)request);
        Assertions.assertNotNull((Object)request.getCookies());
        Assertions.assertEquals((int)2, (int)request.getCookies().length);
        Assertions.assertEquals((Object)FORM_PARAM_NAME, (Object)request.getCookies()[0].getName());
        Assertions.assertEquals((Object)FORM_PARAM_NAME_VALUE, (Object)request.getCookies()[0].getValue());
        Assertions.assertEquals((Object)FORM_PARAM_TEST, (Object)request.getCookies()[1].getName());
        Assertions.assertEquals((Object)FORM_PARAM_NAME_VALUE, (Object)request.getCookies()[1].getValue());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void cookie_getCookies_emptyCookies(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(REQUEST_MALFORMED_COOKIE, null, null);
        Assertions.assertNotNull((Object)request);
        Assertions.assertNotNull((Object)request.getCookies());
        Assertions.assertEquals((int)0, (int)request.getCookies().length);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void queryParameters_getParameterMap_null(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(REQUEST_NULL_QUERY_STRING, null, null);
        Assertions.assertNotNull((Object)request);
        Assertions.assertEquals((int)0, (int)request.getParameterMap().size());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void queryParameters_getParameterMap_nonNull(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(REQUEST_QUERY, null, null);
        Assertions.assertNotNull((Object)request);
        Assertions.assertEquals((int)1, (int)request.getParameterMap().size());
        Assertions.assertEquals((Object)QUERY_STRING_NAME_VALUE, (Object)((String[])request.getParameterMap().get(FORM_PARAM_NAME))[0]);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void queryParameters_getParameterMap_nonNull_EmptyParamValue(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(REQUEST_QUERY_EMPTY_VALUE, null, null);
        Assertions.assertNotNull((Object)request);
        Assertions.assertEquals((int)1, (int)request.getParameterMap().size());
        Assertions.assertEquals((Object)"", (Object)((String[])request.getParameterMap().get(FORM_PARAM_NAME))[0]);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void queryParameters_getParameterNames_null(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(REQUEST_NULL_QUERY_STRING, null, null);
        ArrayList parameterNames = Collections.list(request.getParameterNames());
        Assertions.assertNotNull((Object)request);
        Assertions.assertEquals((int)0, (int)parameterNames.size());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void queryParameters_getParameterNames_notNull(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(REQUEST_QUERY, null, null);
        ArrayList parameterNames = Collections.list(request.getParameterNames());
        Assertions.assertNotNull((Object)request);
        Assertions.assertEquals((int)1, (int)parameterNames.size());
        Assertions.assertTrue((boolean)parameterNames.contains(FORM_PARAM_NAME));
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void queryParameter_getParameterMap_avoidDuplicationOnMultipleCalls(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(REQUEST_MULTIPLE_FORM_AND_QUERY, null, null);
        Map params = request.getParameterMap();
        Assertions.assertNotNull((Object)params);
        Assertions.assertEquals((int)2, (int)params.size());
        Assertions.assertNotNull(params.get(FORM_PARAM_NAME));
        Assertions.assertEquals((int)1, (int)((String[])params.get(FORM_PARAM_NAME)).length);
        Assertions.assertNotNull(params.get(FORM_PARAM_TEST));
        Assertions.assertEquals((int)1, (int)((String[])params.get(FORM_PARAM_TEST)).length);
        params = request.getParameterMap();
        Assertions.assertNotNull((Object)params);
        Assertions.assertEquals((int)2, (int)params.size());
        Assertions.assertNotNull(params.get(FORM_PARAM_NAME));
        Assertions.assertEquals((int)1, (int)((String[])params.get(FORM_PARAM_NAME)).length);
        Assertions.assertNotNull(params.get(FORM_PARAM_TEST));
        Assertions.assertEquals((int)1, (int)((String[])params.get(FORM_PARAM_TEST)).length);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void charEncoding_getEncoding_expectNoEncodingWithoutContentType(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(REQUEST_SINGLE_COOKIE, null, null);
        try {
            request.setCharacterEncoding(StandardCharsets.UTF_8.name());
            Assertions.assertNull((Object)request.getCharacterEncoding());
            Assertions.assertNull((Object)request.getContentType());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            Assertions.fail((String)"Unsupported encoding");
        }
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void charEncoding_getEncoding_expectContentTypeOnly(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(this.getRequestWithHeaders(), null, null);
        Assertions.assertNull((Object)request.getCharacterEncoding());
        Assertions.assertEquals((Object)"application/json", (Object)request.getContentType());
        try {
            request.setCharacterEncoding(StandardCharsets.UTF_8.name());
            String newHeaderValue = "application/json; charset=" + StandardCharsets.UTF_8.name();
            Assertions.assertEquals((Object)newHeaderValue, (Object)request.getHeader("Content-Type"));
            Assertions.assertEquals((Object)newHeaderValue, (Object)request.getContentType());
            Assertions.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)request.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            Assertions.fail((String)"Unsupported encoding");
        }
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void charEncoding_addCharEncodingTwice_expectSingleMediaTypeAndEncoding(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(this.getRequestWithHeaders(), null, null);
        Assertions.assertNull((Object)request.getCharacterEncoding());
        Assertions.assertEquals((Object)"application/json", (Object)request.getContentType());
        try {
            request.setCharacterEncoding(StandardCharsets.UTF_8.name());
            String newHeaderValue = "application/json; charset=" + StandardCharsets.UTF_8.name();
            Assertions.assertEquals((Object)newHeaderValue, (Object)request.getHeader("Content-Type"));
            Assertions.assertEquals((Object)newHeaderValue, (Object)request.getContentType());
            Assertions.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)request.getCharacterEncoding());
            request.setCharacterEncoding(StandardCharsets.ISO_8859_1.name());
            newHeaderValue = "application/json; charset=" + StandardCharsets.ISO_8859_1.name();
            Assertions.assertEquals((Object)newHeaderValue, (Object)request.getHeader("Content-Type"));
            Assertions.assertEquals((Object)newHeaderValue, (Object)request.getContentType());
            Assertions.assertEquals((Object)StandardCharsets.ISO_8859_1.name(), (Object)request.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            Assertions.fail((String)"Unsupported encoding");
        }
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void contentType_lowerCaseHeaderKey_expectUpdatedMediaType(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest request = this.getRequest(REQUEST_WITH_LOWERCASE_HEADER, null, null);
        try {
            request.setCharacterEncoding(StandardCharsets.UTF_8.name());
            String newHeaderValue = "application/json; charset=" + StandardCharsets.UTF_8.name();
            Assertions.assertEquals((Object)newHeaderValue, (Object)request.getHeader("Content-Type"));
            Assertions.assertEquals((Object)newHeaderValue, (Object)request.getContentType());
            Assertions.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)request.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            Assertions.fail((String)"Unsupported encoding");
        }
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void contentType_duplicateCase_expectSingleContentTypeHeader(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        AwsProxyRequestBuilder proxyRequest = this.getRequestWithHeaders();
        HttpServletRequest request = this.getRequest(proxyRequest, null, null);
        try {
            request.setCharacterEncoding(StandardCharsets.ISO_8859_1.name());
            Assertions.assertNotNull((Object)request.getHeader("Content-Type"));
            Assertions.assertNotNull((Object)request.getHeader("Content-Type".toLowerCase(Locale.getDefault())));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            Assertions.fail((String)"Unsupported encoding");
        }
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void requestURL_getUrl_expectHttpSchemaAndLocalhostForLocalTesting(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        Assumptions.assumeFalse((boolean)"ALB".equals(this.requestType));
        AwsProxyRequestBuilder req = this.getRequestWithHeaders();
        req.apiId("test-id");
        LambdaContainerHandler.getContainerConfig().enableLocalhost();
        HttpServletRequest servletRequest = this.getRequest(req, null, null);
        String requestUrl = servletRequest.getRequestURL().toString();
        Assertions.assertTrue((boolean)requestUrl.contains("http://"));
        Assertions.assertTrue((boolean)requestUrl.contains("test-id.execute-api."));
        Assertions.assertTrue((boolean)requestUrl.endsWith(".com/hello"));
        req.header("Host", "localhost");
        servletRequest = this.getRequest(req, null, null);
        requestUrl = servletRequest.getRequestURL().toString();
        Assertions.assertTrue((boolean)requestUrl.contains("http://localhost"));
        Assertions.assertTrue((boolean)requestUrl.endsWith("localhost/hello"));
        LambdaContainerHandler.getContainerConfig().getCustomDomainNames().remove("localhost");
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void requestURL_getUrlWithCustomBasePath_expectCustomBasePath(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        AwsProxyRequestBuilder req = this.getRequestWithHeaders();
        LambdaContainerHandler.getContainerConfig().setServiceBasePath("test");
        HttpServletRequest servletRequest = this.getRequest(req, null, null);
        String requestUrl = servletRequest.getRequestURL().toString();
        Assertions.assertTrue((boolean)requestUrl.contains("/test/hello"));
        LambdaContainerHandler.getContainerConfig().setServiceBasePath(null);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void requestURL_getUrlWithContextPath_expectStageAsContextPath(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        Assumptions.assumeFalse((boolean)"ALB".equals(this.requestType));
        AwsProxyRequestBuilder req = this.getRequestWithHeaders();
        req.stage("test-stage");
        LambdaContainerHandler.getContainerConfig().setUseStageAsServletContext(true);
        HttpServletRequest servletRequest = this.getRequest(req, null, null);
        String requestUrl = servletRequest.getRequestURL().toString();
        System.out.println(requestUrl);
        Assertions.assertTrue((boolean)requestUrl.contains("/test-stage/"));
        LambdaContainerHandler.getContainerConfig().setUseStageAsServletContext(false);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void getLocales_emptyAcceptHeader_expectDefaultLocale(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        AwsProxyRequestBuilder req = this.getRequestWithHeaders();
        HttpServletRequest servletRequest = this.getRequest(req, null, null);
        Enumeration locales = servletRequest.getLocales();
        int localesNo = 0;
        while (locales.hasMoreElements()) {
            Locale defaultLocale = (Locale)locales.nextElement();
            Assertions.assertEquals((Object)Locale.getDefault(), (Object)defaultLocale);
            ++localesNo;
        }
        Assertions.assertEquals((int)1, (int)localesNo);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void getLocales_validAcceptHeader_expectSingleLocale(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        AwsProxyRequestBuilder req = this.getRequestWithHeaders();
        req.header("Accept-Language", "fr-CH");
        HttpServletRequest servletRequest = this.getRequest(req, null, null);
        Enumeration locales = servletRequest.getLocales();
        int localesNo = 0;
        while (locales.hasMoreElements()) {
            Locale defaultLocale = (Locale)locales.nextElement();
            Assertions.assertEquals((Object)new Locale("fr", "CH"), (Object)defaultLocale);
            ++localesNo;
        }
        Assertions.assertEquals((int)1, (int)localesNo);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void getLocales_validAcceptHeaderMultipleLocales_expectFullLocaleList(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        AwsProxyRequestBuilder req = this.getRequestWithHeaders();
        req.header("Accept-Language", "fr-CA, fr;q=0.9, en;q=0.8, de;q=0.7, *;q=0.5");
        HttpServletRequest servletRequest = this.getRequest(req, null, null);
        Enumeration locales = servletRequest.getLocales();
        ArrayList<Locale> localesList = new ArrayList<Locale>();
        while (locales.hasMoreElements()) {
            localesList.add((Locale)locales.nextElement());
        }
        Assertions.assertEquals((int)5, (int)localesList.size());
        Assertions.assertEquals((Object)Locale.CANADA_FRENCH, localesList.get(0));
        Assertions.assertEquals((Object)Locale.FRENCH, localesList.get(1));
        Assertions.assertEquals((Object)Locale.ENGLISH, localesList.get(2));
        Assertions.assertEquals((Object)new Locale("de"), localesList.get(3));
        Assertions.assertEquals((Object)new Locale("*"), localesList.get(4));
        Assertions.assertNotNull((Object)servletRequest.getLocale());
        Assertions.assertEquals((Object)Locale.CANADA_FRENCH, (Object)servletRequest.getLocale());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void getLocales_validAcceptHeaderMultipleLocales_expectFullLocaleListOrdered(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        AwsProxyRequestBuilder req = this.getRequestWithHeaders();
        req.header("Accept-Language", "fr-CA, en;q=0.8, de;q=0.7, *;q=0.5, fr;q=0.9");
        HttpServletRequest servletRequest = this.getRequest(req, null, null);
        Enumeration locales = servletRequest.getLocales();
        ArrayList<Locale> localesList = new ArrayList<Locale>();
        while (locales.hasMoreElements()) {
            localesList.add((Locale)locales.nextElement());
        }
        Assertions.assertEquals((int)5, (int)localesList.size());
        Assertions.assertEquals((Object)Locale.CANADA_FRENCH, localesList.get(0));
        Assertions.assertEquals((Object)Locale.FRENCH, localesList.get(1));
        Assertions.assertEquals((Object)Locale.ENGLISH, localesList.get(2));
        Assertions.assertEquals((Object)new Locale("de"), localesList.get(3));
        Assertions.assertEquals((Object)new Locale("*"), localesList.get(4));
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void nullQueryString_expectNoExceptions(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        AwsProxyRequestBuilder req = new AwsProxyRequestBuilder("/hello", "GET");
        HttpServletRequest servletReq = this.getRequest(req, null, null);
        Assertions.assertNull((Object)servletReq.getQueryString());
        Assertions.assertEquals((int)0, (int)servletReq.getParameterMap().size());
        Assertions.assertFalse((boolean)servletReq.getParameterNames().hasMoreElements());
        Assertions.assertNull((Object)servletReq.getParameter("param"));
        Assertions.assertNull((Object)servletReq.getParameterValues("param"));
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void inputStream_emptyBody_expectNullInputStream(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        AwsProxyRequestBuilder proxyReq = this.getRequestWithHeaders();
        Assertions.assertNull((Object)proxyReq.build().getBody());
        HttpServletRequest req = this.getRequest(proxyReq, null, null);
        try {
            ServletInputStream is = req.getInputStream();
            Assertions.assertTrue((is.getClass() == AwsServletInputStream.class ? 1 : 0) != 0);
            Assertions.assertEquals((int)0, (int)is.available());
        }
        catch (IOException e) {
            Assertions.fail((String)"Could not get input stream");
        }
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void getHeaders_emptyHeaders_expectEmptyEnumeration(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        AwsProxyRequestBuilder proxyReq = new AwsProxyRequestBuilder("/hello", "GET");
        HttpServletRequest req = this.getRequest(proxyReq, null, null);
        Assertions.assertFalse((boolean)req.getHeaders("param").hasMoreElements());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void getServerPort_defaultPort_expect443(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        HttpServletRequest req = this.getRequest(this.getRequestWithHeaders(), null, null);
        Assertions.assertEquals((int)443, (int)req.getServerPort());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void getServerPort_customPortFromHeader_expectCustomPort(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        AwsProxyRequestBuilder proxyReq = this.getRequestWithHeaders();
        proxyReq.header("X-Forwarded-Port", "80");
        HttpServletRequest req = this.getRequest(proxyReq, null, null);
        Assertions.assertEquals((int)80, (int)req.getServerPort());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void getServerPort_invalidCustomPortFromHeader_expectDefaultPort(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        AwsProxyRequestBuilder proxyReq = this.getRequestWithHeaders();
        proxyReq.header("X-Forwarded-Port", "7200");
        HttpServletRequest req = this.getRequest(proxyReq, null, null);
        Assertions.assertEquals((int)443, (int)req.getServerPort());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void serverName_emptyHeaders_doesNotThrowNullPointer(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        AwsProxyRequestBuilder proxyReq = new AwsProxyRequestBuilder("/test", "GET");
        proxyReq.multiValueHeaders(null);
        HttpServletRequest servletReq = this.getRequest(proxyReq, null, null);
        String serverName = servletReq.getServerName();
        Assertions.assertTrue((boolean)serverName.startsWith("null.execute-api"));
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void serverName_hostHeader_returnsHostHeaderOnly(String type) {
        this.initAwsProxyHttpServletRequestTest(type);
        AwsProxyRequestBuilder proxyReq = new AwsProxyRequestBuilder("/test", "GET").header("Host", "testapi.com");
        LambdaContainerHandler.getContainerConfig().addCustomDomain("testapi.com");
        HttpServletRequest servletReq = this.getRequest(proxyReq, null, null);
        String serverName = servletReq.getServerName();
        Assertions.assertEquals((Object)"testapi.com", (Object)serverName);
    }

    @Test
    void serverName_albHostHeader_returnsHostHeader() {
        this.initAwsProxyHttpServletRequestTest("ALB");
        AwsProxyRequestBuilder proxyReq = new AwsProxyRequestBuilder("/test", "GET").header("Host", "testapi.us-east-1.elb.amazonaws.com");
        HttpServletRequest servletReq = this.getRequest(proxyReq, null, null);
        String serverName = servletReq.getServerName();
        Assertions.assertEquals((Object)"testapi.us-east-1.elb.amazonaws.com", (Object)serverName);
    }

    private AwsProxyRequestBuilder getRequestWithHeaders() {
        return new AwsProxyRequestBuilder("/hello", "GET").header(CUSTOM_HEADER_KEY, CUSTOM_HEADER_VALUE).header("Content-Type", "application/json").header("CloudFront-Forwarded-Proto", REQUEST_SCHEME_HTTP);
    }

    static {
        AwsProxyRequest awsProxyRequest = new AwsProxyRequestBuilder("/hello", "GET").build();
        awsProxyRequest.setMultiValueQueryStringParameters(null);
        REQUEST_NULL_QUERY_STRING = new AwsProxyRequestBuilder(awsProxyRequest);
        REQUEST_QUERY = new AwsProxyRequestBuilder("/hello", "POST").queryString(FORM_PARAM_NAME, QUERY_STRING_NAME_VALUE);
        REQUEST_QUERY_EMPTY_VALUE = new AwsProxyRequestBuilder("/hello", "POST").queryString(FORM_PARAM_NAME, "");
    }
}

