/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpSession;
import java.time.Instant;
import java.util.Enumeration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AwsHttpSessionTest {
    @Test
    void new_withNullId_throwsException() {
        try {
            AwsHttpSession awsHttpSession = new AwsHttpSession(null);
        }
        catch (RuntimeException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("cannot be null"));
            return;
        }
        Assertions.fail((String)"Did not throw exception with null ID");
    }

    @Test
    void new_withValidId_setsIdCorrectly() {
        AwsHttpSession session = new AwsHttpSession("id");
        Assertions.assertEquals((Object)"id", (Object)session.getId());
    }

    @Test
    void new_creationTimePopulatedCorrectly() {
        AwsHttpSession session = new AwsHttpSession("id");
        Assertions.assertTrue((session.getCreationTime() > Instant.now().getEpochSecond() - 1L ? 1 : 0) != 0);
        Assertions.assertEquals((int)1800, (int)session.getMaxInactiveInterval());
        Assertions.assertEquals((long)session.getLastAccessedTime(), (long)session.getCreationTime());
    }

    @Test
    void attributes_dataStoredCorrectly() throws InterruptedException {
        AwsHttpSession sess = new AwsHttpSession("id");
        sess.setAttribute("test", (Object)"test");
        sess.setAttribute("test2", (Object)"test2");
        Enumeration attrs = sess.getAttributeNames();
        int attrsCnt = 0;
        while (attrs.hasMoreElements()) {
            attrs.nextElement();
            ++attrsCnt;
        }
        Assertions.assertEquals((int)2, (int)attrsCnt);
        Assertions.assertEquals((Object)"test", (Object)sess.getAttribute("test"));
        sess.removeAttribute("test2");
        attrs = sess.getAttributeNames();
        attrsCnt = 0;
        while (attrs.hasMoreElements()) {
            attrs.nextElement();
            ++attrsCnt;
        }
        Assertions.assertEquals((int)1, (int)attrsCnt);
        Thread.sleep(1000L);
        sess.setAttribute("test3", (Object)"test3");
        Assertions.assertTrue((sess.getLastAccessedTime() > sess.getCreationTime() ? 1 : 0) != 0);
    }

    @Test
    void validSession_expectCorrectValidationOrInvalidation() throws InterruptedException {
        AwsHttpSession sess = new AwsHttpSession("id");
        Assertions.assertTrue((boolean)sess.isValid());
        Assertions.assertTrue((boolean)sess.isNew());
        Thread.sleep(1000L);
        sess.setAttribute("test", (Object)"test");
        Assertions.assertFalse((boolean)sess.isNew());
        sess.invalidate();
        Assertions.assertFalse((boolean)sess.isValid());
        Assertions.assertNull((Object)sess.getAttribute("test"));
    }
}

