/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.testutils.AwsProxyRequestBuilder;
import com.amazonaws.serverless.proxy.internal.testutils.MockLambdaContext;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import com.amazonaws.serverless.proxy.model.MultiValuedTreeMap;
import com.amazonaws.services.lambda.runtime.Context;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AwsHttpServletRequestTest {
    private static final AwsProxyRequest contentTypeRequest = new AwsProxyRequestBuilder("/test", "GET").header("Content-Type", "application/xml; charset=utf-8").build();
    private static final AwsProxyRequest validCookieRequest = new AwsProxyRequestBuilder("/cookie", "GET").header("Cookie", "yummy_cookie=choco; tasty_cookie=strawberry").build();
    private static final AwsProxyRequest complexAcceptHeader = new AwsProxyRequestBuilder("/accept", "GET").header("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8").build();
    private static final AwsProxyRequest queryString = new AwsProxyRequestBuilder("/test", "GET").queryString("one", "two").queryString("three", "four").build();
    private static final AwsProxyRequest queryStringNullValue = new AwsProxyRequestBuilder("/test", "GET").queryString("one", "two").queryString("three", null).build();
    private static final AwsProxyRequest encodedQueryString = new AwsProxyRequestBuilder("/test", "GET").queryString("one", "two").queryString("json", "{\"name\":\"faisal\"}").build();
    private static final AwsProxyRequest multipleParams = new AwsProxyRequestBuilder("/test", "GET").queryString("one", "two").queryString("one", "three").queryString("json", "{\"name\":\"faisal\"}").build();
    private static final AwsProxyRequest formEncodedAndQueryString = new AwsProxyRequestBuilder("/test", "POST").queryString("one", "two").queryString("one", "three").queryString("five", "six").form("one", "four").form("seven", "eight").build();
    private static final AwsProxyRequest differentCasing = new AwsProxyRequestBuilder("/test", "POST").queryString("one", "two").queryString("one", "three").queryString("ONE", "four").build();
    private static final MockLambdaContext mockContext = new MockLambdaContext();
    private static ContainerConfig config = ContainerConfig.defaultConfig();

    @Test
    void headers_parseHeaderValue_multiValue() {
        AwsProxyHttpServletRequest request = new AwsProxyHttpServletRequest(contentTypeRequest, (Context)mockContext, null, config);
        List values = request.parseHeaderValue(request.getHeader("content-type"));
        Assertions.assertEquals((int)2, (int)values.size());
        Assertions.assertEquals((Object)"application/xml", (Object)((AwsHttpServletRequest.HeaderValue)values.get(0)).getValue());
        Assertions.assertNull((Object)((AwsHttpServletRequest.HeaderValue)values.get(0)).getKey());
        Assertions.assertEquals((Object)"charset", (Object)((AwsHttpServletRequest.HeaderValue)values.get(1)).getKey());
        Assertions.assertEquals((Object)"utf-8", (Object)((AwsHttpServletRequest.HeaderValue)values.get(1)).getValue());
    }

    @Test
    void headers_parseHeaderValue_validMultipleCookie() {
        AwsProxyHttpServletRequest request = new AwsProxyHttpServletRequest(validCookieRequest, (Context)mockContext, null, config);
        List values = request.parseHeaderValue(request.getHeader("Cookie"), ";", ",");
        Assertions.assertEquals((int)2, (int)values.size());
        Assertions.assertEquals((Object)"yummy_cookie", (Object)((AwsHttpServletRequest.HeaderValue)values.get(0)).getKey());
        Assertions.assertEquals((Object)"choco", (Object)((AwsHttpServletRequest.HeaderValue)values.get(0)).getValue());
        Assertions.assertEquals((Object)"tasty_cookie", (Object)((AwsHttpServletRequest.HeaderValue)values.get(1)).getKey());
        Assertions.assertEquals((Object)"strawberry", (Object)((AwsHttpServletRequest.HeaderValue)values.get(1)).getValue());
    }

    @Test
    void headers_parseHeaderValue_complexAccept() {
        AwsProxyHttpServletRequest request = new AwsProxyHttpServletRequest(complexAcceptHeader, (Context)mockContext, null, config);
        List values = request.parseHeaderValue(request.getHeader("Accept"), ",", ";");
        Assertions.assertEquals((int)4, (int)values.size());
    }

    @Test
    void headers_parseHeaderValue_encodedContentWithEquals() {
        AwsProxyHttpServletRequest context = new AwsProxyHttpServletRequest(null, null, null);
        String value = Base64.getUrlEncoder().encodeToString("a".getBytes());
        List result = context.parseHeaderValue(value);
        Assertions.assertTrue((result.size() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"YQ==", (Object)((AwsHttpServletRequest.HeaderValue)result.get(0)).getValue());
    }

    @Test
    void headers_parseHeaderValue_base64EncodedCookieValue() {
        String value = Base64.getUrlEncoder().encodeToString("a".getBytes());
        String cookieValue = "jwt=" + value + "; secondValue=second";
        AwsProxyRequest req = new AwsProxyRequestBuilder("/test", "GET").header("Cookie", cookieValue).build();
        AwsProxyHttpServletRequest context = new AwsProxyHttpServletRequest(req, null, null);
        Cookie[] cookies = context.getCookies();
        Assertions.assertEquals((int)2, (int)cookies.length);
        Assertions.assertEquals((Object)"jwt", (Object)cookies[0].getName());
        Assertions.assertEquals((Object)value, (Object)cookies[0].getValue());
    }

    @Test
    void headers_parseHeaderValue_cookieWithSeparatorInValue() {
        String cookieValue = "jwt==test; secondValue=second";
        AwsProxyRequest req = new AwsProxyRequestBuilder("/test", "GET").header("Cookie", cookieValue).build();
        AwsProxyHttpServletRequest context = new AwsProxyHttpServletRequest(req, null, null);
        Cookie[] cookies = context.getCookies();
        Assertions.assertEquals((int)2, (int)cookies.length);
        Assertions.assertEquals((Object)"jwt", (Object)cookies[0].getName());
        Assertions.assertEquals((Object)"=test", (Object)cookies[0].getValue());
    }

    @Test
    void headers_parseHeaderValue_headerWithPaddingButNotBase64Encoded() {
        AwsProxyHttpServletRequest context = new AwsProxyHttpServletRequest(null, null, null);
        List result = context.parseHeaderValue("hello=");
        Assertions.assertTrue((result.size() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"hello", (Object)((AwsHttpServletRequest.HeaderValue)result.get(0)).getKey());
        Assertions.assertNull((Object)((AwsHttpServletRequest.HeaderValue)result.get(0)).getValue());
    }

    @Test
    void queryString_generateQueryString_validQuery() {
        AwsProxyHttpServletRequest request = new AwsProxyHttpServletRequest(queryString, (Context)mockContext, null, config);
        String parsedString = null;
        try {
            parsedString = request.generateQueryString(request.getAwsProxyRequest().getMultiValueQueryStringParameters(), true, config.getUriEncoding());
        }
        catch (ServletException e) {
            e.printStackTrace();
            Assertions.fail((String)"Could not generate query string");
        }
        Assertions.assertTrue((boolean)parsedString.contains("one=two"));
        Assertions.assertTrue((boolean)parsedString.contains("three=four"));
        Assertions.assertTrue((parsedString.contains("&") && parsedString.indexOf("&") > 0 && parsedString.indexOf("&") < parsedString.length() ? 1 : 0) != 0);
    }

    @Test
    void queryString_generateQueryString_nullParameterIsEmpty() {
        AwsProxyHttpServletRequest request = new AwsProxyHttpServletRequest(queryStringNullValue, (Context)mockContext, null, config);
        String parsedString = null;
        try {
            parsedString = request.generateQueryString(request.getAwsProxyRequest().getMultiValueQueryStringParameters(), true, config.getUriEncoding());
        }
        catch (ServletException e) {
            e.printStackTrace();
            Assertions.fail((String)"Could not generate query string");
        }
        Assertions.assertTrue((boolean)parsedString.endsWith("three="));
    }

    @Test
    void queryStringWithEncodedParams_generateQueryString_validQuery() {
        AwsProxyHttpServletRequest request = new AwsProxyHttpServletRequest(encodedQueryString, (Context)mockContext, null, config);
        String parsedString = null;
        try {
            parsedString = request.generateQueryString(request.getAwsProxyRequest().getMultiValueQueryStringParameters(), true, config.getUriEncoding());
        }
        catch (ServletException e) {
            e.printStackTrace();
            Assertions.fail((String)"Could not generate query string");
        }
        Assertions.assertTrue((boolean)parsedString.contains("one=two"));
        Assertions.assertTrue((boolean)parsedString.contains("json=%7B%22name%22%3A%22faisal%22%7D"));
        Assertions.assertTrue((parsedString.contains("&") && parsedString.indexOf("&") > 0 && parsedString.indexOf("&") < parsedString.length() ? 1 : 0) != 0);
    }

    @Test
    void queryStringWithMultipleValues_generateQueryString_validQuery() {
        AwsProxyHttpServletRequest request = new AwsProxyHttpServletRequest(multipleParams, (Context)mockContext, null, config);
        String parsedString = null;
        try {
            parsedString = request.generateQueryString(request.getAwsProxyRequest().getMultiValueQueryStringParameters(), true, config.getUriEncoding());
        }
        catch (ServletException e) {
            e.printStackTrace();
            Assertions.fail((String)"Could not generate query string");
        }
        Assertions.assertTrue((boolean)parsedString.contains("one=two"));
        Assertions.assertTrue((boolean)parsedString.contains("one=three"));
        Assertions.assertTrue((boolean)parsedString.contains("json=%7B%22name%22%3A%22faisal%22%7D"));
        Assertions.assertTrue((parsedString.contains("&") && parsedString.indexOf("&") > 0 && parsedString.indexOf("&") < parsedString.length() ? 1 : 0) != 0);
    }

    @Test
    void parameterMap_generateParameterMap_validQuery() {
        AwsProxyHttpServletRequest request = new AwsProxyHttpServletRequest(queryString, (Context)mockContext, null, config);
        Map paramMap = null;
        try {
            paramMap = request.generateParameterMap(request.getAwsProxyRequest().getMultiValueQueryStringParameters(), config);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)"Could not generate parameter map");
        }
        Assertions.assertArrayEquals((Object[])new String[]{"two"}, (Object[])((Object[])paramMap.get("one")));
        Assertions.assertArrayEquals((Object[])new String[]{"four"}, (Object[])((Object[])paramMap.get("three")));
        Assertions.assertTrue((paramMap.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    void parameterMap_generateParameterMap_nullParameter() {
        AwsProxyHttpServletRequest request = new AwsProxyHttpServletRequest(queryStringNullValue, (Context)mockContext, null, config);
        Map paramMap = null;
        try {
            paramMap = request.generateParameterMap(request.getAwsProxyRequest().getMultiValueQueryStringParameters(), config);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)"Could not generate parameter map");
        }
        Assertions.assertArrayEquals((Object[])new String[]{"two"}, (Object[])((Object[])paramMap.get("one")));
        Assertions.assertArrayEquals((Object[])new String[]{null}, (Object[])((Object[])paramMap.get("three")));
        Assertions.assertTrue((paramMap.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    void parameterMapWithEncodedParams_generateParameterMap_validQuery() {
        AwsProxyHttpServletRequest request = new AwsProxyHttpServletRequest(encodedQueryString, (Context)mockContext, null, config);
        Map paramMap = null;
        try {
            paramMap = request.generateParameterMap(request.getAwsProxyRequest().getMultiValueQueryStringParameters(), config);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)"Could not generate parameter map");
        }
        Assertions.assertArrayEquals((Object[])new String[]{"two"}, (Object[])((Object[])paramMap.get("one")));
        Assertions.assertArrayEquals((Object[])new String[]{"{\"name\":\"faisal\"}"}, (Object[])((Object[])paramMap.get("json")));
        Assertions.assertTrue((paramMap.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    void parameterMapWithMultipleValues_generateParameterMap_validQuery() {
        AwsProxyHttpServletRequest request = new AwsProxyHttpServletRequest(multipleParams, (Context)mockContext, null, config);
        Map paramMap = null;
        try {
            paramMap = request.generateParameterMap(request.getAwsProxyRequest().getMultiValueQueryStringParameters(), config);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)"Could not generate parameter map");
        }
        Assertions.assertArrayEquals((Object[])new String[]{"two", "three"}, (Object[])((Object[])paramMap.get("one")));
        Assertions.assertArrayEquals((Object[])new String[]{"{\"name\":\"faisal\"}"}, (Object[])((Object[])paramMap.get("json")));
        Assertions.assertTrue((paramMap.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    void parameterMap_generateParameterMap_formEncodedAndQueryString() {
        AwsProxyHttpServletRequest request = new AwsProxyHttpServletRequest(formEncodedAndQueryString, (Context)mockContext, null, config);
        Map paramMap = null;
        try {
            paramMap = request.generateParameterMap(request.getAwsProxyRequest().getMultiValueQueryStringParameters(), config);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)"Could not generate parameter map");
        }
        Assertions.assertArrayEquals((Object[])new String[]{"four", "two", "three"}, (Object[])((Object[])paramMap.get("one")));
        Assertions.assertArrayEquals((Object[])new String[]{"six"}, (Object[])((Object[])paramMap.get("five")));
        Assertions.assertArrayEquals((Object[])new String[]{"eight"}, (Object[])((Object[])paramMap.get("seven")));
        Assertions.assertTrue((paramMap.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    void parameterMap_generateParameterMap_differentCasing() {
        AwsProxyHttpServletRequest request = new AwsProxyHttpServletRequest(differentCasing, (Context)mockContext, null, config);
        Map paramMap = null;
        try {
            paramMap = request.generateParameterMap(request.getAwsProxyRequest().getMultiValueQueryStringParameters(), config);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)"Could not generate parameter map");
        }
        Assertions.assertArrayEquals((Object[])((Object[])paramMap.get("one")), (Object[])((Object[])paramMap.get("ONE")));
        Assertions.assertTrue((paramMap.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    void queryParamValues_getQueryParamValues() {
        AwsProxyHttpServletRequest request = new AwsProxyHttpServletRequest(new AwsProxyRequest(), (Context)mockContext, null);
        MultiValuedTreeMap map = new MultiValuedTreeMap();
        map.add((Object)"test", (Object)"test");
        map.add((Object)"test", (Object)"test2");
        Object[] result1 = request.getQueryParamValues(map, "test", true);
        Assertions.assertArrayEquals((Object[])new String[]{"test", "test2"}, (Object[])result1);
        String[] result2 = request.getQueryParamValues(map, "TEST", true);
        Assertions.assertNull((Object)result2);
    }

    @Test
    void queryParamValues_getQueryParamValues_caseInsensitive() {
        AwsProxyHttpServletRequest request = new AwsProxyHttpServletRequest(new AwsProxyRequest(), (Context)mockContext, null);
        MultiValuedTreeMap map = new MultiValuedTreeMap();
        map.add((Object)"test", (Object)"test");
        map.add((Object)"test", (Object)"test2");
        Object[] result1 = request.getQueryParamValues(map, "test", false);
        Assertions.assertArrayEquals((Object[])new String[]{"test", "test2"}, (Object[])result1);
        Object[] result2 = request.getQueryParamValues(map, "TEST", false);
        Assertions.assertArrayEquals((Object[])new String[]{"test", "test2"}, (Object[])result2);
    }
}

