/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.servlet.AwsFilterChainManager;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletContext;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletRegistration;
import com.amazonaws.serverless.proxy.internal.servlet.FilterChainHolder;
import com.amazonaws.serverless.proxy.internal.servlet.FilterChainManager;
import com.amazonaws.serverless.proxy.internal.testutils.AwsProxyRequestBuilder;
import com.amazonaws.serverless.proxy.internal.testutils.MockLambdaContext;
import com.amazonaws.serverless.proxy.internal.testutils.MockServlet;
import com.amazonaws.services.lambda.runtime.Context;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.EnumSet;
import java.util.concurrent.CountDownLatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsFilterChainManagerTest {
    private static final String SERVLET1_NAME = "Servlet 1";
    private static final String SERVLET2_NAME = "Servlet 2";
    private static final String REQUEST_CUSTOM_ATTRIBUTE_NAME = "X-Custom-Attribute";
    private static final String REQUEST_CUSTOM_ATTRIBUTE_VALUE = "CustomAttrValue";
    private static AwsFilterChainManager chainManager;
    private static Context lambdaContext;
    private static ServletContext servletContext;
    private Logger log = LoggerFactory.getLogger(AwsFilterChainManagerTest.class);

    @BeforeAll
    public static void setUp() {
        servletContext = new AwsServletContext(null);
        FilterRegistration.Dynamic reg = servletContext.addFilter("Filter1", (Filter)new MockFilter());
        reg.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/first/second"});
        FilterRegistration.Dynamic reg2 = servletContext.addFilter("Filter2", (Filter)new MockFilter());
        reg2.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/second/*"});
        FilterRegistration.Dynamic reg3 = servletContext.addFilter("Filter3", (Filter)new MockFilter());
        reg3.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/third/fourth/*"});
        ServletRegistration.Dynamic firstServlet = servletContext.addServlet(SERVLET1_NAME, (Servlet)new MockServlet());
        firstServlet.addMapping(new String[]{"/first/*"});
        ServletRegistration.Dynamic secondServlet = servletContext.addServlet(SERVLET2_NAME, (Servlet)new MockServlet());
        secondServlet.addMapping(new String[]{"/second/*"});
        chainManager = new AwsFilterChainManager((AwsServletContext)servletContext);
    }

    @Test
    void paths_pathMatches_validPaths() {
        Assertions.assertTrue((boolean)chainManager.pathMatches("/users/123123123", "/users/*"));
        Assertions.assertTrue((boolean)chainManager.pathMatches("/apis/123/methods", "/apis/*"));
        Assertions.assertTrue((boolean)chainManager.pathMatches("/very/long/path/with/sub/resources", "/*"));
        Assertions.assertFalse((boolean)chainManager.pathMatches("/false/api", "/true/*"));
        Assertions.assertFalse((boolean)chainManager.pathMatches("/first/second/third", "/first/third/*"));
        Assertions.assertFalse((boolean)chainManager.pathMatches("/first/second/third", "/first/third/second"));
    }

    @Test
    void paths_pathMatches_invalidPaths() {
        Assertions.assertTrue((boolean)chainManager.pathMatches("_%Garbled%20Path_%", "/*"));
        Assertions.assertTrue((boolean)chainManager.pathMatches("<script>alert('message');</script>", "/*"));
        Assertions.assertFalse((boolean)chainManager.pathMatches("<script>alert('message');</script>", "/test/*"));
    }

    @Test
    void cacheKey_compare_samePath() {
        FilterChainManager.TargetCacheKey cacheKey = new FilterChainManager.TargetCacheKey();
        cacheKey.setDispatcherType(DispatcherType.REQUEST);
        cacheKey.setTargetPath("/first/path");
        FilterChainManager.TargetCacheKey secondCacheKey = new FilterChainManager.TargetCacheKey();
        secondCacheKey.setDispatcherType(DispatcherType.REQUEST);
        secondCacheKey.setTargetPath("/first/path");
        Assertions.assertEquals((int)cacheKey.hashCode(), (int)secondCacheKey.hashCode());
        Assertions.assertEquals((Object)cacheKey, (Object)secondCacheKey);
    }

    @Test
    void cacheKey_compare_differentDispatcher() {
        FilterChainManager.TargetCacheKey cacheKey = new FilterChainManager.TargetCacheKey();
        cacheKey.setDispatcherType(DispatcherType.REQUEST);
        cacheKey.setTargetPath("/first/path");
        FilterChainManager.TargetCacheKey secondCacheKey = new FilterChainManager.TargetCacheKey();
        secondCacheKey.setDispatcherType(DispatcherType.ASYNC);
        secondCacheKey.setTargetPath("/first/path");
        Assertions.assertNotEquals((int)cacheKey.hashCode(), (int)secondCacheKey.hashCode());
        Assertions.assertNotEquals((Object)cacheKey, (Object)secondCacheKey);
    }

    @Test
    void cacheKey_compare_differentServlet() {
        FilterChainManager.TargetCacheKey cacheKey = new FilterChainManager.TargetCacheKey();
        cacheKey.setDispatcherType(DispatcherType.REQUEST);
        cacheKey.setTargetPath("/first/path");
        cacheKey.setServletName("Dispatcher servlet");
        FilterChainManager.TargetCacheKey secondCacheKey = new FilterChainManager.TargetCacheKey();
        secondCacheKey.setDispatcherType(DispatcherType.REQUEST);
        secondCacheKey.setTargetPath("/first/path");
        cacheKey.setServletName("Real servlet");
        Assertions.assertNotEquals((int)cacheKey.hashCode(), (int)secondCacheKey.hashCode());
        Assertions.assertNotEquals((Object)cacheKey, (Object)secondCacheKey);
    }

    @Test
    void cacheKey_compare_additionalChars() {
        FilterChainManager.TargetCacheKey cacheKey = new FilterChainManager.TargetCacheKey();
        cacheKey.setDispatcherType(DispatcherType.REQUEST);
        cacheKey.setTargetPath("/first/path");
        FilterChainManager.TargetCacheKey secondCacheKey = new FilterChainManager.TargetCacheKey();
        secondCacheKey.setDispatcherType(DispatcherType.REQUEST);
        secondCacheKey.setTargetPath("/first/path/");
        Assertions.assertEquals((int)cacheKey.hashCode(), (int)secondCacheKey.hashCode());
        Assertions.assertEquals((Object)cacheKey, (Object)secondCacheKey);
        secondCacheKey.setTargetPath(" /first/path");
        Assertions.assertEquals((int)cacheKey.hashCode(), (int)secondCacheKey.hashCode());
        Assertions.assertEquals((Object)cacheKey, (Object)secondCacheKey);
        secondCacheKey.setTargetPath("first/path/");
        Assertions.assertEquals((int)cacheKey.hashCode(), (int)secondCacheKey.hashCode());
        Assertions.assertEquals((Object)cacheKey, (Object)secondCacheKey);
    }

    @Test
    void filterChain_getFilterChain_subsetOfFilters() {
        AwsProxyHttpServletRequest req = new AwsProxyHttpServletRequest(new AwsProxyRequestBuilder("/first/second", "GET").build(), lambdaContext, null);
        req.setServletContext(servletContext);
        FilterChainHolder fcHolder = chainManager.getFilterChain((HttpServletRequest)req, null);
        Assertions.assertEquals((int)1, (int)fcHolder.filterCount());
        Assertions.assertEquals((Object)"Filter1", (Object)fcHolder.getFilter(0).getFilterName());
        req = new AwsProxyHttpServletRequest(new AwsProxyRequestBuilder("/second/mime", "GET").build(), lambdaContext, null);
        fcHolder = chainManager.getFilterChain((HttpServletRequest)req, null);
        Assertions.assertEquals((int)1, (int)fcHolder.filterCount());
        Assertions.assertEquals((Object)"Filter2", (Object)fcHolder.getFilter(0).getFilterName());
        req = new AwsProxyHttpServletRequest(new AwsProxyRequestBuilder("/second/mime/third", "GET").build(), lambdaContext, null);
        fcHolder = chainManager.getFilterChain((HttpServletRequest)req, null);
        Assertions.assertEquals((int)1, (int)fcHolder.filterCount());
        Assertions.assertEquals((Object)"Filter2", (Object)fcHolder.getFilter(0).getFilterName());
    }

    @Test
    void filterChain_matchMultipleTimes_expectSameMatch() {
        AwsProxyHttpServletRequest req = new AwsProxyHttpServletRequest(new AwsProxyRequestBuilder("/first/second", "GET").build(), lambdaContext, null);
        req.setServletContext(servletContext);
        FilterChainHolder fcHolder = chainManager.getFilterChain((HttpServletRequest)req, null);
        Assertions.assertEquals((int)1, (int)fcHolder.filterCount());
        Assertions.assertEquals((Object)"Filter1", (Object)fcHolder.getFilter(0).getFilterName());
        AwsProxyHttpServletRequest req2 = new AwsProxyHttpServletRequest(new AwsProxyRequestBuilder("/first/second", "GET").build(), lambdaContext, null);
        req.setServletContext(servletContext);
        FilterChainHolder fcHolder2 = chainManager.getFilterChain((HttpServletRequest)req2, null);
        Assertions.assertEquals((int)1, (int)fcHolder2.filterCount());
        Assertions.assertEquals((Object)"Filter1", (Object)fcHolder2.getFilter(0).getFilterName());
    }

    @Test
    void filterChain_executeMultipleFilters_expectRunEachTime() {
        AwsProxyHttpServletRequest req = new AwsProxyHttpServletRequest(new AwsProxyRequestBuilder("/first/second", "GET").build(), lambdaContext, null);
        req.setServletContext(servletContext);
        FilterChainHolder fcHolder = chainManager.getFilterChain((HttpServletRequest)req, null);
        Assertions.assertEquals((int)1, (int)fcHolder.filterCount());
        Assertions.assertEquals((Object)"Filter1", (Object)fcHolder.getFilter(0).getFilterName());
        AwsHttpServletResponse resp = new AwsHttpServletResponse((HttpServletRequest)req, new CountDownLatch(1));
        try {
            fcHolder.doFilter((ServletRequest)req, (ServletResponse)resp);
        }
        catch (IOException e) {
            Assertions.fail((String)"IO Exception while executing filters");
            e.printStackTrace();
        }
        catch (ServletException e) {
            Assertions.fail((String)"Servlet exception while executing filters");
            e.printStackTrace();
        }
        Assertions.assertTrue((req.getAttribute(REQUEST_CUSTOM_ATTRIBUTE_NAME) != null ? 1 : 0) != 0);
        Assertions.assertEquals((Object)REQUEST_CUSTOM_ATTRIBUTE_VALUE, (Object)req.getAttribute(REQUEST_CUSTOM_ATTRIBUTE_NAME));
        this.log.debug("Starting second request");
        AwsProxyHttpServletRequest req2 = new AwsProxyHttpServletRequest(new AwsProxyRequestBuilder("/first/second", "GET").build(), lambdaContext, null);
        req2.setServletContext(servletContext);
        FilterChainHolder fcHolder2 = chainManager.getFilterChain((HttpServletRequest)req2, null);
        Assertions.assertEquals((int)1, (int)fcHolder2.filterCount());
        Assertions.assertEquals((Object)"Filter1", (Object)fcHolder2.getFilter(0).getFilterName());
        Assertions.assertEquals((int)-1, (int)fcHolder2.currentFilter);
        AwsHttpServletResponse resp2 = new AwsHttpServletResponse((HttpServletRequest)req, new CountDownLatch(1));
        try {
            fcHolder2.doFilter((ServletRequest)req2, (ServletResponse)resp2);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assertions.fail((String)"IO Exception while executing filters");
        }
        catch (ServletException e) {
            e.printStackTrace();
            Assertions.fail((String)"Servlet exception while executing filters");
        }
        Assertions.assertTrue((req2.getAttribute(REQUEST_CUSTOM_ATTRIBUTE_NAME) != null ? 1 : 0) != 0);
        Assertions.assertEquals((Object)REQUEST_CUSTOM_ATTRIBUTE_VALUE, (Object)req2.getAttribute(REQUEST_CUSTOM_ATTRIBUTE_NAME));
    }

    @Test
    void filterChain_multipleServlets_callsCorrectServlet() throws IOException, ServletException {
        MockServlet servlet1 = (MockServlet)((AwsServletRegistration)servletContext.getServletRegistration(SERVLET1_NAME)).getServlet();
        ServletConfig servlet1Config = ((AwsServletRegistration)servletContext.getServletRegistration(SERVLET1_NAME)).getServletConfig();
        servlet1.init(servlet1Config);
        MockServlet servlet2 = (MockServlet)((AwsServletRegistration)servletContext.getServletRegistration(SERVLET2_NAME)).getServlet();
        ServletConfig servlet2Config = ((AwsServletRegistration)servletContext.getServletRegistration(SERVLET2_NAME)).getServletConfig();
        servlet2.init(servlet2Config);
        AwsProxyHttpServletRequest req = new AwsProxyHttpServletRequest(new AwsProxyRequestBuilder("/", "GET").build(), lambdaContext, null);
        AwsHttpServletResponse resp = new AwsHttpServletResponse((HttpServletRequest)req, new CountDownLatch(1));
        FilterChainHolder servlet1filterChain = chainManager.getFilterChain((HttpServletRequest)req, (Servlet)servlet1);
        servlet1filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
        Assertions.assertEquals((int)1, (int)servlet1.getServiceCalls());
        Assertions.assertEquals((int)0, (int)servlet2.getServiceCalls());
        FilterChainHolder servlet2filterChain = chainManager.getFilterChain((HttpServletRequest)req, (Servlet)servlet2);
        servlet2filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
        Assertions.assertEquals((int)1, (int)servlet1.getServiceCalls());
        Assertions.assertEquals((int)1, (int)servlet2.getServiceCalls());
    }

    @Test
    void filterChain_getFilterChain_multipleFilters() {
        AwsProxyHttpServletRequest req = new AwsProxyHttpServletRequest(new AwsProxyRequestBuilder("/second/important", "GET").build(), lambdaContext, null);
        req.setServletContext(servletContext);
        FilterRegistration.Dynamic reg = req.getServletContext().addFilter("Filter4", (Filter)new MockFilter());
        reg.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/second/*"});
        FilterChainHolder fcHolder = chainManager.getFilterChain((HttpServletRequest)req, null);
        Assertions.assertEquals((int)2, (int)fcHolder.filterCount());
        Assertions.assertEquals((Object)"Filter2", (Object)fcHolder.getFilter(0).getFilterName());
        Assertions.assertEquals((Object)"Filter4", (Object)fcHolder.getFilter(1).getFilterName());
        reg = req.getServletContext().addFilter("Filter5", (Filter)new MockFilter());
        reg.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/second/*"});
        fcHolder = chainManager.getFilterChain((HttpServletRequest)req, null);
        Assertions.assertEquals((int)3, (int)fcHolder.filterCount());
        Assertions.assertEquals((Object)"Filter2", (Object)fcHolder.getFilter(0).getFilterName());
        Assertions.assertEquals((Object)"Filter4", (Object)fcHolder.getFilter(1).getFilterName());
        Assertions.assertEquals((Object)"Filter5", (Object)fcHolder.getFilter(2).getFilterName());
    }

    static {
        lambdaContext = new MockLambdaContext();
    }

    private static class MockFilter
    implements Filter {
        private MockFilter() {
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            servletRequest.setAttribute(AwsFilterChainManagerTest.REQUEST_CUSTOM_ATTRIBUTE_NAME, (Object)AwsFilterChainManagerTest.REQUEST_CUSTOM_ATTRIBUTE_VALUE);
            filterChain.doFilter(servletRequest, servletResponse);
        }

        public void destroy() {
        }
    }
}

