/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.exceptions.InvalidRequestEventException;
import com.amazonaws.serverless.proxy.AwsProxyExceptionHandler;
import com.amazonaws.serverless.proxy.AwsProxySecurityContextWriter;
import com.amazonaws.serverless.proxy.ExceptionHandler;
import com.amazonaws.serverless.proxy.RequestReader;
import com.amazonaws.serverless.proxy.ResponseWriter;
import com.amazonaws.serverless.proxy.SecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.serverless.proxy.internal.servlet.AwsLambdaServletContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequestReader;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletResponseWriter;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletContext;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletContextTest;
import com.amazonaws.serverless.proxy.internal.testutils.AwsProxyRequestBuilder;
import com.amazonaws.serverless.proxy.internal.testutils.MockLambdaContext;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.services.lambda.runtime.Context;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AwsAsyncContextTest {
    private MockLambdaContext lambdaCtx = new MockLambdaContext();
    private MockContainerHandler handler = new MockContainerHandler();
    private AwsProxyHttpServletRequestReader reader = new AwsProxyHttpServletRequestReader();
    private AwsServletContextTest.TestServlet srv1 = new AwsServletContextTest.TestServlet("srv1");
    private AwsServletContextTest.TestServlet srv2 = new AwsServletContextTest.TestServlet("srv2");
    private AwsServletContext ctx = this.getCtx();

    @Test
    void dispatch_amendsPath() throws InvalidRequestEventException {
        AwsProxyHttpServletRequest req = (AwsProxyHttpServletRequest)this.reader.readRequest(new AwsProxyRequestBuilder("/srv1/hello", "GET").build(), null, (Context)this.lambdaCtx, LambdaContainerHandler.getContainerConfig());
        req.setResponse(this.handler.getContainerResponse((HttpServletRequest)req, new CountDownLatch(1)));
        req.setServletContext((ServletContext)this.ctx);
        req.setContainerHandler((AwsLambdaServletContainerHandler)this.handler);
        AsyncContext asyncCtx = req.startAsync();
        asyncCtx.dispatch("/srv4/hello");
        Assertions.assertEquals((Object)"/srv1/hello", (Object)req.getRequestURI());
    }

    private AwsServletContext getCtx() {
        AwsServletContext ctx = new AwsServletContext((AwsLambdaServletContainerHandler)this.handler);
        this.handler.setServletContext((ServletContext)ctx);
        ServletRegistration.Dynamic reg1 = ctx.addServlet("srv1", (Servlet)this.srv1);
        reg1.addMapping(new String[]{"/srv1"});
        ServletRegistration.Dynamic reg2 = ctx.addServlet("srv2", (Servlet)this.srv2);
        reg2.addMapping(new String[]{"/"});
        return ctx;
    }

    public static class MockContainerHandler
    extends AwsLambdaServletContainerHandler<AwsProxyRequest, AwsProxyResponse, HttpServletRequest, AwsHttpServletResponse> {
        private int desiredStatus = 200;
        private HttpServletResponse response;
        private Servlet selectedServlet;

        public MockContainerHandler() {
            super(AwsProxyRequest.class, AwsProxyResponse.class, (RequestReader)new AwsProxyHttpServletRequestReader(), (ResponseWriter)new AwsProxyHttpServletResponseWriter(), (SecurityContextWriter)new AwsProxySecurityContextWriter(), (ExceptionHandler)new AwsProxyExceptionHandler());
        }

        protected AwsHttpServletResponse getContainerResponse(HttpServletRequest request, CountDownLatch latch) {
            return new AwsHttpServletResponse(request, latch);
        }

        protected void doFilter(HttpServletRequest request, HttpServletResponse response, Servlet servlet) throws IOException, ServletException {
            this.selectedServlet = servlet;
            try {
                this.response = response;
                if (AwsProxyHttpServletRequest.class.isAssignableFrom(request.getClass())) {
                    ((AwsProxyHttpServletRequest)request).setResponse((AwsHttpServletResponse)this.response);
                }
                this.response.setStatus(this.desiredStatus);
                this.response.flushBuffer();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }

        protected void handleRequest(HttpServletRequest containerRequest, AwsHttpServletResponse containerResponse, Context lambdaContext) throws Exception {
        }

        public void initialize() throws ContainerInitializationException {
        }

        public void setDesiredStatus(int status) {
            this.desiredStatus = status;
        }

        public AwsHttpServletResponse getResponse() {
            return (AwsHttpServletResponse)this.response;
        }

        public Servlet getSelectedServlet() {
            return this.selectedServlet;
        }
    }
}

