/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.servlet.ApacheCombinedServletLogFormatter;
import com.amazonaws.serverless.proxy.model.ApiGatewayRequestIdentity;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyRequestContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ApacheCombinedServletLogFormatterTest {
    private ApacheCombinedServletLogFormatter sut;
    private HttpServletRequest mockServletRequest;
    private HttpServletResponse mockServletResponse;
    private AwsProxyRequest proxyRequest;
    private AwsProxyRequestContext context;

    @BeforeEach
    public void setup() {
        this.proxyRequest = new AwsProxyRequest();
        Clock fixedClock = Clock.fixed(Instant.ofEpochSecond(665888523L), ZoneId.of("UTC"));
        this.mockServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.context = new AwsProxyRequestContext();
        this.context.setIdentity(new ApiGatewayRequestIdentity());
        Mockito.when((Object)this.mockServletRequest.getAttribute((String)ArgumentMatchers.eq((Object)"com.amazonaws.apigateway.request.context"))).thenReturn((Object)this.context);
        Mockito.when((Object)this.mockServletRequest.getMethod()).thenReturn((Object)"GET");
        this.mockServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.proxyRequest.setRequestContext(this.context);
        this.sut = new ApacheCombinedServletLogFormatter(fixedClock);
    }

    @Test
    void logsCurrentTimeWhenContextNull() {
        this.proxyRequest.setRequestContext(null);
        String actual = this.sut.format(this.mockServletRequest, this.mockServletResponse, null);
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"[07/02/1991:01:02:03Z]"));
    }

    @Test
    void logsCurrentTimeWhenRequestTimeZero() {
        this.context.setRequestTimeEpoch(0L);
        String actual = this.sut.format(this.mockServletRequest, this.mockServletResponse, null);
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"[07/02/1991:01:02:03Z]"));
    }

    @Test
    void logsRequestTimeWhenRequestTimeEpochGreaterThanZero() {
        this.context.setRequestTimeEpoch(1563023494000L);
        String actual = this.sut.format(this.mockServletRequest, this.mockServletResponse, null);
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)"[13/07/2019:13:11:34Z]"));
    }
}

