/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.jaxrs;

import com.amazonaws.serverless.proxy.AwsHttpApiV2SecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.testutils.AwsProxyRequestBuilder;
import com.amazonaws.serverless.proxy.model.HttpApiV2ProxyRequest;
import jakarta.ws.rs.core.SecurityContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HttpApiV2SecurityContextTest {
    private static final String JWT_SUB_VALUE = "1234567890";
    HttpApiV2ProxyRequest EMPTY_AUTH = new AwsProxyRequestBuilder("/", "GET").toHttpApiV2Request();
    HttpApiV2ProxyRequest BASIC_AUTH = new AwsProxyRequestBuilder("/", "GET").authorizerPrincipal("test").toHttpApiV2Request();
    HttpApiV2ProxyRequest JWT_AUTH = new AwsProxyRequestBuilder("/", "GET").authorizerPrincipal("test").header("Authorization", "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiaWF0IjoxNTE2MjM5MDIyfQ.SflKxwRJSMeKKF2QT4fwpMeJf36POk6yJV_adQssw5c").toHttpApiV2Request();
    AwsHttpApiV2SecurityContextWriter contextWriter = new AwsHttpApiV2SecurityContextWriter();

    @Test
    void getAuthenticationScheme_nullAuth_nullSchema() {
        SecurityContext ctx = this.contextWriter.writeSecurityContext(this.EMPTY_AUTH, null);
        Assertions.assertNull((Object)ctx.getAuthenticationScheme());
        Assertions.assertNull((Object)ctx.getUserPrincipal());
        Assertions.assertFalse((boolean)ctx.isSecure());
    }

    @Test
    void getAuthenticationScheme_jwtAuth_correctSchema() {
        SecurityContext ctx = this.contextWriter.writeSecurityContext(this.BASIC_AUTH, null);
        Assertions.assertEquals((Object)"JWT", (Object)ctx.getAuthenticationScheme());
        Assertions.assertTrue((boolean)ctx.isSecure());
        Assertions.assertNull((Object)ctx.getUserPrincipal());
    }

    @Test
    void getPrincipal_parseJwt_returnsSub() {
        SecurityContext ctx = this.contextWriter.writeSecurityContext(this.JWT_AUTH, null);
        Assertions.assertEquals((Object)"JWT", (Object)ctx.getAuthenticationScheme());
        Assertions.assertTrue((boolean)ctx.isSecure());
        Assertions.assertEquals((Object)JWT_SUB_VALUE, (Object)ctx.getUserPrincipal().getName());
    }
}

